/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.fork;

import de.uka.ipd.sdq.simucomframework.Context;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.fork.ForkContext;
import de.uka.ipd.sdq.simulation.abstractsimengine.ISimProcess;
import org.apache.log4j.Logger;

public abstract class ForkedBehaviourProcess
extends SimuComSimProcess {
    protected final Context myContext;
    private final ISimProcess parentProcess;
    protected final String assemblyContextID;
    private final boolean isAsync;
    private boolean isTerminated = false;
    private static final Logger LOGGER = Logger.getLogger((String)ForkedBehaviourProcess.class.getName());

    public ForkedBehaviourProcess(Context myContext, String assemblyContextID, boolean isAsync) {
        super(myContext.getModel(), "Forked Behaviour", myContext.getThread().getRequestContext());
        this.currentSessionId = myContext.getThread().getCurrentSessionId();
        this.myContext = this.createForkContext(myContext);
        this.parentProcess = myContext.getThread();
        this.assemblyContextID = assemblyContextID;
        this.isAsync = isAsync;
    }

    protected Context createForkContext(Context myContext) {
        return new ForkContext(myContext, this);
    }

    public ForkedBehaviourProcess(Context myContext, String assemblyContextID, boolean isAsync, int priority) {
        this(myContext, assemblyContextID, isAsync);
        this.setPriority(priority);
    }

    @Override
    protected void internalLifeCycle() {
        this.executeBehaviour();
        this.isTerminated = true;
        if (!this.isAsync && !this.parentProcess.isTerminated() && this.simulationIsRunning()) {
            this.parentProcess.scheduleAt(0.0);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Asynch behaviour finished at simtime " + this.getModel().getSimulationControl().getCurrentSimulationTime()));
        }
    }

    private boolean simulationIsRunning() {
        return this.myContext.getModel().getSimulationControl().isRunning();
    }

    protected abstract void executeBehaviour();

    public boolean isAsync() {
        return this.isAsync;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }
}

