/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.probes;

import de.uka.ipd.sdq.simucomframework.resources.AbstractScheduledResource;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.Unit;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.BasicObjectStateProbe;

public class TakeScheduledResourceUtilization
extends BasicObjectStateProbe<AbstractScheduledResource, Double, Dimensionless> {
    public TakeScheduledResourceUtilization(AbstractScheduledResource scheduledResource) {
        super((Object)scheduledResource, MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE);
    }

    protected Measure<Double, Dimensionless> getBasicMeasure(RequestContext measurementContext) {
        int allCores = ((AbstractScheduledResource)((Object)this.getStateObject())).getNumberOfInstances();
        int utilizedCores = 0;
        int coreNumber = 0;
        while (coreNumber < allCores) {
            if (((AbstractScheduledResource)((Object)this.getStateObject())).getQueueLength(coreNumber) > 0L) {
                ++utilizedCores;
            }
            ++coreNumber;
        }
        return Measure.valueOf((double)((double)utilizedCores / (double)allCores), (Unit)Dimensionless.UNIT);
    }
}

