/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simucomframework.resources;

import de.uka.ipd.sdq.scheduler.IActiveResource;
import de.uka.ipd.sdq.scheduler.ISchedulableProcess;
import de.uka.ipd.sdq.scheduler.entities.SchedulerEntity;
import de.uka.ipd.sdq.scheduler.resources.active.AbstractActiveResource;
import de.uka.ipd.sdq.scheduler.sensors.IActiveResourceStateSensor;
import de.uka.ipd.sdq.simucomframework.SimuComSimProcess;
import de.uka.ipd.sdq.simucomframework.entities.SimuComEntity;
import de.uka.ipd.sdq.simucomframework.exceptions.FailureException;
import de.uka.ipd.sdq.simucomframework.model.SimuComModel;
import de.uka.ipd.sdq.simucomframework.resources.AbstractSimulatedResourceContainer;
import de.uka.ipd.sdq.simucomframework.resources.IDemandListener;
import de.uka.ipd.sdq.simucomframework.resources.IOverallUtilizationListener;
import de.uka.ipd.sdq.simucomframework.resources.IStateListener;
import de.uka.ipd.sdq.simucomframework.simucomstatus.ActiveResouce;
import de.uka.ipd.sdq.simucomframework.simucomstatus.SimucomstatusFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractScheduledResource
extends SimuComEntity
implements IActiveResourceStateSensor {
    private static final Logger LOGGER = Logger.getLogger((String)AbstractScheduledResource.class.getName());
    private final Map<Integer, List<IStateListener>> stateListener;
    private final List<IDemandListener> demandListener;
    private final List<IOverallUtilizationListener> overallUtilizationListener;
    private final boolean requiredByContainer;
    private final ActiveResouce myResourceStatus;
    private final IActiveResource aResource;
    private final String resourceTypeID;
    private final String resourceContainerID;
    private final String description;
    private final int numberOfInstances;
    private final String schedulingStrategyID;
    private final AbstractSimulatedResourceContainer resourceContainer;
    private boolean isStopped = false;
    private boolean isAvailable = true;

    public AbstractScheduledResource(SimuComModel myModel, String typeID, String resourceContainerID, String resourceTypeID, String description, String schedulingStrategyID, int numberOfInstances, boolean requiredByContainer) {
        super(myModel, typeID);
        this.description = description;
        this.numberOfInstances = numberOfInstances;
        this.schedulingStrategyID = schedulingStrategyID.equals("ProcessorSharing") ? "PROCESSOR_SHARING" : (schedulingStrategyID.equals("Delay") ? "DELAY" : schedulingStrategyID);
        this.resourceTypeID = resourceTypeID;
        this.resourceContainerID = resourceContainerID;
        this.requiredByContainer = requiredByContainer;
        if (LOGGER.isEnabledFor((Priority)Level.DEBUG)) {
            LOGGER.debug((Object)("Creating Simulated Active Resource: " + this.getName()));
        }
        this.myResourceStatus = SimucomstatusFactory.eINSTANCE.createActiveResouce();
        this.myResourceStatus.setId(this.getName());
        myModel.getSimulationStatus().getResourceStatus().getActiveResources().add((Object)this.myResourceStatus);
        this.resourceContainer = myModel.getResourceRegistry().getResourceContainer(resourceContainerID);
        if (this.resourceContainer == null && LOGGER.isEnabledFor((Priority)Level.WARN)) {
            LOGGER.warn((Object)("Resource container " + resourceContainerID + " is not available!"));
        }
        this.stateListener = new HashMap<Integer, List<IStateListener>>();
        int instance = 0;
        while (instance < numberOfInstances) {
            this.stateListener.put(instance, new ArrayList());
            ++instance;
        }
        this.overallUtilizationListener = new ArrayList<IOverallUtilizationListener>();
        this.demandListener = new ArrayList<IDemandListener>();
        this.aResource = this.createActiveResource(myModel);
        this.aResource.addObserver((IActiveResourceStateSensor)this);
    }

    public IActiveResource getUnderlyingResource() {
        return this.aResource;
    }

    protected abstract IActiveResource createActiveResource(SimuComModel var1);

    public abstract void consumeResource(SimuComSimProcess var1, int var2, Map<String, Serializable> var3, double var4);

    public abstract double getRemainingDemandForProcess(SimuComSimProcess var1);

    public abstract void updateDemand(SimuComSimProcess var1, double var2);

    protected abstract double calculateDemand(double var1);

    public void activateResource() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Starting resource " + this.getName()));
        }
    }

    public void deactivateResource() {
        if (!this.isStopped) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Stopping resource " + this.getName()));
            }
            this.isStopped = true;
            int instance = 0;
            while (instance < this.numberOfInstances) {
                this.fireStateEvent(0L, instance);
                ++instance;
            }
            this.getModel().getSimulationStatus().getResourceStatus().getActiveResources().remove((Object)this.myResourceStatus);
        }
    }

    public abstract IActiveResource getScheduledResource();

    public void setAvailable(boolean isAvailable) {
        String status;
        this.isAvailable = isAvailable;
        double time = this.getModel().getSimulationControl().getCurrentSimulationTime();
        String string = status = this.isAvailable ? "available" : "unavailable";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Resource " + this.getName() + " " + status + " at sim time " + time));
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean isRequiredByContainer() {
        return this.requiredByContainer;
    }

    protected void assertAvailability() {
        if (!this.isAvailable) {
            FailureException.raise(this.getModel(), this.getModel().getFailureStatistics().getInternalHardwareFailureType(this.resourceContainerID, this.resourceTypeID));
        }
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public void addStateListener(IStateListener listener, int instance) {
        this.stateListener.get(instance).add(listener);
    }

    public void addOverallUtilizationListener(IOverallUtilizationListener listener) {
        this.overallUtilizationListener.add(listener);
    }

    protected void fireStateEvent(long queueLength, int instance) {
        for (IStateListener l : this.stateListener.get(instance)) {
            l.stateChanged(queueLength, instance);
        }
    }

    protected void fireOverallUtilization(double resourceDemand, double totalTime) {
        for (IOverallUtilizationListener l : this.overallUtilizationListener) {
            l.utilizationChanged(resourceDemand, totalTime);
        }
    }

    public void addDemandListener(IDemandListener listener) {
        this.demandListener.add(listener);
    }

    protected void fireDemand(double demand) {
        for (IDemandListener l : this.demandListener) {
            l.demand(demand);
        }
    }

    public void update(long state, int instanceId) {
        this.fireStateEvent(state, instanceId);
    }

    public void demandCompleted(ISchedulableProcess simProcess) {
        for (IDemandListener l : this.demandListener) {
            l.demandCompleted(simProcess);
        }
    }

    public String getResourceTypeId() {
        return this.resourceTypeID;
    }

    public String getSchedulingStrategyID() {
        return this.schedulingStrategyID;
    }

    public long getQueueLength(int coreID) {
        return this.aResource.getQueueLengthFor((SchedulerEntity)((AbstractActiveResource)this.getScheduledResource()), coreID);
    }
}

