/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.simulation.abstractsimengine.desmoj;

import de.uka.ipd.sdq.simulation.abstractsimengine.AbstractSimProcessDelegator;
import de.uka.ipd.sdq.simulation.abstractsimengine.desmoj.DesmoJExperiment;
import de.uka.ipd.sdq.simulation.abstractsimengine.desmoj.DesmoJModel;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.ISimProcessStrategy;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.ProcessState;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.SimProcessThreadingStrategy;
import de.uka.ipd.sdq.simulation.abstractsimengine.processes.SimulatedProcess;
import desmoj.core.simulator.ExternalEvent;
import desmoj.core.simulator.TimeSpan;

public class DesmoJSimProcess
extends SimulatedProcess {
    private AbstractSimProcessDelegator myAbstractProcess;
    private DesmoJModel model;
    private final DesmoJExperiment experiment;

    public DesmoJSimProcess(AbstractSimProcessDelegator process, DesmoJModel model, String name) {
        super((ISimProcessStrategy)new SimProcessThreadingStrategy());
        this.myAbstractProcess = process;
        this.model = model;
        this.experiment = (DesmoJExperiment)this.myAbstractProcess.getModel().getSimulationControl();
        this.startProcess(this.processStrategy);
    }

    public void scheduleAt(double delay) {
        if (!this.isTerminated()) {
            if (this.myProcessState != ProcessState.SUSPENDED) {
                throw new IllegalStateException("Tried to schedule thread which was not suspended [" + this.myAbstractProcess.getId() + "]");
            }
            if (!this.simIsRunning()) {
                this.resume();
            }
            new ExternalEvent(this.model, "TODO event name", false){

                public void eventRoutine() {
                    if (!DesmoJSimProcess.this.isTerminated()) {
                        DesmoJSimProcess.this.resume();
                    }
                }
            }.schedule(new TimeSpan(delay));
        }
    }

    public void passivate(double delay) {
        if (!this.isTerminated()) {
            if (this.myProcessState != ProcessState.RUNNING) {
                throw new IllegalStateException("Tried to passivate thread which was not running [" + this.myAbstractProcess.getId() + "]");
            }
            if (!this.simIsRunning()) {
                this.resume();
            }
            new ExternalEvent(this.model, "Passivate " + this.myAbstractProcess.getId(), false){

                public void eventRoutine() {
                    if (!DesmoJSimProcess.this.isTerminated()) {
                        DesmoJSimProcess.this.resume();
                    }
                }
            }.schedule(new TimeSpan(delay));
            this.suspend();
        }
    }

    private boolean simIsRunning() {
        return !this.experiment.getExperiment().isStopped();
    }

    protected AbstractSimProcessDelegator getAbstractProcess() {
        return this.myAbstractProcess;
    }

    public boolean isScheduled() {
        throw new UnsupportedOperationException();
    }

    public void reschedule(double delay) {
        throw new UnsupportedOperationException();
    }
}

