/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex.analyser.visitors;

import de.uka.ipd.sdq.probfunction.BoxedPDF;
import de.uka.ipd.sdq.probfunction.ContinuousPDF;
import de.uka.ipd.sdq.probfunction.ContinuousSample;
import de.uka.ipd.sdq.probfunction.ProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityFunction;
import de.uka.ipd.sdq.probfunction.ProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.ProbfunctionFactory;
import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.probfunction.math.IProbabilityDensityFunction;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IProbabilityMassFunction;
import de.uka.ipd.sdq.probfunction.math.ISample;
import de.uka.ipd.sdq.probfunction.math.ISamplePDF;
import de.uka.ipd.sdq.probfunction.math.exception.DifferentDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.DomainNotNumbersException;
import de.uka.ipd.sdq.probfunction.math.exception.DoubleSampleException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionNotInTimeDomainException;
import de.uka.ipd.sdq.probfunction.math.exception.FunctionsInDifferenDomainsException;
import de.uka.ipd.sdq.probfunction.math.exception.IncompatibleUnitsException;
import de.uka.ipd.sdq.probfunction.math.exception.ProbabilitySumNotOneException;
import de.uka.ipd.sdq.probfunction.math.exception.UnknownPDFTypeException;
import de.uka.ipd.sdq.stoex.Atom;
import de.uka.ipd.sdq.stoex.BoolLiteral;
import de.uka.ipd.sdq.stoex.BooleanOperatorExpression;
import de.uka.ipd.sdq.stoex.CompareExpression;
import de.uka.ipd.sdq.stoex.DoubleLiteral;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.FunctionLiteral;
import de.uka.ipd.sdq.stoex.IfElseExpression;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.NotExpression;
import de.uka.ipd.sdq.stoex.NumericLiteral;
import de.uka.ipd.sdq.stoex.Parenthesis;
import de.uka.ipd.sdq.stoex.PowerExpression;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import de.uka.ipd.sdq.stoex.ProductExpression;
import de.uka.ipd.sdq.stoex.StoexFactory;
import de.uka.ipd.sdq.stoex.StringLiteral;
import de.uka.ipd.sdq.stoex.TermExpression;
import de.uka.ipd.sdq.stoex.Variable;
import de.uka.ipd.sdq.stoex.analyser.operations.AddOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.AndOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.CompareOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.DivOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.EqualsOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.GreaterEqualOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.GreaterOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.LessEqualOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.LessOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.LogicalOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.ModOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.MultOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.NotEqualOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.OrOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.SubOperation;
import de.uka.ipd.sdq.stoex.analyser.operations.TermProductOperation;
import de.uka.ipd.sdq.stoex.analyser.probfunction.ProbfunctionHelper;
import de.uka.ipd.sdq.stoex.analyser.visitors.ExpressionSolvingFailedException;
import de.uka.ipd.sdq.stoex.analyser.visitors.StoExPrettyPrintVisitor;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeEnum;
import de.uka.ipd.sdq.stoex.analyser.visitors.TypeInferenceFailedException;
import de.uka.ipd.sdq.stoex.analyser.visitors.UnsupportedComputationException;
import de.uka.ipd.sdq.stoex.util.StoexSwitch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ExpressionSolveVisitor
extends StoexSwitch<Object> {
    private static final Logger LOGGER = Logger.getLogger((String)ExpressionSolveVisitor.class.getName());
    private static final int MAX_NUMBER_OF_SAMPLES_FOR_TRUNC = 1000;
    protected IProbabilityFunctionFactory iProbFuncFactory = IProbabilityFunctionFactory.eINSTANCE;
    protected ProbfunctionFactory probFuncFactory = ProbfunctionFactory.eINSTANCE;
    protected StoexFactory stocFactory = StoexFactory.eINSTANCE;
    protected HashMap<Expression, TypeEnum> typeAnnotation;

    public ExpressionSolveVisitor(HashMap<Expression, TypeEnum> typeAnn) {
        this.typeAnnotation = typeAnn;
    }

    public Object caseCompareExpression(CompareExpression expr) {
        CompareOperation op;
        String opName = expr.getOperation().getName();
        if (opName.equals("GREATER")) {
            op = new GreaterOperation();
        } else if (opName.equals("EQUALS")) {
            op = new EqualsOperation();
        } else if (opName.equals("LESS")) {
            op = new LessOperation();
        } else if (opName.equals("NOTEQUAL")) {
            op = new NotEqualOperation();
        } else if (opName.equals("GREATEREQUAL")) {
            op = new GreaterEqualOperation();
        } else if (opName.equals("LESSEQUAL")) {
            op = new LessEqualOperation();
        } else {
            throw new UnsupportedOperationException();
        }
        Expression left = (Expression)this.doSwitch((EObject)expr.getLeft());
        Expression right = (Expression)this.doSwitch((EObject)expr.getRight());
        return this.handleComparison(left, right, op);
    }

    public Object caseBooleanOperatorExpression(BooleanOperatorExpression expr) {
        LogicalOperation op;
        String opName = expr.getOperation().getName();
        if (opName.equals("AND")) {
            op = new AndOperation();
        } else if (opName.equals("OR")) {
            op = new OrOperation();
        } else {
            throw new UnsupportedOperationException();
        }
        Expression left = (Expression)this.doSwitch((EObject)expr.getLeft());
        Expression right = (Expression)this.doSwitch((EObject)expr.getRight());
        return this.handleLogical(left, right, op);
    }

    public Object caseTermExpression(TermExpression expr) {
        TermProductOperation op;
        String opName = expr.getOperation().getName();
        if (opName.equals("ADD")) {
            op = new AddOperation();
        } else if (opName.equals("SUB")) {
            op = new SubOperation();
        } else {
            throw new UnsupportedOperationException();
        }
        Expression left = (Expression)this.doSwitch((EObject)expr.getLeft());
        Expression right = (Expression)this.doSwitch((EObject)expr.getRight());
        TypeEnum exprType = this.typeAnnotation.get(expr);
        return this.handleComputation(exprType, left, right, op);
    }

    public Object caseProductExpression(ProductExpression expr) {
        TermProductOperation op;
        String opName = expr.getOperation().getName();
        if (opName.equals("MULT")) {
            op = new MultOperation();
        } else if (opName.equals("DIV")) {
            op = new DivOperation();
        } else if (opName.equals("MOD")) {
            op = new ModOperation();
        } else {
            throw new UnsupportedOperationException();
        }
        Expression left = (Expression)this.doSwitch((EObject)expr.getLeft());
        Expression right = (Expression)this.doSwitch((EObject)expr.getRight());
        TypeEnum exprType = this.typeAnnotation.get(expr);
        return this.handleComputation(exprType, left, right, op);
    }

    public Object caseIfElseExpression(IfElseExpression expr) {
        ProbabilityFunctionLiteral conditionExpr = (ProbabilityFunctionLiteral)this.doSwitch((EObject)expr.getConditionExpression());
        ProbabilityMassFunction pmf = (ProbabilityMassFunction)conditionExpr.getFunction_ProbabilityFunctionLiteral();
        double ifProb = 1.0;
        EList points = pmf.getSamples();
        for (Sample point : points) {
            String bool = point.getValue().toString();
            if (!bool.toLowerCase().equals("true")) continue;
            ifProb = point.getProbability();
        }
        Expression ifExpr = (Expression)this.doSwitch((EObject)expr.getIfExpression());
        Expression elseExpr = (Expression)this.doSwitch((EObject)expr.getElseExpression());
        if (ifExpr instanceof NumericLiteral && elseExpr instanceof NumericLiteral) {
            ArrayList<ISample> newPoints = new ArrayList<ISample>();
            double ifValue = this.getDoubleFromNumericLiteral(ifExpr);
            newPoints.add(this.iProbFuncFactory.createSample((Object)ifValue, ifProb));
            double elseValue = this.getDoubleFromNumericLiteral(elseExpr);
            newPoints.add(this.iProbFuncFactory.createSample((Object)elseValue, 1.0 - ifProb));
            IProbabilityMassFunction iPMF = this.iProbFuncFactory.createProbabilityMassFunction(newPoints, null, false);
            ProbabilityMassFunction resultPMF = this.iProbFuncFactory.transformToModelPMF(iPMF);
            ProbabilityFunctionLiteral resultPMFLiteral = this.stocFactory.createProbabilityFunctionLiteral();
            resultPMFLiteral.setFunction_ProbabilityFunctionLiteral((ProbabilityFunction)resultPMF);
            return resultPMFLiteral;
        }
        throw new UnsupportedOperationException();
    }

    public Object caseParenthesis(Parenthesis parenthesis) {
        Expression child = (Expression)this.doSwitch((EObject)parenthesis.getInnerExpression());
        return child;
    }

    public Object caseVariable(Variable var) {
        return var;
    }

    public Object caseBoolLiteral(BoolLiteral bl) {
        EqualsOperation eo = new EqualsOperation();
        IProbabilityMassFunction iPMF = null;
        iPMF = bl.isValue() ? eo.getBoolPMF(1.0) : eo.getBoolPMF(0.0);
        return this.createLiteralForIPMF(iPMF);
    }

    public Object caseIntLiteral(IntLiteral il) {
        return il;
    }

    public Object caseDoubleLiteral(DoubleLiteral dl) {
        return dl;
    }

    public Object caseStringLiteral(StringLiteral object) {
        return object;
    }

    public Object caseProbabilityFunctionLiteral(ProbabilityFunctionLiteral probFuncLit) {
        return probFuncLit;
    }

    public Object casePowerExpression(PowerExpression expr) {
        Expression base = (Expression)this.doSwitch((EObject)expr.getBase());
        Expression exponent = (Expression)this.doSwitch((EObject)expr.getExponent());
        try {
            double baseValue = this.getDoubleFromNumericLiteral(base);
            double exponentValue = this.getDoubleFromNumericLiteral(exponent);
            DoubleLiteral doubleLiteral = StoexFactory.eINSTANCE.createDoubleLiteral();
            doubleLiteral.setValue(Math.pow(baseValue, exponentValue));
            return doubleLiteral;
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("Cannot calculate power expression " + expr.toString() + " because either the base or the exponent cannot be cast to a double. Underlying reason: ", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Atom caseFunctionLiteral(FunctionLiteral object) {
        IntLiteral intLit;
        Expression solvedParam;
        for (Expression e : object.getParameters_FunctionLiteral()) {
            this.doSwitch((EObject)e);
        }
        ArrayList<Expression> parameterList = new ArrayList<Expression>();
        for (Expression parameter : object.getParameters_FunctionLiteral()) {
            parameterList.add((Expression)this.doSwitch((EObject)parameter));
        }
        if (ProbfunctionHelper.isFunctionID(object.getId())) {
            ContinuousPDF func = ProbfunctionHelper.createFunction(parameterList, object.getId(), this.probFuncFactory);
            ProbabilityFunctionLiteral literal = StoexFactory.eINSTANCE.createProbabilityFunctionLiteral();
            literal.setFunction_ProbabilityFunctionLiteral((ProbabilityFunction)func);
            return literal;
        }
        if (object.getId().equals("Trunc")) {
            if (object.getParameters_FunctionLiteral().size() != 1) throw new ExpressionSolvingFailedException("Function Trunc is only supported supported for a single double parameter!", (Expression)object);
            solvedParam = (Expression)parameterList.get(0);
            if (solvedParam instanceof ProbabilityFunctionLiteral) {
                ProbabilityFunctionLiteral pfl = (ProbabilityFunctionLiteral)solvedParam;
                ProbabilityFunction insideFunction = pfl.getFunction_ProbabilityFunctionLiteral();
                if (!(insideFunction instanceof BoxedPDF)) return null;
                return this.truncPMFFromBoxedPDF((BoxedPDF)insideFunction, object);
            }
            if (solvedParam instanceof DoubleLiteral) {
                intLit = StoexFactory.eINSTANCE.createIntLiteral();
                intLit.setValue((int)Math.round(((DoubleLiteral)solvedParam).getValue()));
                return intLit;
            }
            if (!(solvedParam instanceof IntLiteral)) throw new ExpressionSolvingFailedException("Function Trunc is only supported supported for a DoublePDF or a single double parameter!", (Expression)object);
            return (IntLiteral)solvedParam;
        }
        if (object.getId().equals("Round")) {
            if (object.getParameters_FunctionLiteral().size() != 1) throw new ExpressionSolvingFailedException("Function Round is only supported supported for a single double parameter!", (Expression)object);
            solvedParam = (Expression)parameterList.get(0);
            if (!(solvedParam instanceof DoubleLiteral)) throw new ExpressionSolvingFailedException("Function Round is only supported supported for a single double parameter!", (Expression)object);
            intLit = StoexFactory.eINSTANCE.createIntLiteral();
            intLit.setValue((int)Math.round(((DoubleLiteral)solvedParam).getValue()));
            return intLit;
        }
        if (object.getId().equals("Ceil")) {
            if (object.getParameters_FunctionLiteral().size() != 1) throw new ExpressionSolvingFailedException("Function Ceil is only supported supported for a single double parameter!", (Expression)object);
            solvedParam = (Expression)parameterList.get(0);
            if (!(solvedParam instanceof DoubleLiteral)) throw new ExpressionSolvingFailedException("Function Ceil is only supported supported for a single double parameter!", (Expression)object);
            intLit = StoexFactory.eINSTANCE.createIntLiteral();
            intLit.setValue((int)Math.ceil(((DoubleLiteral)solvedParam).getValue()));
            return intLit;
        }
        if (object.getId().equals("Sqrt")) {
            if (object.getParameters_FunctionLiteral().size() != 1) throw new ExpressionSolvingFailedException("Function Sqrt is only supported supported for a single double parameter!", (Expression)object);
            solvedParam = (Expression)parameterList.get(0);
            if (!(solvedParam instanceof DoubleLiteral)) throw new ExpressionSolvingFailedException("Function Sqrt is only supported supported for a single double parameter!", (Expression)object);
            DoubleLiteral doubleLit = StoexFactory.eINSTANCE.createDoubleLiteral();
            doubleLit.setValue(Math.sqrt(((DoubleLiteral)solvedParam).getValue()));
            return doubleLit;
        }
        if (!object.getId().equals("Log")) throw new UnsupportedOperationException(String.valueOf(((Object)((Object)this)).getClass().getName()) + ": Function " + object.getId() + " not supported!");
        if (object.getParameters_FunctionLiteral().size() != 2) throw new ExpressionSolvingFailedException("Function Log is only supported supported for two double parameters: base, value!", (Expression)object);
        Expression base = (Expression)parameterList.get(0);
        Expression value = (Expression)parameterList.get(1);
        if (!(base instanceof DoubleLiteral) || !(value instanceof DoubleLiteral)) throw new ExpressionSolvingFailedException("Function Ceil is only supported supported for a single double parameter!", (Expression)object);
        DoubleLiteral result = StoexFactory.eINSTANCE.createDoubleLiteral();
        result.setValue(Math.log(((DoubleLiteral)value).getValue()) / Math.log(((DoubleLiteral)base).getValue()));
        return result;
    }

    public Object caseNotExpression(NotExpression notExpression) {
        Expression child = (Expression)this.doSwitch((EObject)notExpression.getInner());
        if (child instanceof ProbabilityFunctionLiteral) {
            IProbabilityMassFunction massFunction = this.extractIPMFFromLiteral(child);
            IProbabilityMassFunction invertedFunction = CompareOperation.invertBoolPMF(massFunction);
            return this.createLiteralForIPMF(invertedFunction);
        }
        throw new UnsupportedComputationException((Expression)notExpression, "NOT");
    }

    private ProbabilityFunctionLiteral truncPMFFromBoxedPDF(BoxedPDF pdf, FunctionLiteral object) {
        EList samples = pdf.getSamples();
        if (samples.size() == 0) {
            throw new ExpressionSolvingFailedException("Cannot handle an empty DoublePDF for Trunc.", (Expression)object);
        }
        double leftBorder = ((ContinuousSample)samples.get(0)).getProbability() > 0.0 ? ((ContinuousSample)samples.get(0)).getValue() : 0.0;
        int range = (int)Math.ceil(((ContinuousSample)samples.get(samples.size() - 1)).getValue() - leftBorder);
        int distance = range / 1000 + 1;
        ISamplePDF samplePDF = null;
        try {
            samplePDF = this.iProbFuncFactory.transformToSamplePDF(this.iProbFuncFactory.transformToPDF((ProbabilityDensityFunction)pdf), (double)distance);
        }
        catch (Exception e) {
            throw new ExpressionSolvingFailedException((Expression)object, e);
        }
        if (samplePDF.getLowerDomainBorder() < 0.0) {
            throw new ExpressionSolvingFailedException("Cannot Trunc a DoublePDF with negative values.", (Expression)object);
        }
        if (samplePDF.getDistance() != (double)distance) {
            throw new ExpressionSolvingFailedException("Bug! Distance of SamplePDF is not " + distance, (Expression)object);
        }
        ProbabilityMassFunction pmf = this.probFuncFactory.createProbabilityMassFunction();
        pmf.setOrderedDomain(true);
        List probabilities = samplePDF.getValuesAsDouble();
        int numberOfSamples = samplePDF.numberOfSamples();
        int i = 0;
        while (i < numberOfSamples) {
            Sample sample = this.probFuncFactory.createSample();
            sample.setProbability(((Double)probabilities.get(i)).doubleValue());
            sample.setValue((Object)(i * distance));
            pmf.getSamples().add((Object)sample);
            ++i;
        }
        ProbabilityFunctionLiteral literal = StoexFactory.eINSTANCE.createProbabilityFunctionLiteral();
        literal.setFunction_ProbabilityFunctionLiteral((ProbabilityFunction)pmf);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Trunc result: " + new StoExPrettyPrintVisitor().doSwitch((EObject)literal)));
        }
        return literal;
    }

    private double getDoubleFromNumericLiteral(Expression base) {
        if (base instanceof IntLiteral) {
            IntLiteral intLiteral = (IntLiteral)base;
            Integer intValue = intLiteral.getValue();
            return intValue.doubleValue();
        }
        if (base instanceof DoubleLiteral) {
            DoubleLiteral doubleLiteral = (DoubleLiteral)base;
            return doubleLiteral.getValue();
        }
        throw new UnsupportedOperationException("The value " + base + " cannot be cast to an Integer or Double.");
    }

    private Object handleComparison(Expression left, Expression right, CompareOperation op) {
        IProbabilityMassFunction iPMF = null;
        if (this.isIntDouble(left) && this.isIntDouble(right)) {
            iPMF = op.compare(this.extractDoubleFromLiteral(left), this.extractDoubleFromLiteral(right));
        } else if (this.isProbFunc(left) && this.isIntDouble(right)) {
            iPMF = op.compare(this.extractIPMFFromLiteral(left), this.extractDoubleFromLiteral(right));
        } else if (this.isIntDouble(left) && this.isProbFunc(right)) {
            iPMF = op.compare(this.extractDoubleFromLiteral(left), this.extractIPMFFromLiteral(right));
        } else if (this.isProbFunc(left) && this.isProbFunc(right)) {
            iPMF = op.compare(this.extractIPMFFromLiteral(left), this.extractIPMFFromLiteral(right));
        } else if (this.isString(left) && this.isString(right)) {
            iPMF = op.compare(this.extractStringFromLiteral(left), this.extractStringFromLiteral(right));
        } else if (this.isString(left) && this.isProbFunc(right)) {
            iPMF = op.compare(this.extractStringFromLiteral(left), this.extractIPMFFromLiteral(right));
        } else if (this.isString(right) && this.isProbFunc(left)) {
            iPMF = op.compare(this.extractStringFromLiteral(right), this.extractIPMFFromLiteral(left));
        } else {
            throw new UnsupportedOperationException();
        }
        return this.createLiteralForIPMF(iPMF);
    }

    private Object handleLogical(Expression left, Expression right, LogicalOperation op) {
        IProbabilityMassFunction iPMF = null;
        if (!this.isProbFunc(left) || !this.isProbFunc(right)) {
            throw new UnsupportedOperationException();
        }
        iPMF = op.evaluate(this.extractIPMFFromLiteral(left), this.extractIPMFFromLiteral(right));
        return this.createLiteralForIPMF(iPMF);
    }

    private String extractStringFromLiteral(Expression left) {
        return ((StringLiteral)left).getValue();
    }

    private boolean isString(Expression expr) {
        return expr instanceof StringLiteral;
    }

    private Expression handleComputation(TypeEnum exprType, Expression left, Expression right, TermProductOperation op) {
        if (exprType == null || exprType == TypeEnum.ANY_PMF) {
            if (left instanceof ProbabilityFunctionLiteral) {
                exprType = this.resolveActualType(exprType, left);
            } else if (right instanceof ProbabilityFunctionLiteral) {
                exprType = this.resolveActualType(exprType, right);
            } else if (left instanceof FunctionLiteral) {
                exprType = ProbfunctionHelper.isFunctionID(((FunctionLiteral)left).getId()) ? TypeEnum.CONTINOUS_PROBFUNCTION : TypeEnum.AUX_FUNCTION;
            } else if (right instanceof FunctionLiteral) {
                exprType = ProbfunctionHelper.isFunctionID(((FunctionLiteral)right).getId()) ? TypeEnum.CONTINOUS_PROBFUNCTION : TypeEnum.AUX_FUNCTION;
            } else if (left instanceof IntLiteral && right instanceof IntLiteral) {
                exprType = TypeEnum.INT;
            } else if (left instanceof NumericLiteral && right instanceof NumericLiteral) {
                exprType = TypeEnum.DOUBLE;
            } else {
                throw new UnsupportedComputationException(right, left, op, exprType);
            }
        }
        switch (exprType) {
            case INT: {
                return this.handle(this.extractIntFromLiteral(left), this.extractIntFromLiteral(right), op);
            }
            case DOUBLE: {
                return this.handle(this.extractDoubleFromLiteral(left), this.extractDoubleFromLiteral(right), op);
            }
            case ANY_PMF: {
                throw new UnsupportedComputationException(right, left, op, exprType);
            }
            case INT_PMF: {
                if (left instanceof IntLiteral && right instanceof IntLiteral) {
                    return this.handle(this.extractIntFromLiteral(left), this.extractIntFromLiteral(right), op);
                }
                if (left instanceof IntLiteral && right instanceof ProbabilityFunctionLiteral) {
                    return this.handle(this.extractIPMFFromLiteral(right), (double)this.extractIntFromLiteral(left), op);
                }
                if (left instanceof ProbabilityFunctionLiteral && right instanceof IntLiteral) {
                    return this.handle(this.extractIPMFFromLiteral(left), (double)this.extractIntFromLiteral(right), op);
                }
                if (left instanceof ProbabilityFunctionLiteral && right instanceof ProbabilityFunctionLiteral) {
                    return this.handle(this.extractIPMFFromLiteral(left), this.extractIPMFFromLiteral(right), op);
                }
                if (left instanceof NumericLiteral && right instanceof ProbabilityFunctionLiteral) {
                    return this.handle(this.extractIPMFFromLiteral(right), this.extractDoubleFromLiteral(left), op);
                }
                if (left instanceof ProbabilityFunctionLiteral && right instanceof NumericLiteral) {
                    return this.handle(this.extractIPMFFromLiteral(left), this.extractDoubleFromLiteral(right), op);
                }
                throw new UnsupportedComputationException(right, left, op, exprType);
            }
            case DOUBLE_PMF: {
                if (left instanceof NumericLiteral && right instanceof NumericLiteral) {
                    return this.handle(this.extractDoubleFromLiteral(left), this.extractDoubleFromLiteral(right), op);
                }
                if (left instanceof ProbabilityFunctionLiteral && right instanceof NumericLiteral) {
                    return this.handle(this.extractIPMFFromLiteral(left), this.extractDoubleFromLiteral(right), op);
                }
                if (left instanceof NumericLiteral && right instanceof ProbabilityFunctionLiteral) {
                    return this.handle(this.extractIPMFFromLiteral(right), this.extractDoubleFromLiteral(left), op);
                }
                if (left instanceof ProbabilityFunctionLiteral && right instanceof ProbabilityFunctionLiteral) {
                    return this.handle(this.extractIPMFFromLiteral(left), this.extractIPMFFromLiteral(right), op);
                }
                throw new UnsupportedComputationException(right, left, op, exprType);
            }
            case DOUBLE_PDF: {
                if (left instanceof ProbabilityFunctionLiteral) {
                    if (right instanceof IntLiteral) {
                        return this.handle(this.extractIPDFFromLiteral(left), (double)this.extractIntFromLiteral(right), op);
                    }
                    if (right instanceof DoubleLiteral) {
                        return this.handle(this.extractIPDFFromLiteral(left), this.extractDoubleFromLiteral(right), op);
                    }
                    if (right instanceof ProbabilityFunctionLiteral) {
                        return this.handle(this.extractIPDFFromLiteral(left), this.extractIPDFFromLiteral(right), op);
                    }
                    throw new UnsupportedComputationException(right, left, op, exprType);
                }
                if (right instanceof ProbabilityFunctionLiteral) {
                    if (left instanceof IntLiteral) {
                        return this.handle(this.extractIPDFFromLiteral(right), (double)this.extractIntFromLiteral(left), op);
                    }
                    if (left instanceof DoubleLiteral) {
                        return this.handle(this.extractIPDFFromLiteral(right), this.extractDoubleFromLiteral(left), op);
                    }
                    throw new UnsupportedComputationException(right, left, op, exprType);
                }
                throw new UnsupportedComputationException(right, left, op, exprType);
            }
            case CONTINOUS_PROBFUNCTION: {
                if (left instanceof FunctionLiteral) {
                    if (right instanceof IntLiteral) {
                        double rightDouble = ((IntLiteral)right).getValue();
                        return this.handle(this.extractIPDFFromLiteral((Expression)this.caseFunctionLiteral((FunctionLiteral)left)), rightDouble, op);
                    }
                    if (right instanceof DoubleLiteral) {
                        double rightDouble = ((DoubleLiteral)right).getValue();
                        return this.handle(this.extractIPDFFromLiteral((Expression)this.caseFunctionLiteral((FunctionLiteral)left)), rightDouble, op);
                    }
                    throw new UnsupportedOperationException("I can only apply operation " + op.getClass().getName() + " to a function and an number, not more.");
                }
                if (right instanceof FunctionLiteral) {
                    if (left instanceof IntLiteral) {
                        double leftDouble = ((IntLiteral)left).getValue();
                        return this.handle(this.extractIPDFFromLiteral((Expression)this.caseFunctionLiteral((FunctionLiteral)right)), leftDouble, op);
                    }
                    if (left instanceof DoubleLiteral) {
                        double leftDouble = ((DoubleLiteral)left).getValue();
                        return this.handle(this.extractIPDFFromLiteral((Expression)this.caseFunctionLiteral((FunctionLiteral)right)), leftDouble, op);
                    }
                    throw new UnsupportedOperationException("I can only apply operation " + op.getClass().getName() + " to a function and an number, not more.");
                }
                throw new UnsupportedComputationException(right, left, op, exprType);
            }
            case AUX_FUNCTION: {
                throw new UnsupportedOperationException("It is not yet supported to do calculations with auxiliary functions.");
            }
        }
        LOGGER.info((Object)"Found unhandled function type");
        return null;
    }

    private Expression handle(IProbabilityDensityFunction iLeftPDF, double right, TermProductOperation op) {
        IProbabilityDensityFunction resultIPDF = null;
        try {
            resultIPDF = op.compute(iLeftPDF, right);
        }
        catch (DomainNotNumbersException e) {
            LOGGER.error((Object)"Calculation with PDF and Literal failed!");
            e.printStackTrace();
        }
        return this.createLiteralForIPDF(resultIPDF);
    }

    private TypeEnum resolveActualType(TypeEnum exprType, Expression expr) {
        ProbabilityFunctionLiteral pfl = (ProbabilityFunctionLiteral)expr;
        ProbabilityFunction probFunc = pfl.getFunction_ProbabilityFunctionLiteral();
        if (probFunc instanceof ProbabilityMassFunction) {
            IProbabilityMassFunction iPMF = this.extractIPMFFromLiteral(expr);
            ISample samplePoint = (ISample)iPMF.getSamples().get(0);
            if (samplePoint.getValue() instanceof Integer) {
                exprType = TypeEnum.INT_PMF;
            } else if (samplePoint.getValue() instanceof Double) {
                exprType = TypeEnum.DOUBLE_PMF;
            }
            return exprType;
        }
        if (probFunc instanceof ProbabilityDensityFunction) {
            return TypeEnum.DOUBLE_PDF;
        }
        throw new UnsupportedOperationException();
    }

    private Expression handle(IProbabilityDensityFunction iLeftPDF, IProbabilityDensityFunction iRightPDF, TermProductOperation op) {
        IProbabilityDensityFunction resultIPDF = null;
        try {
            resultIPDF = op.compute(iLeftPDF, iRightPDF);
        }
        catch (FunctionsInDifferenDomainsException e) {
            LOGGER.error((Object)"Calculation with two PDFs failed!");
            e.printStackTrace();
        }
        catch (UnknownPDFTypeException e) {
            LOGGER.error((Object)"Calculation with two PDFs failed!");
            e.printStackTrace();
        }
        catch (IncompatibleUnitsException e) {
            LOGGER.error((Object)"Calculation with two PDFs failed!");
            e.printStackTrace();
        }
        return this.createLiteralForIPDF(resultIPDF);
    }

    private ProbabilityFunctionLiteral createLiteralForIPMF(IProbabilityMassFunction resultIPMF) {
        ProbabilityMassFunction resultPMF = this.iProbFuncFactory.transformToModelPMF(resultIPMF);
        ProbabilityFunctionLiteral resultPMFLiteral = this.stocFactory.createProbabilityFunctionLiteral();
        resultPMFLiteral.setFunction_ProbabilityFunctionLiteral((ProbabilityFunction)resultPMF);
        return resultPMFLiteral;
    }

    private Expression createLiteralForIPDF(IProbabilityDensityFunction iPDF) {
        ProbabilityDensityFunction pdf = null;
        try {
            pdf = this.iProbFuncFactory.transformToModelPDF(iPDF);
        }
        catch (UnknownPDFTypeException e) {
            e.printStackTrace();
        }
        catch (DoubleSampleException e) {
            e.printStackTrace();
        }
        catch (FunctionNotInTimeDomainException e) {
            e.printStackTrace();
        }
        ProbabilityFunctionLiteral resultPDFLiteral = this.stocFactory.createProbabilityFunctionLiteral();
        resultPDFLiteral.setFunction_ProbabilityFunctionLiteral((ProbabilityFunction)pdf);
        return resultPDFLiteral;
    }

    private ProbabilityFunctionLiteral handle(IProbabilityMassFunction iLeftPMF, IProbabilityMassFunction iRightPMF, TermProductOperation operation) {
        IProbabilityMassFunction resultIPMF = null;
        try {
            resultIPMF = operation.compute(iLeftPMF, iRightPMF);
        }
        catch (DifferentDomainsException e) {
            LOGGER.error((Object)"Calculation with two PMFs failed!");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return this.createLiteralForIPMF(resultIPMF);
    }

    private ProbabilityFunctionLiteral handle(IProbabilityMassFunction iIntPMF, double doubleValue, TermProductOperation operation) {
        IProbabilityMassFunction resultIPMF = null;
        try {
            resultIPMF = operation.compute(iIntPMF, doubleValue);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Calculation with PMF and double failed!");
            e.printStackTrace();
        }
        return this.createLiteralForIPMF(resultIPMF);
    }

    private DoubleLiteral handle(double leftValue, double rightValue, TermProductOperation operation) {
        DoubleLiteral result = this.stocFactory.createDoubleLiteral();
        double resultValue = operation.compute(leftValue, rightValue);
        result.setValue(resultValue);
        return result;
    }

    private IntLiteral handle(int leftValue, int rightValue, TermProductOperation operation) {
        IntLiteral result = this.stocFactory.createIntLiteral();
        int resultValue = operation.compute(leftValue, rightValue);
        result.setValue(resultValue);
        return result;
    }

    private boolean isProbFunc(Expression expr) {
        return expr instanceof ProbabilityFunctionLiteral;
    }

    private boolean isIntDouble(Expression expr) {
        return expr instanceof IntLiteral || expr instanceof DoubleLiteral;
    }

    private double extractDoubleFromLiteral(Expression expr) {
        if (expr instanceof IntLiteral) {
            return ((IntLiteral)expr).getValue();
        }
        if (expr instanceof DoubleLiteral) {
            return ((DoubleLiteral)expr).getValue();
        }
        LOGGER.error((Object)"Could not get Double value from NumericLiteral!");
        return 0.0;
    }

    private int extractIntFromLiteral(Expression expr) {
        return ((IntLiteral)expr).getValue();
    }

    private IProbabilityMassFunction extractIPMFFromLiteral(Expression expr) {
        ProbabilityFunctionLiteral probFuncLiteral = (ProbabilityFunctionLiteral)expr;
        ProbabilityFunction function = probFuncLiteral.getFunction_ProbabilityFunctionLiteral();
        if (function instanceof ProbabilityMassFunction) {
            ProbabilityMassFunction pmf = (ProbabilityMassFunction)function;
            return this.iProbFuncFactory.transformToPMF(pmf);
        }
        if (function instanceof ProbabilityDensityFunction) {
            String msg = "Could not transform expression to PMF. Note that NUMBER_OF_ELEMENT and BYTESIZE characterisations are assumed to be PMFs and must not be PDFs. Maybe you need to fix your models here.";
            LOGGER.error((Object)"Could not transform expression to PMF. Note that NUMBER_OF_ELEMENT and BYTESIZE characterisations are assumed to be PMFs and must not be PDFs. Maybe you need to fix your models here.");
            throw new TypeInferenceFailedException(expr, "Could not transform expression to PMF. Note that NUMBER_OF_ELEMENT and BYTESIZE characterisations are assumed to be PMFs and must not be PDFs. Maybe you need to fix your models here.");
        }
        String msg = "Unknown ProbabilityFunction subclass " + function.getClass().getName() + " that cannot be handled by " + ((Object)((Object)this)).getClass().getName();
        LOGGER.error((Object)msg);
        throw new TypeInferenceFailedException(expr, msg);
    }

    private IProbabilityDensityFunction extractIPDFFromLiteral(Expression expr) {
        ProbabilityFunctionLiteral pfl = (ProbabilityFunctionLiteral)expr;
        ProbabilityDensityFunction pdf = (ProbabilityDensityFunction)pfl.getFunction_ProbabilityFunctionLiteral();
        IProbabilityDensityFunction ipdf = null;
        try {
            ipdf = this.iProbFuncFactory.transformToPDF(pdf);
        }
        catch (UnknownPDFTypeException e) {
            e.printStackTrace();
        }
        catch (ProbabilitySumNotOneException e) {
            e.printStackTrace();
        }
        catch (DoubleSampleException e) {
            e.printStackTrace();
        }
        return ipdf;
    }
}

