/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.stoex.analyser.visitors;

import de.uka.ipd.sdq.probfunction.print.ProbFunctionPrettyPrint;
import de.uka.ipd.sdq.stoex.BoolLiteral;
import de.uka.ipd.sdq.stoex.BooleanOperatorExpression;
import de.uka.ipd.sdq.stoex.CompareExpression;
import de.uka.ipd.sdq.stoex.DoubleLiteral;
import de.uka.ipd.sdq.stoex.Expression;
import de.uka.ipd.sdq.stoex.FunctionLiteral;
import de.uka.ipd.sdq.stoex.IfElseExpression;
import de.uka.ipd.sdq.stoex.IntLiteral;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.NegativeExpression;
import de.uka.ipd.sdq.stoex.NotExpression;
import de.uka.ipd.sdq.stoex.Parenthesis;
import de.uka.ipd.sdq.stoex.PowerExpression;
import de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral;
import de.uka.ipd.sdq.stoex.ProductExpression;
import de.uka.ipd.sdq.stoex.StringLiteral;
import de.uka.ipd.sdq.stoex.TermExpression;
import de.uka.ipd.sdq.stoex.Variable;
import de.uka.ipd.sdq.stoex.VariableReference;
import de.uka.ipd.sdq.stoex.util.StoexSwitch;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.emf.ecore.EObject;

public class StoExPrettyPrintVisitor
extends StoexSwitch<StringBuilder> {
    protected static final int AVERAGE_STOEX_SIZE = 30;
    protected final StringBuilder resultBuilder = new StringBuilder(30);
    protected static final DecimalFormat df = new DecimalFormat("#0.0###########", new DecimalFormatSymbols(Locale.US));

    public StringBuilder caseBoolLiteral(BoolLiteral object) {
        this.resultBuilder.append(object.isValue() ? "true" : "false");
        return this.resultBuilder;
    }

    public StringBuilder casePowerExpression(PowerExpression object) {
        this.doSwitch((EObject)object.getBase());
        this.resultBuilder.append(" ^ ");
        this.doSwitch((EObject)object.getExponent());
        return this.resultBuilder;
    }

    public StringBuilder caseStringLiteral(StringLiteral object) {
        this.resultBuilder.append("\"");
        this.resultBuilder.append(object.getValue());
        this.resultBuilder.append("\"");
        return this.resultBuilder;
    }

    public StringBuilder caseCompareExpression(CompareExpression object) {
        String op;
        switch (object.getOperation()) {
            case EQUALS: {
                op = " == ";
                break;
            }
            case GREATER: {
                op = " > ";
                break;
            }
            case GREATEREQUAL: {
                op = " >= ";
                break;
            }
            case LESS: {
                op = " < ";
                break;
            }
            case LESSEQUAL: {
                op = " <= ";
                break;
            }
            case NOTEQUAL: {
                op = " <> ";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported StoEx comparison detected.");
            }
        }
        this.doSwitch((EObject)object.getLeft());
        this.resultBuilder.append(op);
        this.doSwitch((EObject)object.getRight());
        return this.resultBuilder;
    }

    public StringBuilder caseDoubleLiteral(DoubleLiteral object) {
        this.resultBuilder.append(df.format(object.getValue()));
        return this.resultBuilder;
    }

    public StringBuilder caseIntLiteral(IntLiteral object) {
        this.resultBuilder.append(Integer.toString(object.getValue()));
        return this.resultBuilder;
    }

    public StringBuilder caseParenthesis(Parenthesis object) {
        this.resultBuilder.append("(");
        this.doSwitch((EObject)object.getInnerExpression());
        this.resultBuilder.append(")");
        return this.resultBuilder;
    }

    public StringBuilder caseProbabilityFunctionLiteral(ProbabilityFunctionLiteral object) {
        new ProbFunctionPrettyPrint(this.resultBuilder).doSwitch((EObject)object.getFunction_ProbabilityFunctionLiteral());
        return this.resultBuilder;
    }

    public StringBuilder caseProductExpression(ProductExpression object) {
        String op;
        switch (object.getOperation()) {
            case MULT: {
                op = " * ";
                break;
            }
            case MOD: {
                op = " % ";
                break;
            }
            case DIV: {
                op = " / ";
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator found in StoEx!");
            }
        }
        this.doSwitch((EObject)object.getLeft());
        this.resultBuilder.append(op);
        this.doSwitch((EObject)object.getRight());
        return this.resultBuilder;
    }

    public StringBuilder caseTermExpression(TermExpression object) {
        String op;
        switch (object.getOperation()) {
            case ADD: {
                op = " + ";
                break;
            }
            case SUB: {
                op = " - ";
                break;
            }
            default: {
                throw new RuntimeException("Unknown operator found in StoEx!");
            }
        }
        this.doSwitch((EObject)object.getLeft());
        this.resultBuilder.append(op);
        this.doSwitch((EObject)object.getRight());
        return this.resultBuilder;
    }

    public StringBuilder caseNamespaceReference(NamespaceReference object) {
        this.resultBuilder.append(object.getReferenceName());
        this.resultBuilder.append(".");
        this.doSwitch((EObject)object.getInnerReference_NamespaceReference());
        return this.resultBuilder;
    }

    public StringBuilder caseVariableReference(VariableReference object) {
        this.resultBuilder.append(object.getReferenceName());
        return this.resultBuilder;
    }

    public StringBuilder caseVariable(Variable object) {
        this.doSwitch((EObject)object.getId_Variable());
        return this.resultBuilder;
    }

    public StringBuilder caseBooleanOperatorExpression(BooleanOperatorExpression object) {
        this.doSwitch((EObject)object.getLeft());
        this.resultBuilder.append(" ");
        this.resultBuilder.append(object.getOperation().getLiteral());
        this.resultBuilder.append(" ");
        this.doSwitch((EObject)object.getRight());
        return this.resultBuilder;
    }

    public StringBuilder caseNegativeExpression(NegativeExpression object) {
        this.resultBuilder.append("-");
        this.doSwitch((EObject)object.getInner());
        return this.resultBuilder;
    }

    public StringBuilder caseNotExpression(NotExpression object) {
        this.resultBuilder.append("NOT ");
        this.doSwitch((EObject)object.getInner());
        return this.resultBuilder;
    }

    public StringBuilder caseFunctionLiteral(FunctionLiteral object) {
        this.resultBuilder.append(object.getId());
        this.resultBuilder.append("(");
        if (object.getParameters_FunctionLiteral().size() > 0) {
            for (Expression parameter : object.getParameters_FunctionLiteral()) {
                this.doSwitch((EObject)parameter);
                this.resultBuilder.append(", ");
            }
            this.resultBuilder.delete(this.resultBuilder.length() - 2, this.resultBuilder.length());
        }
        this.resultBuilder.append(")");
        return this.resultBuilder;
    }

    public StringBuilder caseIfElseExpression(IfElseExpression object) {
        this.doSwitch((EObject)object.getConditionExpression());
        this.resultBuilder.append(" ? ");
        this.doSwitch((EObject)object.getIfExpression());
        this.resultBuilder.append(" : ");
        this.doSwitch((EObject)object.getElseExpression());
        return this.resultBuilder;
    }
}

