/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package de.uka.ipd.sdq.stoex.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import de.uka.ipd.sdq.stoex.util.StoexAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class StoexItemProviderAdapterFactory extends StoexAdapterFactory implements ComposeableAdapterFactory,
IChangeNotifier, IDisposable {

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public static final String copyright = "Copyright 2007-2009, SDQ, IPD, U Karlsruhe";

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public StoexItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.stoex.VariableReference} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected VariableReferenceItemProvider variableReferenceItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.VariableReference}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createVariableReferenceAdapter() {
        if (this.variableReferenceItemProvider == null) {
            this.variableReferenceItemProvider = new VariableReferenceItemProvider(this);
        }

        return this.variableReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.stoex.NamespaceReference} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected NamespaceReferenceItemProvider namespaceReferenceItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.NamespaceReference}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNamespaceReferenceAdapter() {
        if (this.namespaceReferenceItemProvider == null) {
            this.namespaceReferenceItemProvider = new NamespaceReferenceItemProvider(this);
        }

        return this.namespaceReferenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.Variable}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected VariableItemProvider variableItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.Variable}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createVariableAdapter() {
        if (this.variableItemProvider == null) {
            this.variableItemProvider = new VariableItemProvider(this);
        }

        return this.variableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.TermExpression}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected TermExpressionItemProvider termExpressionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.TermExpression}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createTermExpressionAdapter() {
        if (this.termExpressionItemProvider == null) {
            this.termExpressionItemProvider = new TermExpressionItemProvider(this);
        }

        return this.termExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.RandomVariable}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected RandomVariableItemProvider randomVariableItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.RandomVariable}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createRandomVariableAdapter() {
        if (this.randomVariableItemProvider == null) {
            this.randomVariableItemProvider = new RandomVariableItemProvider(this);
        }

        return this.randomVariableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.stoex.ProductExpression} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected ProductExpressionItemProvider productExpressionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.ProductExpression}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createProductExpressionAdapter() {
        if (this.productExpressionItemProvider == null) {
            this.productExpressionItemProvider = new ProductExpressionItemProvider(this);
        }

        return this.productExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ProbabilityFunctionLiteralItemProvider probabilityFunctionLiteralItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.ProbabilityFunctionLiteral}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createProbabilityFunctionLiteralAdapter() {
        if (this.probabilityFunctionLiteralItemProvider == null) {
            this.probabilityFunctionLiteralItemProvider = new ProbabilityFunctionLiteralItemProvider(this);
        }

        return this.probabilityFunctionLiteralItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.Parenthesis}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ParenthesisItemProvider parenthesisItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.Parenthesis}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createParenthesisAdapter() {
        if (this.parenthesisItemProvider == null) {
            this.parenthesisItemProvider = new ParenthesisItemProvider(this);
        }

        return this.parenthesisItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.IntLiteral}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected IntLiteralItemProvider intLiteralItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.IntLiteral}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createIntLiteralAdapter() {
        if (this.intLiteralItemProvider == null) {
            this.intLiteralItemProvider = new IntLiteralItemProvider(this);
        }

        return this.intLiteralItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.DoubleLiteral}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected DoubleLiteralItemProvider doubleLiteralItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.DoubleLiteral}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDoubleLiteralAdapter() {
        if (this.doubleLiteralItemProvider == null) {
            this.doubleLiteralItemProvider = new DoubleLiteralItemProvider(this);
        }

        return this.doubleLiteralItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.stoex.CompareExpression} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected CompareExpressionItemProvider compareExpressionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.CompareExpression}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createCompareExpressionAdapter() {
        if (this.compareExpressionItemProvider == null) {
            this.compareExpressionItemProvider = new CompareExpressionItemProvider(this);
        }

        return this.compareExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.BoolLiteral}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected BoolLiteralItemProvider boolLiteralItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.BoolLiteral}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createBoolLiteralAdapter() {
        if (this.boolLiteralItemProvider == null) {
            this.boolLiteralItemProvider = new BoolLiteralItemProvider(this);
        }

        return this.boolLiteralItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.StringLiteral}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected StringLiteralItemProvider stringLiteralItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.StringLiteral}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createStringLiteralAdapter() {
        if (this.stringLiteralItemProvider == null) {
            this.stringLiteralItemProvider = new StringLiteralItemProvider(this);
        }

        return this.stringLiteralItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.PowerExpression}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected PowerExpressionItemProvider powerExpressionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.PowerExpression}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createPowerExpressionAdapter() {
        if (this.powerExpressionItemProvider == null) {
            this.powerExpressionItemProvider = new PowerExpressionItemProvider(this);
        }

        return this.powerExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.stoex.BooleanOperatorExpression} instances. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    protected BooleanOperatorExpressionItemProvider booleanOperatorExpressionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.BooleanOperatorExpression}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createBooleanOperatorExpressionAdapter() {
        if (this.booleanOperatorExpressionItemProvider == null) {
            this.booleanOperatorExpressionItemProvider = new BooleanOperatorExpressionItemProvider(this);
        }

        return this.booleanOperatorExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.NotExpression}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected NotExpressionItemProvider notExpressionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.NotExpression}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createNotExpressionAdapter() {
        if (this.notExpressionItemProvider == null) {
            this.notExpressionItemProvider = new NotExpressionItemProvider(this);
        }

        return this.notExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.stoex.NegativeExpression} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected NegativeExpressionItemProvider negativeExpressionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.NegativeExpression}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNegativeExpressionAdapter() {
        if (this.negativeExpressionItemProvider == null) {
            this.negativeExpressionItemProvider = new NegativeExpressionItemProvider(this);
        }

        return this.negativeExpressionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.stoex.FunctionLiteral}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected FunctionLiteralItemProvider functionLiteralItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.FunctionLiteral}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFunctionLiteralAdapter() {
        if (this.functionLiteralItemProvider == null) {
            this.functionLiteralItemProvider = new FunctionLiteralItemProvider(this);
        }

        return this.functionLiteralItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link de.uka.ipd.sdq.stoex.IfElseExpression} instances. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    protected IfElseExpressionItemProvider ifElseExpressionItemProvider;

    /**
     * This creates an adapter for a {@link de.uka.ipd.sdq.stoex.IfElseExpression}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createIfElseExpressionAdapter() {
        if (this.ifElseExpressionItemProvider == null) {
            this.ifElseExpressionItemProvider = new IfElseExpressionItemProvider(this);
        }

        return this.ifElseExpressionItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void dispose() {
        if (this.variableReferenceItemProvider != null) {
            this.variableReferenceItemProvider.dispose();
        }
        if (this.namespaceReferenceItemProvider != null) {
            this.namespaceReferenceItemProvider.dispose();
        }
        if (this.variableItemProvider != null) {
            this.variableItemProvider.dispose();
        }
        if (this.termExpressionItemProvider != null) {
            this.termExpressionItemProvider.dispose();
        }
        if (this.productExpressionItemProvider != null) {
            this.productExpressionItemProvider.dispose();
        }
        if (this.probabilityFunctionLiteralItemProvider != null) {
            this.probabilityFunctionLiteralItemProvider.dispose();
        }
        if (this.parenthesisItemProvider != null) {
            this.parenthesisItemProvider.dispose();
        }
        if (this.intLiteralItemProvider != null) {
            this.intLiteralItemProvider.dispose();
        }
        if (this.doubleLiteralItemProvider != null) {
            this.doubleLiteralItemProvider.dispose();
        }
        if (this.compareExpressionItemProvider != null) {
            this.compareExpressionItemProvider.dispose();
        }
        if (this.boolLiteralItemProvider != null) {
            this.boolLiteralItemProvider.dispose();
        }
        if (this.stringLiteralItemProvider != null) {
            this.stringLiteralItemProvider.dispose();
        }
        if (this.powerExpressionItemProvider != null) {
            this.powerExpressionItemProvider.dispose();
        }
        if (this.booleanOperatorExpressionItemProvider != null) {
            this.booleanOperatorExpressionItemProvider.dispose();
        }
        if (this.notExpressionItemProvider != null) {
            this.notExpressionItemProvider.dispose();
        }
        if (this.negativeExpressionItemProvider != null) {
            this.negativeExpressionItemProvider.dispose();
        }
        if (this.functionLiteralItemProvider != null) {
            this.functionLiteralItemProvider.dispose();
        }
        if (this.ifElseExpressionItemProvider != null) {
            this.ifElseExpressionItemProvider.dispose();
        }
        if (this.randomVariableItemProvider != null) {
            this.randomVariableItemProvider.dispose();
        }
    }

}
