/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.units;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnitNames implements Enumerator
{
    UNITLESS(0, "UNITLESS", ""),
    BYTE(1, "BYTE", "B"),
    SECOND(2, "SECOND", "s"),
    METER(3, "METER", "m");

    public static final String copyright = "Copyright 2007-2009, SDQ, IPD, U Karlsruhe";
    public static final int UNITLESS_VALUE = 0;
    public static final int BYTE_VALUE = 1;
    public static final int SECOND_VALUE = 2;
    public static final int METER_VALUE = 3;
    private static final UnitNames[] VALUES_ARRAY;
    public static final List<UnitNames> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnitNames[]{UNITLESS, BYTE, SECOND, METER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnitNames get(String literal) {
        UnitNames[] unitNamesArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            UnitNames result = unitNamesArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static UnitNames getByName(String name) {
        UnitNames[] unitNamesArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            UnitNames result = unitNamesArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static UnitNames get(int value) {
        switch (value) {
            case 0: {
                return UNITLESS;
            }
            case 1: {
                return BYTE;
            }
            case 2: {
                return SECOND;
            }
            case 3: {
                return METER;
            }
        }
        return null;
    }

    private UnitNames(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

