/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.oaw;

import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.AbstractQVTREngine;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvtr.QVTRScript;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class QVTRTransformation
extends AbstractWorkflowComponent {
    private static final Logger LOGGER = Logger.getLogger(QVTRTransformation.class);
    private static final String COMPONENT_NAME = "QVTRTransformation";
    private Boolean debug = false;
    private String qvtrScript = null;
    private AbstractQVTREngine qvtrEngineType = null;
    protected ResourceSet resourceSet;
    private final Collection<String> metaModels = new ArrayList<String>();
    private URI traceFileURI = null;
    private final Collection<String> inputModels = new ArrayList<String>();
    private final Collection<String> outputModels = new ArrayList<String>();

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        this.run(issues);
    }

    public void run(Issues issues) {
        LOGGER.info((Object)"Executing QVTR Transformation...");
        LOGGER.debug((Object)("Script: " + this.getQvtrScript()));
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        AbstractQVTREngine qvtrEngine = this.getQvtrEngineType();
        if (qvtrEngine == null) {
            issues.addError((WorkflowComponent)this, "No QVT-R Engine available.");
            return;
        }
        qvtrEngine.setDebug(this.getDebug());
        QVTRScript qvtrScriptLocal = new QVTRScript();
        qvtrScriptLocal.setMetaModels(this.getMetaModelsFromString(this.getMetaModelURIs()));
        qvtrScriptLocal.setQVTFile(this.getQvtrScript());
        qvtrEngine.setWorkingDirectory(this.getTraceFileURI());
        qvtrEngine.addModels(this.getResorces(this.inputModels));
        qvtrEngine.addModels(this.getAndCreateResorces(this.outputModels));
        qvtrEngine.addModels(this.getResorces(this.inputModels));
        qvtrEngine.setQVTRScript(qvtrScriptLocal);
        try {
            qvtrEngine.transform();
        }
        catch (Throwable e) {
            issues.addError((WorkflowComponent)this, "Error in mediniQVT Transformation", (Object)e);
            return;
        }
        LOGGER.info((Object)"Transformation executed successfully");
        issues.addInfo("Transformation executed successfully");
    }

    public void setTraceFileURI(String traceFileURI) {
        this.traceFileURI = URI.createURI((String)traceFileURI);
    }

    public URI getTraceFileURI() {
        return this.traceFileURI;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public Boolean getDebug() {
        return this.debug;
    }

    public void setQvtrScript(String qvtrScript) {
        this.qvtrScript = qvtrScript;
    }

    public String getQvtrScript() {
        return this.qvtrScript;
    }

    public AbstractQVTREngine getQvtrEngineType() {
        return this.qvtrEngineType;
    }

    public void setQvtrEngineType(AbstractQVTREngine qvtrEngineType) {
        this.qvtrEngineType = qvtrEngineType;
    }

    public Collection<String> getInputModels() {
        return this.inputModels;
    }

    public void addInputModels(String inputModels) {
        this.inputModels.add(inputModels);
    }

    public Collection<String> getOutputModels() {
        return this.outputModels;
    }

    public void setOutputModels(String outputModels) {
        this.outputModels.add(outputModels);
    }

    public Collection<String> getMetaModelURIs() {
        return this.metaModels;
    }

    public void addMetaModelURI(String metaModel) {
        this.metaModels.add(metaModel);
    }

    protected Collection<Object> getMetaModelsFromString(Collection<String> models) {
        ArrayList<Object> modelResources = new ArrayList<Object>();
        for (String model : models) {
            URI uri = URI.createURI((String)model, (boolean)false);
            EList objects = this.resourceSet.getResource(uri, true).getContents();
            for (EObject o : objects) {
                if (!(o instanceof EPackageImpl)) continue;
                EPackageImpl p = (EPackageImpl)o;
                modelResources.add(p);
            }
        }
        return modelResources;
    }

    private Collection<Resource> getResorces(Collection<String> models) {
        ArrayList<Resource> modelResources = new ArrayList<Resource>();
        for (String model : models) {
            URI uri = URI.createURI((String)model, (boolean)false);
            Resource r = this.resourceSet.getResource(uri, true);
            modelResources.add(r);
        }
        return modelResources;
    }

    private Collection<Resource> getAndCreateResorces(Collection<String> models) {
        ArrayList<Resource> modelResources = new ArrayList<Resource>();
        ResourceSetImpl rSet = new ResourceSetImpl();
        for (String model : models) {
            URI uri = URI.createURI((String)model, (boolean)false);
            Resource r = rSet.createResource(uri);
            modelResources.add(r);
        }
        return modelResources;
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }

    public void checkConfiguration(Issues issues) {
        if (this.qvtrScript == null) {
            issues.addError("QTRScript not set");
        }
    }
}

