/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.workflow.mdsd.xtext.generator;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.IJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.xtext.IBlackboardInteractingWorkflowComponent;
import de.uka.ipd.sdq.workflow.mdsd.xtext.MWE2BlackboardWorkflowComponentBridge;
import de.uka.ipd.sdq.workflow.mdsd.xtext.MWE2SequentialJob;
import de.uka.ipd.sdq.workflow.mdsd.xtext.MWE2WorkflowComponentBridge;
import de.uka.ipd.sdq.workflow.mdsd.xtext.generator.BlackboardReader;
import de.uka.ipd.sdq.workflow.mdsd.xtext.generator.PrepareXTextPartitionJob;
import de.uka.ipd.sdq.workflow.mdsd.xtext.generator.XTextGeneratorConfiguration;
import de.uka.ipd.sdq.workflow.mdsd.xtext.generator.XTextGeneratorSupport;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.emf.mwe2.runtime.workflow.WorkflowContextImpl;
import org.eclipse.xtext.generator.GeneratorComponent;

public class XTextGeneratorBlackboardJob
extends MWE2SequentialJob
implements IBlackboardInteractingJob<MDSDBlackboard> {
    private MDSDBlackboard blackboard;

    public XTextGeneratorBlackboardJob(XTextGeneratorConfiguration config) {
        this(config, "XTextGenerator Job", true);
    }

    public XTextGeneratorBlackboardJob(XTextGeneratorConfiguration config, String name) {
        this(config, name, true);
    }

    public XTextGeneratorBlackboardJob(XTextGeneratorConfiguration config, boolean cleanUpImmediately) {
        this(config, "XTextGenerator Job", cleanUpImmediately);
    }

    public XTextGeneratorBlackboardJob(XTextGeneratorConfiguration config, String name, boolean cleanUpImmediately) {
        super(name, cleanUpImmediately);
        config.initMWEBean();
        WorkflowContextImpl ctx = new WorkflowContextImpl();
        config.initGeneratorModuleAndGeneratorSetup();
        this.addJob(new PrepareXTextPartitionJob(config.getBlackboardModelLocation()));
        this.addJob(new MWE2WorkflowComponentBridge<XTextGeneratorSupport>(config.createGeneratorSupport(), (IWorkflowContext)ctx, "XTextGeneratorSupport Job"));
        this.addJob(new MWE2BlackboardWorkflowComponentBridge<BlackboardReader>(config.createBlackboardReader(), (IWorkflowContext)ctx, "MWEReader Job"));
        this.addJob(new MWE2WorkflowComponentBridge<GeneratorComponent>(config.createGenerator(), (IWorkflowContext)ctx, "XTextGenerator Job"));
    }

    @Override
    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        for (IJob job : this.myJobs) {
            if (job instanceof IBlackboardInteractingJob) {
                ((IBlackboardInteractingJob)job).setBlackboard((Blackboard)this.blackboard);
                continue;
            }
            if (!(job instanceof IBlackboardInteractingWorkflowComponent)) continue;
            ((IBlackboardInteractingWorkflowComponent)job).setBlackboard(this.blackboard);
        }
        super.execute(monitor);
    }

    public void setBlackboard(MDSDBlackboard blackboard) {
        this.blackboard = blackboard;
    }
}

