/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.sensors.impl;

import de.uka.ipd.sdq.scheduler.SchedulerModel;
import de.uka.ipd.sdq.scheduler.processes.PROCESS_STATE;
import de.uka.ipd.sdq.scheduler.sensors.IProcessStateSensor;
import edu.kit.ipd.sdq.pcm.simulation.scheduler.exact.processes.IActiveProcess;

public class RunTimeSensor
implements IProcessStateSensor {
    private SchedulerModel model;
    private PROCESS_STATE last_state;
    private double lastUpdateTime;
    private double otherTime;
    private double runTime;
    private IActiveProcess process;

    public RunTimeSensor(SchedulerModel model, IActiveProcess process) {
        this.model = model;
        this.lastUpdateTime = 0.0;
        this.process = process;
        this.last_state = process.getState();
        this.reset();
    }

    public void reset() {
        this.runTime = 0.0;
        this.otherTime = 0.0;
        this.lastUpdateTime = this.model.getSimulationControl().getCurrentSimulationTime();
    }

    public double getRunTime() {
        if (this.process.getState() == PROCESS_STATE.RUNNING) {
            double currentTime = this.model.getSimulationControl().getCurrentSimulationTime();
            double passedTime = currentTime - this.lastUpdateTime;
            this.runTime += passedTime;
            this.lastUpdateTime = currentTime;
        }
        return this.runTime;
    }

    public double getNotRunTime() {
        if (this.process.getState() != PROCESS_STATE.RUNNING) {
            double currentTime = this.model.getSimulationControl().getCurrentSimulationTime();
            double passedTime = currentTime - this.lastUpdateTime;
            this.otherTime += passedTime;
            this.lastUpdateTime = currentTime;
        }
        return this.otherTime;
    }

    public void update(PROCESS_STATE new_state) {
        double currentTime = this.model.getSimulationControl().getCurrentSimulationTime();
        double passedTime = currentTime - this.lastUpdateTime;
        if (this.last_state == PROCESS_STATE.RUNNING && new_state != PROCESS_STATE.RUNNING) {
            this.runTime += passedTime;
            this.lastUpdateTime = currentTime;
        }
        if (this.last_state != PROCESS_STATE.RUNNING && new_state == PROCESS_STATE.RUNNING) {
            this.otherTime += passedTime;
            this.lastUpdateTime = currentTime;
        }
        this.last_state = new_state;
    }
}

