/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates;

import java.util.Date;
import javax.measure.Measurable;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javolution.context.ObjectFactory;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.jscience.geography.coordinates.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;

public final class Time
extends Coordinates<TemporalCRS<?>>
implements Measurable<Duration> {
    public static final TemporalCRS<Time> CRS = new TemporalCRS<Time>(){

        @Override
        protected Time coordinatesOf(CoordinateReferenceSystem.AbsolutePosition position) {
            if (position.timeUTC instanceof Time) {
                return (Time)position.timeUTC;
            }
            return Time.valueOf(position.timeUTC.doubleValue(SI.SECOND), SI.SECOND);
        }

        @Override
        protected CoordinateReferenceSystem.AbsolutePosition positionOf(Time coordinates, CoordinateReferenceSystem.AbsolutePosition position) {
            position.timeUTC = coordinates;
            return position;
        }

        @Override
        public CoordinateSystem getCoordinateSystem() {
            return TemporalCRS.TIME_CS;
        }
    };
    private double _seconds;
    private static final ObjectFactory<Time> FACTORY = new ObjectFactory<Time>(){

        protected Time create() {
            return new Time(null);
        }
    };
    static final XMLFormat<Time> XML = new XMLFormat<Time>(Time.class){

        public Time newInstance(Class<Time> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (Time)FACTORY.object();
        }

        public void write(Time time, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("seconds", time._seconds);
        }

        public void read(XMLFormat.InputElement xml, Time time) throws XMLStreamException {
            time._seconds = xml.getAttribute("seconds", 0.0);
        }
    };
    private static final long serialVersionUID = 1L;

    public static Time valueOf(double value, Unit<Duration> unit) {
        Time time = (Time)FACTORY.object();
        if (unit == SI.SECOND) {
            time._seconds = value;
        } else {
            UnitConverter toSecond = unit.getConverterTo(SI.SECOND);
            time._seconds = toSecond.convert(value);
        }
        return time;
    }

    private Time() {
    }

    public static Time valueOf(Date date) {
        return Time.valueOf(date.getTime(), SI.MILLI(SI.SECOND));
    }

    public Time(double value, Unit<Duration> unit) {
    }

    @Override
    public TemporalCRS<?> getCoordinateReferenceSystem() {
        return CRS;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            Unit<?> u = TemporalCRS.TIME_CS.getAxis(0).getUnit();
            return SI.SECOND.getConverterTo(u).convert(this._seconds);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final double doubleValue(Unit<Duration> unit) {
        return unit.equals(SI.SECOND) ? this._seconds : SI.SECOND.getConverterTo(unit).convert(this._seconds);
    }

    @Override
    public final long longValue(Unit<Duration> unit) {
        return Math.round(this.doubleValue(unit));
    }

    @Override
    public int compareTo(Measurable<Duration> arg0) {
        double arg0InSecond = arg0.doubleValue(SI.SECOND);
        return this._seconds > arg0InSecond ? 1 : (this._seconds < arg0InSecond ? -1 : 0);
    }

    @Override
    public Time copy() {
        return Time.valueOf(this._seconds, SI.SECOND);
    }

    /* synthetic */ Time(Time time) {
        this();
    }
}

