/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates.crs;

import javax.measure.Measurable;
import javax.measure.Measure;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;

public class ReferenceEllipsoid {
    public static final ReferenceEllipsoid WGS84 = new ReferenceEllipsoid(6378137.0, 298.257223563);
    public static final ReferenceEllipsoid GRS80 = new ReferenceEllipsoid(6378137.0, 298.257222101);
    public static final ReferenceEllipsoid WGS72 = new ReferenceEllipsoid(6378135.0, 298.26);
    public static final ReferenceEllipsoid INTERNATIONAL1924 = new ReferenceEllipsoid(6378388.0, 297.0);
    private final double a;
    private final double b;
    private final double f;
    private final double ea2;
    private final double e;
    private final double eb2;
    private Measurable<Length> _semimajorAxis;
    private Measurable<Length> _semiminorAxis;

    public ReferenceEllipsoid(double semimajorAxis, double inverseFlattening) {
        this.a = semimajorAxis;
        this.f = 1.0 / inverseFlattening;
        this.b = semimajorAxis * (1.0 - this.f);
        this.ea2 = this.f * (2.0 - this.f);
        this.e = Math.sqrt(this.ea2);
        this.eb2 = this.ea2 / (1.0 - this.ea2);
    }

    private static double sqr(double x) {
        return x * x;
    }

    public Measurable<Length> getSemimajorAxis() {
        if (this._semimajorAxis == null) {
            this._semimajorAxis = Measure.valueOf(this.a, SI.METRE);
        }
        return this._semimajorAxis;
    }

    public Measurable<Length> getsSemiminorAxis() {
        if (this._semiminorAxis == null) {
            this._semiminorAxis = Measure.valueOf(this.b, SI.METRE);
        }
        return this._semiminorAxis;
    }

    public double getFlattening() {
        return this.f;
    }

    public double getEccentricity() {
        return this.e;
    }

    public double getEccentricitySquared() {
        return this.ea2;
    }

    public double getSecondEccentricitySquared() {
        return this.eb2;
    }

    public double verticalRadiusOfCurvature(double phi) {
        return this.a / Math.sqrt(1.0 - this.ea2 * ReferenceEllipsoid.sqr(Math.sin(phi)));
    }

    public Measurable<Length> verticalRadiusOfCurvature(Measurable<Angle> latitude) {
        return Measure.valueOf(this.verticalRadiusOfCurvature(latitude.doubleValue(SI.RADIAN)), SI.METRE);
    }

    public double meridionalRadiusOfCurvature(double phi) {
        return this.verticalRadiusOfCurvature(phi) / (1.0 + this.eb2 * ReferenceEllipsoid.sqr(Math.cos(phi)));
    }

    public Measurable<Length> meridionalRadiusOfCurvature(Measurable<Angle> latitude) {
        return Measure.valueOf(this.meridionalRadiusOfCurvature(latitude.doubleValue(SI.RADIAN)), SI.METRE);
    }

    public double meridionalArc(double phi) {
        double sin2Phi = Math.sin(2.0 * phi);
        double sin4Phi = Math.sin(4.0 * phi);
        double sin6Phi = Math.sin(6.0 * phi);
        double sin8Phi = Math.sin(8.0 * phi);
        double n = this.f / (2.0 - this.f);
        double n2 = n * n;
        double n3 = n2 * n;
        double n4 = n3 * n;
        double n5 = n4 * n;
        double n1n2 = n - n2;
        double n2n3 = n2 - n3;
        double n3n4 = n3 - n4;
        double n4n5 = n4 - n5;
        double ap = this.a * (1.0 - n + 1.25 * n2n3 + 1.265625 * n4n5);
        double bp = 1.5 * this.a * (n1n2 + 0.875 * n3n4 + 0.859375 * n5);
        double cp = 0.9375 * this.a * (n2n3 + 0.75 * n4n5);
        double dp = 0.7291666666666666 * this.a * (n3n4 + 0.6875 * n5);
        double ep = 0.615234375 * this.a * n4n5;
        return ap * phi - bp * sin2Phi + cp * sin4Phi - dp * sin6Phi + ep * sin8Phi;
    }

    public Measurable<Length> meridionalArc(Measurable<Angle> latitude) {
        return Measure.valueOf(this.meridionalArc(latitude.doubleValue(SI.RADIAN)), SI.METRE);
    }
}

