/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.text.Text;
import javolution.text.TypeFormat;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.Number;

public final class Integer64
extends Number<Integer64> {
    static final XMLFormat<Integer64> XML = new XMLFormat<Integer64>(Integer64.class){

        public Integer64 newInstance(Class<Integer64> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return Integer64.valueOf(xml.getAttribute("value", 0L));
        }

        public void write(Integer64 integer64, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", integer64._value);
        }

        public void read(XMLFormat.InputElement xml, Integer64 integer64) {
        }
    };
    private static final ObjectFactory<Integer64> FACTORY = new ObjectFactory<Integer64>(){

        protected Integer64 create() {
            return new Integer64(null);
        }
    };
    public static final Integer64 ZERO = new Integer64(0L);
    public static final Integer64 ONE = new Integer64(1L);
    private long _value;
    private static final long serialVersionUID = 1L;

    private Integer64() {
    }

    private Integer64(long longValue) {
        this._value = longValue;
    }

    public static Integer64 valueOf(long longValue) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = longValue;
        return r;
    }

    public static Integer64 valueOf(CharSequence chars) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = TypeFormat.parseLong((CharSequence)chars);
        return r;
    }

    @Override
    public Integer64 opposite() {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = -this._value;
        return r;
    }

    @Override
    public Integer64 plus(Integer64 that) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = this._value + that._value;
        return r;
    }

    @Override
    public Integer64 plus(long value) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = this._value + value;
        return r;
    }

    @Override
    public Integer64 minus(Integer64 that) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = this._value - that._value;
        return r;
    }

    @Override
    public Integer64 minus(long value) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = this._value - value;
        return r;
    }

    @Override
    public Integer64 times(Integer64 that) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = this._value * that._value;
        return r;
    }

    @Override
    public Integer64 times(long value) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = this._value * value;
        return r;
    }

    public Integer64 divide(Integer64 that) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = this._value / that._value;
        return r;
    }

    public Integer64 divide(long value) {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = this._value / value;
        return r;
    }

    @Override
    public boolean isLargerThan(Integer64 that) {
        return MathLib.abs((long)this._value) > MathLib.abs((long)that._value);
    }

    public Integer64 abs() {
        Integer64 r = (Integer64)FACTORY.object();
        r._value = MathLib.abs((long)this._value);
        return r;
    }

    @Override
    public Text toText() {
        return Text.valueOf((long)this._value);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof Integer64 && this._value == ((Integer64)that)._value;
    }

    public boolean equals(long value) {
        return this._value == value;
    }

    @Override
    public int compareTo(long value) {
        if (this._value < value) {
            return -1;
        }
        if (this._value > value) {
            return 1;
        }
        return 0;
    }

    @Override
    public int hashCode() {
        int h = Float.floatToIntBits(this._value);
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    @Override
    public long longValue() {
        return this._value;
    }

    @Override
    public double doubleValue() {
        return this._value;
    }

    @Override
    public int compareTo(Integer64 that) {
        return this.compareTo(that._value);
    }

    @Override
    public Integer64 copy() {
        return Integer64.valueOf(this._value);
    }

    /* synthetic */ Integer64(Integer64 integer64) {
        this();
    }
}

