/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import java.io.IOException;
import java.math.BigInteger;
import javolution.context.ArrayFactory;
import javolution.context.ConcurrentContext;
import javolution.context.ObjectFactory;
import javolution.context.StackContext;
import javolution.lang.Configurable;
import javolution.lang.MathLib;
import javolution.lang.ValueType;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.text.TextFormat;
import javolution.text.TypeFormat;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.Calculus;
import org.jscience.mathematics.number.Number;

public final class LargeInteger
extends Number<LargeInteger> {
    public static final Configurable<Integer> PRIME_CERTAINTY = new Configurable((Object)100);
    static final TextFormat<LargeInteger> DECIMAL_FORMAT = new TextFormat<LargeInteger>(){

        public Appendable format(LargeInteger li, Appendable out) throws IOException {
            return LargeInteger.format(li, 10, out);
        }

        public LargeInteger parse(CharSequence csq, TextFormat.Cursor cursor) {
            return LargeInteger.parse(csq, 10, cursor);
        }
    };
    private static final ArrayFactory<LargeInteger> ARRAY_FACTORY;
    private static final ObjectFactory<LargeInteger> NO_ARRAY_FACTORY;
    static final XMLFormat<LargeInteger> XML;
    public static final LargeInteger ZERO;
    public static final LargeInteger ONE;
    static final LargeInteger LONG_MIN_VALUE;
    static final LargeInteger FIVE;
    private LargeInteger _remainder;
    private boolean _isNegative;
    private int _size;
    private long[] _words;
    private static final double BITS_TO_DIGITS = 0.30102999566398114;
    private static final double DIGITS_TO_BITS = 3.3219280948873626;
    private static final int[] INT_POW_5;
    private static final long[] LONG_POW_5;
    private static final long[] LONG_POW_10;
    private static final long[] LONG_POW_16;
    private static final long serialVersionUID = 1L;

    static {
        TextFormat.setInstance(LargeInteger.class, DECIMAL_FORMAT);
        ARRAY_FACTORY = new ArrayFactory<LargeInteger>(){

            protected LargeInteger create(int capacity) {
                return new LargeInteger(capacity, null);
            }
        };
        NO_ARRAY_FACTORY = new ObjectFactory<LargeInteger>(){

            protected LargeInteger create() {
                return new LargeInteger(null);
            }
        };
        XML = new XMLFormat<LargeInteger>(LargeInteger.class){

            public LargeInteger newInstance(Class<LargeInteger> cls, XMLFormat.InputElement xml) throws XMLStreamException {
                return LargeInteger.valueOf((CharSequence)xml.getAttribute("value"));
            }

            public void write(LargeInteger li, XMLFormat.OutputElement xml) throws XMLStreamException {
                xml.setAttribute("value", (CharSequence)li.toText());
            }

            public void read(XMLFormat.InputElement xml, LargeInteger li) {
            }
        };
        ZERO = new LargeInteger(1);
        ONE = new LargeInteger(1);
        LargeInteger.ONE._words[0] = 1L;
        LargeInteger.ONE._size = 1;
        LONG_MIN_VALUE = new LargeInteger(2);
        LargeInteger.LONG_MIN_VALUE._words[1] = 1L;
        LargeInteger.LONG_MIN_VALUE._size = 2;
        LargeInteger.LONG_MIN_VALUE._isNegative = true;
        FIVE = new LargeInteger(1);
        LargeInteger.FIVE._words[0] = 5L;
        LargeInteger.FIVE._size = 1;
        INT_POW_5 = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        LONG_POW_5 = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L, 7450580596923828125L};
        LONG_POW_10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
        LONG_POW_16 = new long[]{1L, 16L, 256L, 4096L, 65536L, 0x100000L, 0x1000000L, 0x10000000L, 0x100000000L, 0x1000000000L, 0x10000000000L, 0x100000000000L, 0x1000000000000L, 0x10000000000000L, 0x100000000000000L, 0x1000000000000000L};
    }

    private LargeInteger() {
    }

    private LargeInteger(int wordLength) {
        this._words = new long[wordLength];
    }

    public static LargeInteger valueOf(long value) {
        if (value == 0L) {
            return ZERO;
        }
        if (value == Long.MIN_VALUE) {
            return LONG_MIN_VALUE;
        }
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(1);
        li._isNegative = value < 0L;
        boolean negative = li._isNegative;
        li._words[0] = negative ? -value : value;
        li._size = 1;
        return li;
    }

    public static LargeInteger valueOf(byte[] bytes, int offset, int length) {
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array((length * 8 + 1) / 63 + 1);
        boolean isNegative = bytes[offset] < 0;
        int wordIndex = 0;
        int bitIndex = 0;
        li._words[0] = 0L;
        int i = offset + length;
        while (i > offset) {
            long bits = (long)(isNegative ? ~bytes[--i] : bytes[--i]) & 0xFFL;
            if (bitIndex < 55) {
                int n = wordIndex;
                li._words[n] = li._words[n] | bits << bitIndex;
            } else {
                int n = wordIndex++;
                li._words[n] = li._words[n] | bits << bitIndex & Long.MAX_VALUE;
                li._words[wordIndex] = bits >> -(bitIndex -= 63);
            }
            bitIndex += 8;
        }
        while (li._words[wordIndex] == 0L) {
            if (--wordIndex <= 0) break;
        }
        if (isNegative && wordIndex < 0) {
            wordIndex = 0;
        }
        li._size = wordIndex + 1;
        li._isNegative = isNegative;
        if (isNegative) {
            li._size = Calculus.add(li._words, li._size, LargeInteger.ONE._words, 1, li._words);
        }
        return li;
    }

    public int toByteArray(byte[] bytes, int offset) {
        int bytesLength = (this.bitLength() >> 3) + 1;
        int wordIndex = 0;
        int bitIndex = 0;
        if (this._isNegative) {
            long word = this._words[0] - 1L;
            long borrow = word >> 63;
            word = (word ^ 0xFFFFFFFFFFFFFFFFL) & Long.MAX_VALUE;
            int i = bytesLength + offset;
            while (i > offset) {
                if (bitIndex < 55) {
                    bytes[--i] = (byte)word;
                    word >>= 8;
                } else {
                    byte bits = (byte)word;
                    word = ++wordIndex < this._size ? this._words[wordIndex] + borrow : borrow;
                    borrow = word >> 63;
                    word = (word ^ 0xFFFFFFFFFFFFFFFFL) & Long.MAX_VALUE;
                    bytes[--i] = (byte)(word << -(bitIndex -= 63) | (long)bits);
                    word >>= 8 + bitIndex;
                }
                bitIndex += 8;
            }
        } else if (this._size != 0) {
            long word = this._words[0];
            int i = bytesLength + offset;
            while (i > offset) {
                if (bitIndex < 55) {
                    bytes[--i] = (byte)word;
                    word >>= 8;
                } else {
                    byte bits = (byte)word;
                    word = ++wordIndex < this._size ? this._words[wordIndex] : 0L;
                    bytes[--i] = (byte)(word << -(bitIndex -= 63) | (long)bits);
                    word >>= 8 + bitIndex;
                }
                bitIndex += 8;
            }
        } else {
            bytes[offset] = 0;
        }
        return bytesLength;
    }

    public static LargeInteger valueOf(CharSequence csq) {
        return (LargeInteger)TextFormat.getInstance(LargeInteger.class).parse(csq);
    }

    public static LargeInteger valueOf(CharSequence csq, int radix) {
        TextFormat.Cursor cursor = TextFormat.Cursor.newInstance((int)0, (int)csq.length());
        try {
            LargeInteger largeInteger = LargeInteger.parse(csq, radix, cursor);
            return largeInteger;
        }
        finally {
            if (cursor.hasNext()) {
                throw new NumberFormatException("Cannot parse " + csq + " at " + cursor);
            }
            TextFormat.Cursor.recycle((TextFormat.Cursor)cursor);
        }
    }

    public static LargeInteger valueOf(BigInteger bigInteger) {
        byte[] bytes = bigInteger.toByteArray();
        return LargeInteger.valueOf(bytes, 0, bytes.length);
    }

    public boolean isPositive() {
        return !this._isNegative && this._size != 0;
    }

    public boolean isNegative() {
        return this._isNegative;
    }

    public boolean isZero() {
        return this._size == 0;
    }

    public boolean isEven() {
        return this._size == 0 || (this._words[0] & 1L) == 0L;
    }

    public boolean isOdd() {
        return !this.isEven();
    }

    public boolean isProbablyPrime() {
        throw new UnsupportedOperationException("Not Implemented");
    }

    public int bitLength() {
        if (this._size == 0) {
            return 0;
        }
        int n = this._size - 1;
        int bitLength = MathLib.bitLength((long)this._words[n]) + (n << 6) - n;
        return this.isNegative() && this.isPowerOfTwo() ? bitLength - 1 : bitLength;
    }

    public int digitLength() {
        int max;
        int bitLength = this.bitLength();
        int min = (int)((double)(bitLength - 1) * 0.30102999566398114) + 1;
        if (min == (max = (int)((double)bitLength * 0.30102999566398114) + 1)) {
            return min;
        }
        return ONE.times10pow(min).isLargerThan(this) ? min : min + 1;
    }

    public boolean isPowerOfTwo() {
        if (this._size == 0) {
            return false;
        }
        int n = this._size - 1;
        int j = 0;
        while (j < n) {
            if (this._words[j] != 0L) {
                return false;
            }
            ++j;
        }
        int bitLength = MathLib.bitLength((long)this._words[n]);
        return this._words[n] == 1L << bitLength - 1;
    }

    public int getLowestSetBit() {
        if (this._size == 0) {
            return -1;
        }
        int i = 0;
        while (true) {
            long w;
            if ((w = this._words[i]) != 0L) {
                int j = 0;
                while (true) {
                    if ((1L << j & w) != 0L) {
                        return i * 63 + j;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public LargeInteger getRemainder() {
        return this._remainder;
    }

    @Override
    public boolean isLargerThan(LargeInteger that) {
        return this._size > that._size || this._size == that._size && Calculus.compare(this._words, that._words, this._size) > 0;
    }

    public LargeInteger abs() {
        if (this._isNegative) {
            return this.opposite();
        }
        return this;
    }

    @Override
    public LargeInteger opposite() {
        LargeInteger li = (LargeInteger)NO_ARRAY_FACTORY.object();
        li._words = this._words;
        li._size = this._size;
        li._isNegative = !this._isNegative && this._size != 0;
        return li;
    }

    @Override
    public LargeInteger plus(long value) {
        return this.plus(LargeInteger.valueOf(value));
    }

    @Override
    public LargeInteger plus(LargeInteger that) {
        if (this._size < that._size) {
            return that.plus(this);
        }
        if (this._isNegative != that._isNegative && that._size != 0) {
            return this.minus(that.opposite());
        }
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size + 1);
        li._size = Calculus.add(this._words, this._size, that._words, that._size, li._words);
        li._isNegative = this._isNegative;
        return li;
    }

    @Override
    public LargeInteger minus(LargeInteger that) {
        if (this._isNegative != that._isNegative && that._size != 0) {
            return this.plus(that.opposite());
        }
        if (that.isLargerThan(this)) {
            return that.minus(this).opposite();
        }
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size);
        li._size = Calculus.subtract(this._words, this._size, that._words, that._size, li._words);
        li._isNegative = this._isNegative && li._size != 0;
        return li;
    }

    @Override
    public LargeInteger minus(long value) {
        return this.minus(LargeInteger.valueOf(value));
    }

    @Override
    public LargeInteger times(LargeInteger that) {
        if (that._size > this._size) {
            return that.times(this);
        }
        if (that._size <= 1) {
            return this.times(that.longValue());
        }
        if (that._size < 10) {
            LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size + that._size);
            li._size = Calculus.multiply(this._words, this._size, that._words, that._size, li._words);
            li._isNegative = this._isNegative ^ that._isNegative;
            return li;
        }
        if (that._size < 20) {
            int n = (that._size >> 1) + (that._size & 1);
            LargeInteger b = this.high(n);
            LargeInteger a = this.low(n);
            LargeInteger d = this == that ? b : that.high(n);
            LargeInteger c = this == that ? a : that.low(n);
            LargeInteger ab = a.plus(b);
            LargeInteger cd = this == that ? ab : c.plus(d);
            LargeInteger abcd = ab.times(cd);
            LargeInteger ac = a.times(c);
            LargeInteger bd = b.times(d);
            return ac.plus(abcd.minus(ac.plus(bd)).shiftWordLeft(n)).plus(bd.shiftWordLeft(n << 1));
        }
        int n = (that._size >> 1) + (that._size & 1);
        LargeInteger b = this.high(n);
        LargeInteger a = this.low(n);
        LargeInteger d = this == that ? b : that.high(n);
        LargeInteger c = this == that ? a : that.low(n);
        LargeInteger ab = a.plus(b);
        LargeInteger cd = this == that ? ab : c.plus(d);
        Calculus.MultiplyLogic abcd = Calculus.MultiplyLogic.newInstance(ab, cd);
        Calculus.MultiplyLogic ac = Calculus.MultiplyLogic.newInstance(a, c);
        Calculus.MultiplyLogic bd = Calculus.MultiplyLogic.newInstance(b, d);
        ConcurrentContext.enter();
        try {
            ConcurrentContext.execute((Runnable)abcd);
            ConcurrentContext.execute((Runnable)ac);
            ConcurrentContext.execute((Runnable)bd);
        }
        finally {
            ConcurrentContext.exit();
        }
        LargeInteger result = ac.value().plus(abcd.value().minus(ac.value().plus(bd.value())).shiftWordLeft(n)).plus(bd.value().shiftWordLeft(n << 1));
        return result;
    }

    private LargeInteger high(int w) {
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size - w);
        li._isNegative = this._isNegative;
        li._size = this._size - w;
        System.arraycopy(this._words, w, li._words, 0, this._size - w);
        return li;
    }

    private LargeInteger low(int w) {
        LargeInteger li = (LargeInteger)NO_ARRAY_FACTORY.object();
        li._words = this._words;
        li._isNegative = this._isNegative;
        int i = w;
        while (i > 0) {
            if (this._words[i - 1] != 0L) {
                li._size = i;
                return li;
            }
            --i;
        }
        return ZERO;
    }

    private LargeInteger shiftWordLeft(int w) {
        if (this._size == 0) {
            return ZERO;
        }
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(w + this._size);
        li._isNegative = this._isNegative;
        li._size = w + this._size;
        int i = 0;
        while (i < w) {
            li._words[i++] = 0L;
        }
        System.arraycopy(this._words, 0, li._words, w, this._size);
        return li;
    }

    @Override
    public LargeInteger times(long multiplier) {
        if (this._size == 0 || multiplier == 0L) {
            return ZERO;
        }
        if (multiplier == Long.MIN_VALUE) {
            return this.times(LONG_MIN_VALUE);
        }
        boolean isNegative = this._isNegative ^ multiplier < 0L;
        multiplier = MathLib.abs((long)multiplier);
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size + 1);
        li._size = Calculus.multiply(this._words, this._size, multiplier, li._words);
        li._isNegative = isNegative;
        return li;
    }

    public LargeInteger divide(LargeInteger that) {
        LargeInteger remainder;
        LargeInteger result;
        if (that._size <= 1 && that._words[0] >> 31 == 0L) {
            return this.divide(that.intValue());
        }
        LargeInteger thisAbs = this.abs();
        LargeInteger thatAbs = that.abs();
        int precision = thisAbs.bitLength() - thatAbs.bitLength() + 1;
        if (precision <= 0) {
            result = ZERO;
            remainder = this;
        } else {
            LargeInteger thatReciprocal = thatAbs.inverseScaled(precision);
            result = thisAbs.times(thatReciprocal);
            remainder = thisAbs.minus(thatAbs.times(result = result.shiftRight(thisAbs.bitLength() + 1)));
            if (remainder.compareTo(thatAbs) >= 0) {
                remainder = remainder.minus(thatAbs);
                result = result.plus(ONE);
                if (remainder.compareTo(thatAbs) >= 0) {
                    throw new Error("Verification error for " + this + "/" + that + ", please submit a bug report.");
                }
            } else if (remainder.isNegative()) {
                remainder = remainder.plus(thatAbs);
                result = result.minus(ONE);
                if (remainder.isNegative()) {
                    throw new Error("Verification error for " + this + "/" + that + ", please submit a bug report.");
                }
            }
        }
        LargeInteger li = (LargeInteger)NO_ARRAY_FACTORY.object();
        li._words = result._words;
        li._size = result._size;
        li._isNegative = this._isNegative != that._isNegative && result._size != 0;
        li._remainder = this._isNegative ? remainder.opposite() : remainder;
        return li;
    }

    public LargeInteger divide(int divisor) {
        if (divisor == 0) {
            throw new ArithmeticException("Division by zero");
        }
        if (divisor == Integer.MIN_VALUE) {
            LargeInteger li = this.times2pow(-31).copy();
            li._isNegative = !this._isNegative && li._size != 0;
            li._remainder = this._isNegative ? LargeInteger.valueOf(-(this._words[0] & Integer.MAX_VALUE)) : LargeInteger.valueOf(this._words[0] & Integer.MAX_VALUE);
            return li;
        }
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size);
        long rem = Calculus.divide(this._words, this._size, MathLib.abs((int)divisor), li._words);
        li._size = this._size > 0 && li._words[this._size - 1] == 0L ? this._size - 1 : this._size;
        li._isNegative = this._isNegative != divisor < 0 && li._size != 0;
        li._remainder = LargeInteger.valueOf(this._isNegative ? -rem : rem);
        return li;
    }

    public LargeInteger remainder(LargeInteger that) {
        return this.divide(that).getRemainder();
    }

    public LargeInteger inverseScaled(int precision) {
        if (precision <= 30) {
            long divisor = this.shiftRight((int)(this.bitLength() - precision - 1))._words[0];
            long dividend = 1L << precision * 2 + 1;
            return this.isNegative() ? LargeInteger.valueOf(-dividend / divisor) : LargeInteger.valueOf(dividend / divisor);
        }
        LargeInteger x = this.inverseScaled(precision / 2 + 1);
        LargeInteger thisTrunc = this.shiftRight(this.bitLength() - (precision + 2));
        LargeInteger prod = thisTrunc.times(x).times(x);
        int diff = 2 * (precision / 2 + 2);
        LargeInteger prodTrunc = prod.shiftRight(diff);
        LargeInteger xPad = x.shiftLeft(precision - precision / 2 - 1);
        LargeInteger tmp = xPad.minus(prodTrunc);
        return xPad.plus(tmp);
    }

    public LargeInteger sqrt() {
        if (this.isNegative()) {
            throw new ArithmeticException("Square root of negative integer");
        }
        if (this.equals(ZERO)) {
            return ZERO;
        }
        if (this.equals(ONE)) {
            return ONE;
        }
        int bitLength = this.bitLength();
        StackContext.enter();
        try {
            LargeInteger k = this.times2pow(-((bitLength >> 1) + (bitLength & 1)));
            while (true) {
                LargeInteger newK;
                if (!(newK = k.plus(this.divide(k)).times2pow(-1)).minus(k).isLargerThan(ONE)) {
                    if (this.divide(newK).isLessThan(newK)) {
                        newK = newK.minus(ONE);
                    }
                    LargeInteger largeInteger = (LargeInteger)StackContext.outerCopy((ValueType)newK);
                    return largeInteger;
                }
                k = newK;
            }
        }
        finally {
            StackContext.exit();
        }
    }

    public LargeInteger mod(LargeInteger m) {
        LargeInteger li = m.isLargerThan(this) ? this : this.divide(m).getRemainder();
        return this._isNegative == m._isNegative ? li : li.plus(m);
    }

    public LargeInteger modInverse(LargeInteger m) {
        if (!m.isPositive()) {
            throw new ArithmeticException("Modulus is not a positive number");
        }
        StackContext.enter();
        try {
            LargeInteger a = this.mod(m);
            LargeInteger b = m;
            LargeInteger p = ONE;
            LargeInteger q = ZERO;
            LargeInteger r = ZERO;
            LargeInteger s = ONE;
            while (!b.isZero()) {
                LargeInteger quot = a.divide(b);
                LargeInteger c = quot.getRemainder();
                a = b;
                b = c;
                LargeInteger new_r = p.minus(quot.times(r));
                LargeInteger new_s = q.minus(quot.times(s));
                p = r;
                q = s;
                r = new_r;
                s = new_s;
            }
            if (!a.abs().equals(ONE)) {
                throw new ArithmeticException("GCD(" + this + ", " + m + ") = " + a);
            }
            LargeInteger largeInteger = (LargeInteger)StackContext.outerCopy((ValueType)(a.isNegative() ? p.opposite().mod(m) : p.mod(m)));
            return largeInteger;
        }
        finally {
            StackContext.exit();
        }
    }

    public LargeInteger modPow(LargeInteger exp, LargeInteger m) {
        if (!m.isPositive()) {
            throw new ArithmeticException("Modulus is not a positive number");
        }
        if (exp.isPositive()) {
            StackContext.enter();
            try {
                LargeInteger result = null;
                LargeInteger pow2 = this.mod(m);
                while (exp.compareTo(ONE) >= 0) {
                    if (exp.isOdd()) {
                        result = result == null ? pow2 : result.times(pow2).mod(m);
                    }
                    pow2 = pow2.times(pow2).mod(m);
                    exp = exp.shiftRight(1);
                }
                LargeInteger largeInteger = (LargeInteger)StackContext.outerCopy(result);
                return largeInteger;
            }
            finally {
                StackContext.exit();
            }
        }
        if (exp.isNegative()) {
            return this.modPow(exp.opposite(), m).modInverse(m);
        }
        return ONE;
    }

    public LargeInteger gcd(LargeInteger that) {
        if (this.isZero()) {
            return that;
        }
        if (that.isZero()) {
            return this;
        }
        LargeInteger u = this.copy();
        u._isNegative = false;
        LargeInteger v = that.copy();
        v._isNegative = false;
        while (MathLib.abs((int)(u._size - v._size)) > 1) {
            LargeInteger tmp = u.divide(v);
            LargeInteger rem = tmp.getRemainder();
            u = v;
            v = rem;
            if (!v.isZero()) continue;
            return u;
        }
        int uShift = u.getLowestSetBit();
        u.shiftRightSelf(uShift);
        int vShift = v.getLowestSetBit();
        v.shiftRightSelf(vShift);
        while (true) {
            if (u.compareTo(v) < 0) {
                v.subtract(u);
            } else {
                u.subtract(v);
                LargeInteger tmp = u;
                u = v;
                v = tmp;
            }
            v.shiftRightSelf();
            if (v.isZero()) break;
            v.shiftRightSelf(v.getLowestSetBit());
        }
        return u.shiftLeft(MathLib.min((int)uShift, (int)vShift));
    }

    private void shiftRightSelf() {
        if (this._size == 0) {
            return;
        }
        this._size = Calculus.shiftRight(0, 1, this._words, this._size, this._words);
    }

    private void shiftRightSelf(int n) {
        if (n == 0 || this._size == 0) {
            return;
        }
        int wordShift = n < 63 ? 0 : n / 63;
        int bitShift = n - ((wordShift << 6) - wordShift);
        this._size = Calculus.shiftRight(wordShift, bitShift, this._words, this._size, this._words);
    }

    private void subtract(LargeInteger that) {
        this._size = Calculus.subtract(this._words, this._size, that._words, that._size, this._words);
    }

    public LargeInteger shiftLeft(int n) {
        if (n < 0) {
            return this.shiftRight(-n);
        }
        if (this._size == 0) {
            return ZERO;
        }
        int wordShift = n < 63 ? 0 : n / 63;
        int bitShift = n - wordShift * 63;
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size + wordShift + 1);
        li._isNegative = this._isNegative;
        li._size = Calculus.shiftLeft(wordShift, bitShift, this._words, this._size, li._words);
        return li;
    }

    public LargeInteger shiftRight(int n) {
        LargeInteger li = this.times2pow(-n);
        return this._isNegative && n > 0 && this.isShiftRightCorrection(n) ? li.minus(ONE) : li;
    }

    private boolean isShiftRightCorrection(int n) {
        int wordShift = n < 63 ? 0 : n / 63;
        int bitShift = n - ((wordShift << 6) - wordShift);
        int i = wordShift;
        boolean bitsLost = bitShift != 0 && this._words[i] << 64 - bitShift != 0L;
        while (!bitsLost && --i >= 0) {
            boolean bl = bitsLost = this._words[i--] != 0L;
        }
        return bitsLost;
    }

    public LargeInteger times2pow(int n) {
        if (n >= 0) {
            return this.shiftLeft(n);
        }
        int wordShift = (n = -n) < 63 ? 0 : n / 63;
        int bitShift = n - ((wordShift << 6) - wordShift);
        if (this._size <= wordShift) {
            return ZERO;
        }
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size - wordShift);
        li._size = Calculus.shiftRight(wordShift, bitShift, this._words, this._size, li._words);
        li._isNegative = this._isNegative && li._size != 0;
        return li;
    }

    public LargeInteger times10pow(int n) {
        if (this._size == 0) {
            return ZERO;
        }
        if (n >= 0) {
            int bitLength = (int)((double)n * 3.3219280948873626);
            LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size + bitLength / 63 + 1);
            li._isNegative = this._isNegative;
            int i = n >= LONG_POW_5.length ? LONG_POW_5.length - 1 : n;
            li._size = Calculus.multiply(this._words, this._size, LONG_POW_5[i], li._words);
            int j = n - i;
            while (j != 0) {
                i = j >= LONG_POW_5.length ? LONG_POW_5.length - 1 : j;
                li._size = Calculus.multiply(li._words, li._size, LONG_POW_5[i], li._words);
                j -= i;
            }
            int wordShift = n < 63 ? 0 : n / 63;
            int bitShift = n - ((wordShift << 6) - wordShift);
            li._size = Calculus.shiftLeft(wordShift, bitShift, li._words, li._size, li._words);
            return li;
        }
        int wordShift = (n = -n) < 63 ? 0 : n / 63;
        int bitShift = n - ((wordShift << 6) - wordShift);
        if (this._size <= wordShift) {
            return ZERO;
        }
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size - wordShift);
        li._size = Calculus.shiftRight(wordShift, bitShift, this._words, this._size, li._words);
        int j = n;
        while (j != 0) {
            int i = j >= INT_POW_5.length ? INT_POW_5.length - 1 : j;
            Calculus.divide(li._words, li._size, INT_POW_5[i], li._words);
            if (li._size > 0 && li._words[li._size - 1] == 0L) {
                --li._size;
            }
            j -= i;
        }
        li._isNegative = this._isNegative && li._size != 0;
        return li;
    }

    @Override
    public boolean equals(Object that) {
        if (!(that instanceof LargeInteger)) {
            return false;
        }
        LargeInteger li = (LargeInteger)that;
        return this._size == li._size && this._isNegative == li._isNegative && Calculus.compare(this._words, li._words, this._size) == 0;
    }

    public boolean equals(long value) {
        if (this._size == 0) {
            return value == 0L;
        }
        return this._size <= 1 && !(this._isNegative ? -this._words[0] != value : this._words[0] != value) || value == Long.MIN_VALUE && this._isNegative && this._size == 2 && this._words[1] == 1L && this._words[0] == 0L;
    }

    @Override
    public int hashCode() {
        long code = 0L;
        int i = this._size - 1;
        while (i >= 0) {
            code = (code * 1050537101L + this._words[i]) % 1327144033L;
            --i;
        }
        return this._isNegative ? -((int)code) : (int)code;
    }

    @Override
    public long longValue() {
        if (this._size == 0) {
            return 0L;
        }
        return this._size <= 1 ? (this._isNegative ? -this._words[0] : this._words[0]) : (this._isNegative ? -(this._words[1] << 63 | this._words[0]) : this._words[1] << 63 | this._words[0]);
    }

    @Override
    public double doubleValue() {
        if (this._size == 0) {
            return 0.0;
        }
        if (this._size <= 1) {
            return this._isNegative ? -this._words[0] : this._words[0];
        }
        int n = this._size - 1;
        int bitLength = MathLib.bitLength((long)this._words[n]) + (n << 6) - n;
        int shift = 63 - bitLength;
        LargeInteger int63 = this.times2pow(shift);
        double d = MathLib.toDoublePow2((long)int63._words[0], (int)(-shift));
        return this._isNegative ? -d : d;
    }

    @Override
    public int compareTo(LargeInteger that) {
        if (this._isNegative && !that._isNegative) {
            return -1;
        }
        if (!this._isNegative && that._isNegative) {
            return 1;
        }
        if (this._size > that._size) {
            return this._isNegative ? -1 : 1;
        }
        if (that._size > this._size) {
            return this._isNegative ? 1 : -1;
        }
        return this._isNegative ? Calculus.compare(that._words, this._words, this._size) : Calculus.compare(this._words, that._words, this._size);
    }

    @Override
    public int compareTo(long value) {
        long thisValue;
        if (this._size > 1) {
            return value == Long.MIN_VALUE && this.equals(Long.MIN_VALUE) ? 0 : (this._isNegative ? -1 : 1);
        }
        long l = thisValue = this._isNegative ? -this._words[0] : this._words[0];
        return thisValue < value ? -1 : (thisValue == value ? 0 : 1);
    }

    @Override
    public LargeInteger copy() {
        LargeInteger li = (LargeInteger)ARRAY_FACTORY.array(this._size);
        li._isNegative = this._isNegative;
        li._size = this._size;
        if (this._size <= 1) {
            li._words[0] = this._words[0];
            return li;
        }
        System.arraycopy(this._words, 0, li._words, 0, this._size);
        return li;
    }

    @Override
    public Text toText() {
        return TextFormat.getInstance(LargeInteger.class).format((Object)this);
    }

    public Text toText(int radix) {
        TextBuilder tmp = TextBuilder.newInstance();
        try {
            LargeInteger.format(this, radix, (Appendable)tmp);
            Text text = tmp.toText();
            return text;
        }
        catch (IOException e) {
            throw new Error(e);
        }
        finally {
            TextBuilder.recycle((TextBuilder)tmp);
        }
    }

    public static LargeInteger parse(CharSequence csq, int radix, TextFormat.Cursor cursor) {
        int digit;
        int end = cursor.getEndIndex();
        boolean isNegative = cursor.at('-', csq);
        cursor.increment(isNegative || cursor.at('+', csq) ? 1 : 0);
        LargeInteger li = null;
        int maxDigits = radix <= 10 ? 18 : (radix <= 16 ? 15 : 12);
        do {
            int start = cursor.getIndex();
            cursor.setEndIndex(MathLib.min((int)(start + maxDigits), (int)end));
            long l = TypeFormat.parseLong((CharSequence)csq, (int)radix, (TextFormat.Cursor)cursor);
            int readCount = cursor.getIndex() - start;
            if (li == null) {
                li = LargeInteger.valueOf(l);
            } else {
                if (li._words.length < li._size + 2) {
                    LargeInteger tmp = (LargeInteger)ARRAY_FACTORY.array(li._size + 2);
                    System.arraycopy(li._words, 0, tmp._words, 0, li._size);
                    tmp._isNegative = li._isNegative;
                    tmp._size = li._size;
                    li = tmp;
                }
                long factor = LargeInteger.pow(radix, readCount);
                li._size = Calculus.multiply(li._words, li._size, factor, li._words);
                li._size = Calculus.add(li._words, li._size, l);
            }
            if (cursor.getIndex() == end) break;
            char c = csq.charAt(cursor.getIndex());
            int n = c <= '9' ? c - 48 : (c <= 'Z' && c >= 'A' ? c - 65 + 10 : (digit = c <= 'z' && c >= 'a' ? c - 97 + 10 : -1));
        } while (digit >= 0 && digit < radix);
        cursor.setEndIndex(end);
        return isNegative ? li.opposite() : li;
    }

    private static long pow(int radix, int n) {
        if (radix == 10) {
            return LONG_POW_10[n];
        }
        if (radix == 16) {
            return LONG_POW_16[n];
        }
        long l = 1L;
        int i = 0;
        while (i < n) {
            l *= (long)radix;
            ++i;
        }
        return l;
    }

    public static Appendable format(LargeInteger li, int radix, Appendable out) throws IOException {
        if (li._isNegative) {
            out.append('-');
        }
        int maxDigits = radix <= 10 ? 9 : (radix <= 16 ? 7 : 5);
        return LargeInteger.write(li.copy(), radix, (int)LargeInteger.pow(radix, maxDigits), out);
    }

    private static Appendable write(LargeInteger li, int radix, int divisor, Appendable out) throws IOException {
        if (li._size <= 1) {
            return TypeFormat.format((long)(li._size == 0 ? 0L : li._words[0]), (int)radix, (Appendable)out);
        }
        int rem = (int)Calculus.divide(li._words, li._size, divisor, li._words);
        if (li._words[li._size - 1] == 0L) {
            --li._size;
        }
        LargeInteger.write(li, radix, divisor, out);
        divisor /= radix;
        while (rem < divisor) {
            out.append('0');
            divisor /= radix;
        }
        if (rem != 0) {
            return TypeFormat.format((int)rem, (int)radix, (Appendable)out);
        }
        return out;
    }

    /* synthetic */ LargeInteger(int n, LargeInteger largeInteger) {
        this(n);
    }

    /* synthetic */ LargeInteger(LargeInteger largeInteger) {
        this();
    }
}

