/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Comparator;
import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.util.FastTable;
import javolution.util.Index;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DenseMatrix;
import org.jscience.mathematics.vector.DenseVector;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.SparseMatrix;
import org.jscience.mathematics.vector.SparseVector;

public final class LUDecomposition<F extends Field<F>> {
    public static final Comparator<Field> NUMERIC_COMPARATOR = new Comparator<Field>(){

        @Override
        public int compare(Field left, Field right) {
            if (left instanceof Number && right instanceof Number) {
                return ((Number)((Object)left)).isLargerThan((Number)((Object)right)) ? 1 : -1;
            }
            if (left.equals(left.plus(left))) {
                return -1;
            }
            if (right.equals(right.plus(right))) {
                return 1;
            }
            return 0;
        }
    };
    private static final LocalContext.Reference<Comparator<Field>> PIVOT_COMPARATOR = new LocalContext.Reference(NUMERIC_COMPARATOR);
    private int _n;
    private final FastTable<Index> _pivots = new FastTable();
    private DenseMatrix<F> _LU;
    private int _permutationCount;
    private static final ObjectFactory<LUDecomposition> FACTORY = new ObjectFactory<LUDecomposition>(){

        protected LUDecomposition create() {
            return new LUDecomposition(null);
        }

        protected void cleanup(LUDecomposition lu) {
            lu._LU = null;
        }
    };

    public static <F extends Field<F>> LUDecomposition<F> valueOf(Matrix<F> source) {
        if (!source.isSquare()) {
            throw new DimensionException("Matrix is not square");
        }
        int dimension = source.getNumberOfRows();
        LUDecomposition lu = (LUDecomposition)FACTORY.object();
        lu._n = dimension;
        lu._permutationCount = 0;
        lu.construct(source);
        return lu;
    }

    private void construct(Matrix<F> source) {
        this._LU = source instanceof DenseMatrix ? ((DenseMatrix)source).copy() : DenseMatrix.valueOf(source);
        this._pivots.clear();
        int i = 0;
        while (i < this._n) {
            this._pivots.add((Object)Index.valueOf((int)i));
            ++i;
        }
        Comparator<Field> cmp = LUDecomposition.getPivotComparator();
        int n = this._n;
        int k = 0;
        while (k < this._n) {
            int i2;
            if (cmp != null) {
                int pivot = k;
                i2 = k + 1;
                while (i2 < n) {
                    if (cmp.compare((Field)this._LU.get(i2, k), (Field)this._LU.get(pivot, k)) > 0) {
                        pivot = i2;
                    }
                    ++i2;
                }
                if (pivot != k) {
                    int j = 0;
                    while (j < n) {
                        F tmp = this._LU.get(pivot, j);
                        this._LU.set(pivot, j, this._LU.get(k, j));
                        this._LU.set(k, j, tmp);
                        ++j;
                    }
                    j = ((Index)this._pivots.get(pivot)).intValue();
                    this._pivots.set(pivot, (Object)((Index)this._pivots.get(k)));
                    this._pivots.set(k, (Object)Index.valueOf((int)j));
                    ++this._permutationCount;
                }
            }
            Field lukkInv = (Field)this._LU.get(k, k).inverse();
            i2 = k + 1;
            while (i2 < n) {
                this._LU.set(i2, k, this._LU.get(i2, k).times((Field)lukkInv));
                int j = k + 1;
                while (j < n) {
                    this._LU.set(i2, j, this._LU.get(i2, j).plus((Field)this._LU.get(i2, k).times((Field)((Field)this._LU.get(k, j).opposite()))));
                    ++j;
                }
                ++i2;
            }
            ++k;
        }
    }

    public static void setPivotComparator(Comparator<Field> cmp) {
        PIVOT_COMPARATOR.set(cmp);
    }

    public static Comparator<Field> getPivotComparator() {
        return (Comparator)PIVOT_COMPARATOR.get();
    }

    public DenseMatrix<F> solve(Matrix<F> B) {
        int j;
        F luik;
        int i;
        int j2;
        if (this._n != B.getNumberOfRows()) {
            throw new DimensionException("Input vector has " + B.getNumberOfRows() + " rows instead of " + this._n);
        }
        int n = B.getNumberOfColumns();
        DenseMatrix<F> X = this.createNullDenseMatrix(this._n, n);
        int i2 = 0;
        while (i2 < this._n) {
            j2 = 0;
            while (j2 < n) {
                X.set(i2, j2, B.get(((Index)this._pivots.get(i2)).intValue(), j2));
                ++j2;
            }
            ++i2;
        }
        int k = 0;
        while (k < this._n) {
            i = k + 1;
            while (i < this._n) {
                luik = this._LU.get(i, k);
                j = 0;
                while (j < n) {
                    X.set(i, j, X.get(i, j).plus((Field)luik.times((Field)((Field)X.get(k, j).opposite()))));
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        k = this._n - 1;
        while (k >= 0) {
            j2 = 0;
            while (j2 < n) {
                X.set(k, j2, (Field)((Field)this._LU.get(k, k).inverse()).times(X.get(k, j2)));
                ++j2;
            }
            i = 0;
            while (i < k) {
                luik = this._LU.get(i, k);
                j = 0;
                while (j < n) {
                    X.set(i, j, X.get(i, j).plus((Field)luik.times((Field)((Field)X.get(k, j).opposite()))));
                    ++j;
                }
                ++i;
            }
            --k;
        }
        return X;
    }

    private DenseMatrix<F> createNullDenseMatrix(int m, int n) {
        DenseMatrix M = DenseMatrix.newInstance(n, false);
        int i = 0;
        while (i < m) {
            DenseVector V = DenseVector.newInstance();
            M._rows.add(V);
            int j = 0;
            while (j < n) {
                V._elements.add(null);
                ++j;
            }
            ++i;
        }
        return M;
    }

    public DenseMatrix<F> inverse() {
        int i;
        int j;
        int n = this._n;
        DenseMatrix<F> R = this.createNullDenseMatrix(n, n);
        int i2 = 0;
        while (i2 < n) {
            j = i2;
            while (j < n) {
                R.set(i2, j, this._LU.get(i2, j));
                ++j;
            }
            ++i2;
        }
        int j2 = n - 1;
        while (j2 >= 0) {
            R.set(j2, j2, (Field)R.get(j2, j2).inverse());
            i = j2 - 1;
            while (i >= 0) {
                Field sum = R.get(i, j2).times((Field)((Field)R.get(j2, j2).opposite()));
                int k = j2 - 1;
                while (k > i) {
                    sum = sum.plus(R.get(i, k).times((Field)((Field)R.get(k, j2).opposite())));
                    --k;
                }
                R.set(i, j2, ((Field)R.get(i, i).inverse()).times(sum));
                --i;
            }
            --j2;
        }
        i2 = 0;
        while (i2 < n) {
            j = n - 2;
            while (j >= 0) {
                int k = j + 1;
                while (k < n) {
                    F lukj = this._LU.get(k, j);
                    if (R.get(i2, j) != null) {
                        R.set(i2, j, R.get(i2, j).plus((Field)R.get(i2, k).times((Field)((Field)lukj.opposite()))));
                    } else {
                        R.set(i2, j, R.get(i2, k).times((Field)((Field)lukj.opposite())));
                    }
                    ++k;
                }
                --j;
            }
            ++i2;
        }
        FastTable tmp = FastTable.newInstance();
        i = 0;
        while (i < n) {
            tmp.reset();
            int j3 = 0;
            while (j3 < n) {
                tmp.add(R.get(i, j3));
                ++j3;
            }
            j3 = 0;
            while (j3 < n) {
                R.set(i, ((Index)this._pivots.get(j3)).intValue(), (Field)tmp.get(j3));
                ++j3;
            }
            ++i;
        }
        FastTable.recycle((FastTable)tmp);
        return R;
    }

    public F determinant() {
        Object product = this._LU.get(0, 0);
        int i = 1;
        while (i < this._n) {
            product = (Field)product.times(this._LU.get(i, i));
            ++i;
        }
        return (F)((this._permutationCount & 1) == 0 ? product : (Field)product.opposite());
    }

    public DenseMatrix<F> getLower(F zero, F one) {
        Object L = this._LU.copy();
        int j = 0;
        while (j < this._n) {
            int i = 0;
            while (i < j) {
                ((DenseMatrix)L).set(i, j, zero);
                ++i;
            }
            ((DenseMatrix)L).set(j, j, one);
            ++j;
        }
        return L;
    }

    public DenseMatrix<F> getUpper(F zero) {
        Object U = this._LU.copy();
        int j = 0;
        while (j < this._n) {
            int i = j + 1;
            while (i < this._n) {
                ((DenseMatrix)U).set(i, j, zero);
                ++i;
            }
            ++j;
        }
        return U;
    }

    public SparseMatrix<F> getPermutation(F zero, F one) {
        SparseMatrix<F> P = SparseMatrix.newInstance(this._n, zero, false);
        int i = 0;
        while (i < this._n) {
            ((SparseVector)P.getRow((int)((Index)this._pivots.get((int)i)).intValue()))._elements.put((Object)Index.valueOf((int)i), one);
            ++i;
        }
        return P;
    }

    public DenseMatrix<F> getLU() {
        return this._LU;
    }

    public FastTable<Index> getPivots() {
        return this._pivots;
    }

    private LUDecomposition() {
    }

    /* synthetic */ LUDecomposition(LUDecomposition lUDecomposition) {
        this();
    }
}

