/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.completer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opt4j.common.completer.SequentialIndividualCompleter;
import org.opt4j.core.Individual;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerStateListener;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.problem.Decoder;
import org.opt4j.core.problem.Evaluator;
import org.opt4j.start.Constant;

public class ParallelIndividualCompleter
extends SequentialIndividualCompleter
implements OptimizerStateListener {
    protected final ExecutorService executor;

    @Inject
    public ParallelIndividualCompleter(Control control, Decoder decoder, Evaluator evaluator, @Constant(value="maxThreads", namespace=ParallelIndividualCompleter.class) int maxThreads) {
        super(control, decoder, evaluator);
        if (maxThreads < 1) {
            throw new IllegalArgumentException("Invalid number of threads: " + maxThreads);
        }
        this.executor = Executors.newFixedThreadPool(maxThreads);
    }

    @Override
    public void complete(Iterable<? extends Individual> iterable) throws TerminationException {
        try {
            ArrayList<Future<Void>> returns = new ArrayList<Future<Void>>();
            for (Individual individual : iterable) {
                if (individual.getState() == Individual.State.EVALUATED) continue;
                returns.add(this.executor.submit(new Complete(individual, this.control)));
            }
            for (Future future : returns) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof TerminationException) {
                throw (TerminationException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdownExecutorService();
        super.finalize();
    }

    protected synchronized void shutdownExecutorService() {
        if (!this.executor.isShutdown()) {
            this.executor.shutdown();
        }
    }

    @Override
    public void optimizationStarted(Optimizer optimizer) {
    }

    @Override
    public void optimizationStopped(Optimizer optimizer) {
        this.shutdownExecutorService();
    }

    protected class Complete
    implements Callable<Void> {
        protected final Individual individual;
        protected final Control control;

        public Complete(Individual individual, Control control) {
            this.individual = individual;
            this.control = control;
        }

        @Override
        public Void call() throws TerminationException {
            if (!this.individual.isEvaluated()) {
                this.control.checkpoint();
                ParallelIndividualCompleter.this.decode(this.individual);
                this.control.checkpoint();
                ParallelIndividualCompleter.this.evaluate(this.individual);
                this.control.checkpoint();
            }
            return null;
        }
    }
}

