/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.completer;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.Objectives;
import org.opt4j.core.Phenotype;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.IndividualCompleter;
import org.opt4j.core.optimizer.TerminationException;
import org.opt4j.core.problem.Decoder;
import org.opt4j.core.problem.Evaluator;

public class SequentialIndividualCompleter
implements IndividualCompleter {
    protected final Decoder<Genotype, Phenotype> decoder;
    protected final Evaluator<Phenotype> evaluator;
    protected final Control control;

    @Inject
    public SequentialIndividualCompleter(Control control, Decoder decoder, Evaluator evaluator) {
        this.control = control;
        this.decoder = decoder;
        this.evaluator = evaluator;
    }

    @Override
    public void complete(Iterable<? extends Individual> iterable) throws TerminationException {
        for (Individual individual : iterable) {
            if (individual.isEvaluated()) continue;
            this.control.checkpoint();
            this.decode(individual);
            this.control.checkpoint();
            this.evaluate(individual);
            this.control.checkpoint();
        }
    }

    @Override
    public void complete(Individual ... individuals) throws TerminationException {
        List<Individual> list = Arrays.asList(individuals);
        this.complete(list);
    }

    protected void evaluate(Individual individual) {
        Individual.State state = individual.getState();
        if (state != Individual.State.PHENOTYPED) {
            throw new IllegalStateException("Cannot evaluate Individual, current state: " + (Object)((Object)state));
        }
        individual.setState(Individual.State.EVALUATING);
        Phenotype phenotype = individual.getPhenotype();
        Objectives objectives = this.evaluator.evaluate(phenotype);
        individual.setObjectives(objectives);
    }

    protected void decode(Individual individual) {
        Individual.State state = individual.getState();
        if (state != Individual.State.GENOTYPED) {
            throw new IllegalStateException("Cannot decode Individual, current state: " + (Object)((Object)state));
        }
        individual.setState(Individual.State.DECODING);
        Genotype genotype = individual.getGenotype();
        Phenotype phenotype = this.decoder.decode(genotype);
        individual.setPhenotype(phenotype);
    }
}

