/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.logger;

import org.opt4j.common.logger.TsvLogger;
import org.opt4j.config.annotations.File;
import org.opt4j.config.annotations.Icon;
import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Order;
import org.opt4j.config.annotations.Required;
import org.opt4j.start.Constant;
import org.opt4j.viewer.VisualizationModule;

@Icon(value="icons/text.png")
@Info(value="Logs the contents of the archive to a file.")
public class LoggerModule
extends VisualizationModule {
    @Info(value="The name of the output file.")
    @Order(value=0)
    @File
    @Constant(value="filename", namespace=TsvLogger.class)
    protected String filename = "output.tsv";
    @Info(value="Log per evaluation activated.")
    protected boolean loggingPerEvaluation = false;
    @Info(value="Log per iteration activated.")
    protected boolean loggingPerIteration = true;
    @Info(value="Number of evaluations after which the archive is logged.")
    @Required(property="loggingPerEvaluation", elements={"TRUE"})
    protected int evaluationStep = 100;
    @Info(value="Number of iterations after which the archive is logged.")
    @Required(property="loggingPerIteration", elements={"TRUE"})
    protected int iterationStep = 1;

    @Override
    public void config() {
        this.bind(TsvLogger.class).in(SINGLETON);
        this.addIndividualStateListener(TsvLogger.class);
        this.addOptimizerIterationListener(TsvLogger.class);
        this.addOptimizerStateListener(TsvLogger.class);
        int evaluationStep = this.evaluationStep;
        int iterationStep = this.iterationStep;
        if (!this.loggingPerEvaluation) {
            evaluationStep = -1;
        }
        if (!this.loggingPerIteration) {
            iterationStep = -1;
        }
        this.bindConstant("evaluationStep", TsvLogger.class).to(evaluationStep);
        this.bindConstant("iterationStep", TsvLogger.class).to(iterationStep);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public int getEvaluationStep() {
        return this.evaluationStep;
    }

    public void setEvaluationStep(int evaluationStep) {
        this.evaluationStep = evaluationStep;
    }

    public int getIterationStep() {
        return this.iterationStep;
    }

    public void setIterationStep(int iterationStep) {
        this.iterationStep = iterationStep;
    }

    public boolean isLoggingPerEvaluation() {
        return this.loggingPerEvaluation;
    }

    public void setLoggingPerEvaluation(boolean loggingPerEvaluation) {
        this.loggingPerEvaluation = loggingPerEvaluation;
    }

    public boolean isLoggingPerIteration() {
        return this.loggingPerIteration;
    }

    public void setLoggingPerIteration(boolean loggingPerIteration) {
        this.loggingPerIteration = loggingPerIteration;
    }
}

