/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config;

import com.google.inject.Module;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opt4j.config.PropertyModule;
import org.opt4j.config.Requirement;

public class Property {
    protected final Module module;
    protected final String name;
    protected final Class<?> type;
    protected final Method getter;
    protected final Method setter;
    protected String info = "";
    protected int order = 10000;
    protected final Collection<Requirement> requirements = new ArrayList<Requirement>();
    protected final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();

    public Property(Module module, String name, Class<?> type, Method getter, Method setter, Iterable<Annotation> annotations) {
        this.module = module;
        this.name = name;
        this.type = type;
        this.getter = getter;
        this.setter = setter;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            this.annotations.put(clazz, annotation);
        }
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public void addRequirement(Requirement requirement) {
        this.requirements.add(requirement);
    }

    public boolean isActive() {
        for (Requirement requirement : this.requirements) {
            if (requirement.isFulfilled()) continue;
            return false;
        }
        return true;
    }

    public Collection<Requirement> getRequirements() {
        return this.requirements;
    }

    public Object getValue() {
        try {
            return this.getter.invoke((Object)this.module, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public void setValue(Object value) throws InvocationTargetException {
        this.setValueObject(value);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void setValue(String value) throws InvocationTargetException {
        block27: {
            type /* !! */  = this.type;
            try {
                if (type /* !! */ .equals(Integer.TYPE)) {
                    type /* !! */  = Integer.class;
                } else if (type /* !! */ .equals(Long.TYPE)) {
                    type /* !! */  = Long.class;
                } else if (type /* !! */ .equals(Double.TYPE)) {
                    type /* !! */  = Double.class;
                } else if (type /* !! */ .equals(Float.TYPE)) {
                    type /* !! */  = Float.class;
                } else if (type /* !! */ .equals(Boolean.TYPE)) {
                    type /* !! */  = Boolean.class;
                } else if (type /* !! */ .equals(Byte.TYPE)) {
                    type /* !! */  = Byte.class;
                } else if (type /* !! */ .equals(Short.TYPE)) {
                    type /* !! */  = Short.class;
                } else if (type /* !! */ .equals(String.class) && value == null) {
                    value = "";
                }
                object = null;
                if (Character.TYPE.equals(type /* !! */ ) || Character.class.equals(type /* !! */ )) {
                    object = Character.valueOf(value.toCharArray()[0]);
                } else if (type /* !! */ .isEnum()) {
                    object = PropertyModule.toEnumElement(value, type /* !! */ .asSubclass(Enum.class));
                } else if (type /* !! */ .equals(Class.class)) {
                    if (value != null && !value.equals("")) {
                        c = Class.forName(value);
                        gtype = this.getter.getGenericReturnType();
                        actual = this.getEnclosingType(gtype);
                        if (this.isAssignable(actual, c)) {
                            object = c;
                        } else {
                            System.err.println("Can not assign " + c + " to Class<" + actual + ">");
                        }
                    }
                } else {
                    constructor = type /* !! */ .getConstructor(new Class[]{String.class});
                    object = constructor.newInstance(new Object[]{value.trim()});
                }
                this.setValueObject(object);
                break block27;
            }
            catch (Exception e) {
                t = e;
                ** while (t.getCause() != null)
            }
lbl-1000:
            // 1 sources

            {
                t = t.getCause();
                continue;
            }
lbl52:
            // 1 sources

            message = t.getLocalizedMessage();
            throw new InvocationTargetException(e, "Failed assignment: module=" + this.module.getClass().getName() + " property=\"" + this.getName() + "\" value=\"" + value + "\" (" + t.getClass().getName() + (message != null ? ": " + message : "") + ")");
        }
    }

    public boolean isNumber() {
        boolean isNumber = false;
        if (this.type.equals(Integer.TYPE)) {
            isNumber = true;
        } else if (this.type.equals(Long.TYPE)) {
            isNumber = true;
        } else if (this.type.equals(Double.TYPE)) {
            isNumber = true;
        } else if (this.type.equals(Float.TYPE)) {
            isNumber = true;
        } else if (this.type.equals(Byte.TYPE)) {
            isNumber = true;
        } else if (this.type.equals(Short.TYPE)) {
            isNumber = true;
        }
        return isNumber;
    }

    private Type getEnclosingType(Type gtype) {
        ParameterizedType ptype;
        Type rtype;
        if (gtype instanceof ParameterizedType && (rtype = (ptype = (ParameterizedType)gtype).getRawType()).equals(Class.class)) {
            Type actual = ptype.getActualTypeArguments()[0];
            return actual;
        }
        return null;
    }

    private boolean isAssignable(Type type, Class<?> clazz) {
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            Type[] typeArray = wildcard.getLowerBounds();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class lowerClass;
                Type lower = typeArray[n2];
                if (lower instanceof Class && !clazz.isAssignableFrom(lowerClass = (Class)lower)) {
                    return false;
                }
                ++n2;
            }
            typeArray = wildcard.getUpperBounds();
            n = typeArray.length;
            n2 = 0;
            while (n2 < n) {
                Class upperClass;
                Type upper = typeArray[n2];
                if (upper instanceof Class && !(upperClass = (Class)upper).isAssignableFrom(clazz)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    protected void setValueObject(Object value) throws InvocationTargetException {
        try {
            this.setter.invoke((Object)this.module, value);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations.values();
    }

    public <A extends Annotation> A getAnnotation(Class<? extends A> clazz) {
        return (A)this.annotations.get(clazz);
    }
}

