/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config.visualization;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.util.concurrent.RejectedExecutionException;
import javax.swing.JFileChooser;

@Singleton
public class FileChooser {
    protected JFileChooser fileChooser = null;

    @Inject
    public FileChooser() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    FileChooser.this.fileChooser = new MyFileChooser();
                    FileChooser.this.fileChooser.setVisible(false);
                    FileChooser.this.ready();
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public synchronized JFileChooser get() {
        while (this.fileChooser == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.fileChooser;
    }

    public synchronized void ready() {
        this.notifyAll();
    }

    private static class MyFileChooser
    extends JFileChooser {
        public MyFileChooser() {
            super(new File(System.getProperty("user.home")));
        }

        @Override
        public void setCurrentDirectory(File file) {
            File dir;
            if (file == null) {
                return;
            }
            if (!file.isDirectory()) {
                dir = file.getParentFile();
                super.setSelectedFile(file);
            } else {
                dir = file;
            }
            if (dir == null || !dir.equals(this.getCurrentDirectory())) {
                super.setCurrentDirectory(dir);
            }
        }
    }
}

