/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opt4j.core.Criterion;
import org.opt4j.core.DoubleValue;
import org.opt4j.core.IntegerValue;
import org.opt4j.core.Value;

public abstract class CriterionSet<T extends Criterion>
implements Iterable<Map.Entry<T, Value<?>>> {
    protected SortedMap<T, Value<?>> map = new TreeMap();
    protected double[] array = null;

    @Override
    public Iterator<Map.Entry<T, Value<?>>> iterator() {
        return this.map.entrySet().iterator();
    }

    public abstract double[] array();

    public int size() {
        return this.map.size();
    }

    public Collection<T> getKeys() {
        return this.map.keySet();
    }

    public Collection<Value<?>> getValues() {
        return this.map.values();
    }

    public Value<?> get(T criterion) {
        return (Value)this.map.get(criterion);
    }

    public T get(Value<?> value) {
        Criterion t = null;
        for (Map.Entry<T, Value<?>> entry : this) {
            Value<?> v = entry.getValue();
            if (!value.equals(v)) continue;
            t = (Criterion)entry.getKey();
            break;
        }
        return (T)t;
    }

    public void add(T criterion, Value<?> value) {
        if (value == null) {
            this.map.put(criterion, new DoubleValue(null));
        } else {
            this.map.put(criterion, value);
        }
        this.array = null;
    }

    public void add(T criterion, double value) {
        this.add(criterion, new DoubleValue(value));
    }

    public void add(T criterion, int value) {
        this.add(criterion, new IntegerValue(value));
    }

    public void add(CriterionSet<T> criterionSet) {
        this.map.putAll(criterionSet.map);
        this.array = null;
    }

    public boolean isEqual(CriterionSet<T> opponent) {
        double[] vb;
        double[] va = this.array();
        if (va.length != (vb = opponent.array()).length) {
            return false;
        }
        int i = 0;
        while (i < va.length) {
            if (va[i] != vb[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public double distance(CriterionSet<T> other) {
        double[] vb;
        double[] va = this.array();
        if (va.length != (vb = other.array()).length) {
            return -1.0;
        }
        double s = 0.0;
        int i = 0;
        while (i < va.length) {
            s += (va[i] - vb[i]) * (va[i] - vb[i]);
            ++i;
        }
        return Math.sqrt(s);
    }
}

