/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.opt4j.core.Constraints;
import org.opt4j.core.CriterionSet;
import org.opt4j.core.DoubleValue;
import org.opt4j.core.IntegerValue;
import org.opt4j.core.Objective;
import org.opt4j.core.Value;
import org.opt4j.core.domination.DominationStrategy;
import org.opt4j.core.domination.ParetoDomination;

public class Objectives
extends CriterionSet<Objective> {
    protected final SortedMap<Objective, Value<?>> map = new TreeMap();
    protected boolean feasible = true;
    protected Constraints constraints = new Constraints();
    protected DominationStrategy dominationStrategy;

    @Deprecated
    public Objectives() {
        this.dominationStrategy = new ParetoDomination();
    }

    @Inject
    public Objectives(DominationStrategy strategy) {
        this.dominationStrategy = strategy;
    }

    public Constraints getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Constraints constraints) {
        this.constraints = constraints;
    }

    public DominationStrategy getDominationStrategy() {
        return this.dominationStrategy;
    }

    public boolean isFeasible() {
        return this.feasible;
    }

    public void setFeasible(boolean feasible) {
        this.feasible = feasible;
    }

    @Override
    public Iterator<Map.Entry<Objective, Value<?>>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public double[] array() {
        if (this.array == null) {
            this.submit();
        }
        return this.array;
    }

    protected synchronized void submit() {
        if (this.array == null) {
            this.array = new double[this.size()];
            int i = 0;
            for (Map.Entry<Objective, Value<?>> entry : this) {
                Objective objective = entry.getKey();
                Value<?> value = entry.getValue();
                Double v = value.getDouble();
                this.array[i] = v == null ? Double.MAX_VALUE : (objective.getSign() == Objective.Sign.MAX ? -v.doubleValue() : v);
                ++i;
            }
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Objective> getKeys() {
        return this.map.keySet();
    }

    @Override
    public Collection<Value<?>> getValues() {
        return this.map.values();
    }

    @Override
    public Value<?> get(Objective objective) {
        return (Value)this.map.get(objective);
    }

    @Override
    public Objective get(Value<?> value) {
        Objective objective = null;
        for (Map.Entry<Objective, Value<?>> entry : this) {
            Objective o;
            Value<?> v = entry.getValue();
            if (!value.equals(v)) continue;
            objective = o = entry.getKey();
            break;
        }
        return objective;
    }

    @Override
    public void add(Objective objective, Value<?> value) {
        if (value == null) {
            this.map.put(objective, new DoubleValue(null));
        } else {
            this.map.put(objective, value);
        }
        this.array = null;
    }

    @Override
    public void add(Objective objective, double value) {
        this.add(objective, (Value<?>)new DoubleValue(value));
    }

    @Override
    public void add(Objective objective, int value) {
        this.add(objective, (Value<?>)new IntegerValue(value));
    }

    @Deprecated
    public void add(Objectives objectives) {
        this.addAll(objectives);
    }

    public void addAll(Objectives objectives) {
        this.map.putAll(objectives.map);
        this.array = null;
    }

    public boolean weaklyDominates(Objectives opponent) {
        return this.dominationStrategy.weaklyDominates(this, opponent);
    }

    public boolean dominates(Objectives opponent) {
        return this.dominationStrategy.dominates(this, opponent);
    }

    public boolean isEqual(Objectives opponent) {
        double[] va = this.array();
        double[] vb = opponent.array();
        int i = 0;
        while (i < va.length) {
            if (va[i] != vb[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public double distance(Objectives other) {
        double[] va = this.array();
        double[] vb = other.array();
        double s = 0.0;
        int i = 0;
        while (i < va.length) {
            s += (va[i] - vb[i]) * (va[i] - vb[i]);
            ++i;
        }
        return Math.sqrt(s);
    }

    public String toString() {
        String s = "";
        for (Map.Entry<Objective, Value<?>> entry : this.map.entrySet()) {
            Objective o = entry.getKey();
            Value<?> v = entry.getValue();
            s = String.valueOf(s) + o + "=" + v + " ";
        }
        return s;
    }
}

