/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.domination;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.concurrent.ConcurrentHashMap;
import org.opt4j.core.Objectives;
import org.opt4j.core.domination.ConstraintChecker;
import org.opt4j.core.domination.DominationStrategy;

@Singleton
public class ConstraintDomination
implements DominationStrategy {
    protected ConstraintChecker constraintChecker;
    protected DominationStrategy feasibleStrategy;
    protected ConcurrentHashMap<Objectives, ConstrainDominationInformation> cache = new ConcurrentHashMap();

    @Inject
    public ConstraintDomination(ConstraintChecker checker, @Named(value="StrategyForFeasibleObjectives") DominationStrategy feasibleStrategy) {
        this.constraintChecker = checker;
        this.feasibleStrategy = feasibleStrategy;
    }

    @Override
    public boolean dominates(Objectives o1, Objectives o2) {
        boolean isFeasibleO2;
        boolean isFeasibleO1;
        Double violationO1 = new Double(0.0);
        Double violationO2 = new Double(0.0);
        if (this.cache.containsKey(o1)) {
            isFeasibleO1 = this.cache.get(o1).isFeasible();
            violationO1 = this.cache.get(o1).getConstraintViolation();
        } else {
            isFeasibleO1 = this.constraintChecker.isFeasible(o1);
            if (!isFeasibleO1) {
                violationO1 = this.constraintChecker.getConstraintViolation(o1);
            }
            this.cache.put(o1, new ConstrainDominationInformation(isFeasibleO1, violationO1));
        }
        if (this.cache.containsKey(o2)) {
            isFeasibleO2 = this.cache.get(o2).isFeasible();
            violationO2 = this.cache.get(o2).getConstraintViolation();
        } else {
            isFeasibleO2 = this.constraintChecker.isFeasible(o2);
            if (!isFeasibleO2) {
                violationO2 = this.constraintChecker.getConstraintViolation(o2);
            }
            this.cache.put(o2, new ConstrainDominationInformation(isFeasibleO2, violationO2));
        }
        o1.setFeasible(isFeasibleO1);
        o2.setFeasible(isFeasibleO2);
        if (isFeasibleO1 && isFeasibleO2) {
            return this.feasibleStrategy.dominates(o1, o2);
        }
        if (!isFeasibleO1 && !isFeasibleO2) {
            return violationO2 > violationO1;
        }
        return isFeasibleO1;
    }

    @Override
    public boolean weaklyDominates(Objectives o1, Objectives o2) {
        double[] a1 = o1.array();
        double[] a2 = o2.array();
        boolean equals = true;
        int i = 0;
        while (i < a1.length) {
            if (a1[i] != a2[i]) {
                equals = false;
                break;
            }
            ++i;
        }
        return equals || this.dominates(o1, o2);
    }

    protected class ConstrainDominationInformation {
        protected final boolean isFeasible;
        protected final Double constraintViolation;

        public ConstrainDominationInformation(boolean isFeasible, Double constraintViolation) {
            this.isFeasible = isFeasible;
            this.constraintViolation = constraintViolation;
        }

        public boolean isFeasible() {
            return this.isFeasible;
        }

        public Double getConstraintViolation() {
            return this.constraintViolation;
        }

        public String toString() {
            return "Info: isFeasible: " + this.isFeasible + ", CV: " + this.constraintViolation;
        }
    }
}

