/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.genotype;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.opt4j.core.Genotype;
import org.opt4j.genotype.BooleanGenotype;
import org.opt4j.genotype.MapGenotype;

public class BooleanMapGenotype<K>
extends BooleanGenotype
implements MapGenotype<K, Boolean> {
    protected final List<K> list;
    private static final long serialVersionUID = 1L;

    public BooleanMapGenotype(List<K> list) {
        this.list = list;
    }

    public void init(Random random) {
        super.init(random, this.list.size());
    }

    @Override
    public void init(Random random, int n) {
        throw new UnsupportedOperationException("Use method init(Random) instead");
    }

    @Override
    public Boolean getValue(K key) {
        int i = this.list.indexOf(key);
        return (Boolean)this.get(i);
    }

    @Override
    public void setValue(K key, Boolean value) {
        int i = this.list.indexOf(key);
        while (this.size() <= i) {
            this.add(false);
        }
        this.set(i, value);
    }

    @Override
    public boolean containsKey(K key) {
        return this.list.contains(key);
    }

    @Override
    public <G extends Genotype> G newInstance() {
        try {
            Constructor<?> cstr = this.getClass().getConstructor(List.class);
            return (G)((Genotype)cstr.newInstance(this.list));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        String s = "[";
        int i = 0;
        while (i < this.size()) {
            K key = this.list.get(i);
            boolean value = (Boolean)this.get(i);
            s = String.valueOf(s) + key + "=" + value + ";";
            ++i;
        }
        return String.valueOf(s) + "]";
    }

    @Override
    public int getIndexOf(K key) {
        return this.list.indexOf(key);
    }

    @Override
    public Collection<K> getKeys() {
        return Collections.unmodifiableList(this.list);
    }
}

