/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Parameters {
    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static Type getType(Class<?> clazz, Object object, String variable) {
        return Parameters.getType(clazz, variable, Parameters.getTypes(object.getClass()));
    }

    protected static Type getType(Class<?> clazz, String variable, Map<Type, ParameterizedType> map) {
        ParameterizedType ptype = map.get(clazz);
        if (ptype == null) {
            return null;
        }
        Type type = null;
        int j = 0;
        while (j < ptype.getActualTypeArguments().length) {
            TypeVariable<Class<?>> v = clazz.getTypeParameters()[j];
            if (v.getName().equals(variable)) {
                type = ptype.getActualTypeArguments()[j];
            }
            ++j;
        }
        block1: while (type instanceof TypeVariable) {
            TypeVariable var = (TypeVariable)type;
            ParameterizedType paramType = map.get(var.getGenericDeclaration());
            Class freeType = (Class)paramType.getRawType();
            int size = freeType.getTypeParameters().length;
            int j2 = 0;
            while (j2 < size) {
                TypeVariable f = freeType.getTypeParameters()[j2];
                if (f.equals(var)) {
                    type = paramType.getActualTypeArguments()[j2];
                    continue block1;
                }
                ++j2;
            }
        }
        return type;
    }

    protected static Map<Type, ParameterizedType> getTypes(Class<?> clazz) {
        Collection<Class<?>> classes = Parameters.getAllClasses(clazz);
        Collection<ParameterizedType> paramTypes = Parameters.getParameterizedTypes(classes);
        HashMap<Type, ParameterizedType> map = new HashMap<Type, ParameterizedType>();
        for (ParameterizedType p : paramTypes) {
            map.put(p.getRawType(), p);
        }
        return map;
    }

    protected static Collection<Class<?>> getAllClasses(Class<?> clazz) {
        HashSet set = new HashSet();
        if (clazz != null && !clazz.equals(Object.class)) {
            set.add(clazz);
            Class<?> superclass = clazz.getSuperclass();
            set.addAll(Parameters.getAllClasses(superclass));
            Class<?>[] classArray = clazz.getInterfaces();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> inf = classArray[n2];
                set.addAll(Parameters.getAllClasses(inf));
                ++n2;
            }
        }
        return set;
    }

    protected static Collection<ParameterizedType> getParameterizedTypes(Collection<Class<?>> classes) {
        HashSet<ParameterizedType> paramTypes = new HashSet<ParameterizedType>();
        for (Class<?> clazz : classes) {
            Type type = clazz.getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                ParameterizedType p = (ParameterizedType)type;
                paramTypes.add(p);
            }
            Type[] typeArray = clazz.getGenericInterfaces();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type t = typeArray[n2];
                if (t instanceof ParameterizedType) {
                    ParameterizedType p = (ParameterizedType)t;
                    paramTypes.add(p);
                }
                ++n2;
            }
        }
        return paramTypes;
    }
}

