/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.neighbor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Genotype;
import org.opt4j.genotype.CompositeGenotype;
import org.opt4j.operator.AbstractGenericOperator;
import org.opt4j.operator.neighbor.Neighbor;
import org.opt4j.operator.neighbor.NeighborBoolean;
import org.opt4j.operator.neighbor.NeighborDouble;
import org.opt4j.operator.neighbor.NeighborInteger;
import org.opt4j.operator.neighbor.NeighborPermutation;

@Singleton
public class NeighborGenericImplementation
extends AbstractGenericOperator<Neighbor<Genotype>, Neighbor<?>>
implements Neighbor<Genotype> {
    protected final Rand random;

    @Inject
    protected NeighborGenericImplementation(Rand random) {
        super(NeighborBoolean.class, NeighborDouble.class, NeighborInteger.class, NeighborPermutation.class);
        this.random = random;
    }

    @Override
    public void neighbor(Genotype genotype) {
        Neighbor neighbor = (Neighbor)this.getOperator(genotype);
        if (neighbor == null) {
            this.neighborComposite((CompositeGenotype)genotype);
        } else {
            neighbor.neighbor(genotype);
        }
    }

    protected void neighborComposite(CompositeGenotype<?, ?> genotype) {
        int size = genotype.size();
        int i = this.random.nextInt(size);
        int sum = 0;
        Genotype g = null;
        for (Genotype entry : genotype.values()) {
            g = entry;
            if (i < (sum += g.size())) break;
        }
        this.neighbor(g);
    }
}

