/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.ea;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Individual;
import org.opt4j.core.Objectives;
import org.opt4j.optimizer.ea.Nsga2;
import org.opt4j.optimizer.ea.Selector;
import org.opt4j.start.Constant;

public class AlternativeNsga2
implements Selector {
    protected final Random random;
    protected final int tournament;
    protected final Map<Individual, Integer> map = new HashMap<Individual, Integer>();
    protected Individual[] ind = new Individual[0];
    protected int[] rank = new int[0];
    protected double[] dist = new double[0];
    protected Integer m = null;
    protected List<List<Integer>> fronts;

    @Inject
    public AlternativeNsga2(Rand random, @Constant(value="tournament", namespace=Nsga2.class) int tournament) {
        this.random = random;
        this.tournament = tournament;
    }

    @Override
    public void init(int maxsize) {
        this.map.clear();
        this.ind = new Individual[maxsize];
        this.rank = new int[maxsize];
        this.dist = new double[maxsize];
    }

    @Override
    public Collection<Individual> getParents(int mu, Collection<Individual> population) {
        if (this.synchronize(population)) {
            this.fronts();
        }
        ArrayList<Integer> all = new ArrayList<Integer>(this.map.values());
        ArrayList<Individual> parents = new ArrayList<Individual>();
        int size = all.size();
        ArrayList<Integer> alreadyCalculatedRanks = new ArrayList<Integer>();
        int i = 0;
        while (i < mu) {
            int winner = (Integer)all.get(this.random.nextInt(size));
            int t = 0;
            while (t < this.tournament) {
                int opponent = (Integer)all.get(this.random.nextInt(size));
                if (this.rank[opponent] < this.rank[winner] || opponent == winner) {
                    winner = opponent;
                } else if (this.rank[opponent] == this.rank[winner]) {
                    List<Integer> front = this.fronts.get(this.rank[winner]);
                    if (!alreadyCalculatedRanks.contains(this.rank[winner])) {
                        alreadyCalculatedRanks.add(this.rank[winner]);
                        this.calcDistance(front);
                    }
                    if (this.dist[winner] < this.dist[opponent]) {
                        winner = opponent;
                    }
                }
                ++t;
            }
            parents.add(this.ind[winner]);
            ++i;
        }
        return parents;
    }

    @Override
    public Collection<Individual> getLames(int n, Collection<Individual> population) {
        this.synchronize(population);
        ArrayList<Integer> remove = new ArrayList<Integer>();
        int size = n;
        List<List<Integer>> fronts = this.fronts();
        Collections.reverse(fronts);
        for (List<Integer> front : fronts) {
            if (remove.size() + front.size() < size) {
                remove.addAll(front);
                continue;
            }
            this.calcDistance(front);
            Collections.reverse(front);
            remove.addAll(front.subList(0, size - remove.size()));
        }
        ArrayList<Individual> truncate = new ArrayList<Individual>();
        for (Integer k : remove) {
            truncate.add(this.ind[k]);
        }
        return truncate;
    }

    public List<List<Integer>> fronts() {
        Iterator iterator;
        ArrayList<Integer> pop = new ArrayList<Integer>(this.map.values());
        ArrayList<List<Integer>> fronts = new ArrayList<List<Integer>>();
        List[] S = new List[this.ind.length];
        int[] n = new int[this.ind.length];
        Iterator iterator2 = pop.iterator();
        while (iterator2.hasNext()) {
            int e = (Integer)iterator2.next();
            S[e] = new ArrayList();
            n[e] = 0;
        }
        int i = 0;
        while (i < pop.size()) {
            int j = i + 1;
            while (j < pop.size()) {
                Objectives qo;
                int p = (Integer)pop.get(i);
                int n2 = (Integer)pop.get(j);
                Objectives po = this.ind[p].getObjectives();
                if (po.dominates(qo = this.ind[n2].getObjectives())) {
                    S[p].add(n2);
                    int n3 = n2;
                    n[n3] = n[n3] + 1;
                } else if (qo.dominates(po)) {
                    S[n2].add(p);
                    int n4 = p;
                    n[n4] = n[n4] + 1;
                }
                ++j;
            }
            ++i;
        }
        ArrayList<Integer> f1 = new ArrayList<Integer>();
        Iterator p = pop.iterator();
        while (p.hasNext()) {
            int i2 = (Integer)p.next();
            if (n[i2] != 0) continue;
            f1.add(i2);
        }
        fronts.add(f1);
        ArrayList<Integer> fi = f1;
        while (!fi.isEmpty()) {
            ArrayList<Integer> h = new ArrayList<Integer>();
            Iterator iterator3 = fi.iterator();
            while (iterator3.hasNext()) {
                int n5 = (Integer)iterator3.next();
                iterator = S[n5].iterator();
                while (iterator.hasNext()) {
                    int q;
                    int n6 = q = ((Integer)iterator.next()).intValue();
                    n[n6] = n[n6] - 1;
                    if (n[q] != 0) continue;
                    h.add(q);
                }
            }
            fronts.add(h);
            fi = h;
        }
        int i3 = 0;
        for (List list : fronts) {
            iterator = list.iterator();
            while (iterator.hasNext()) {
                int p3 = (Integer)iterator.next();
                this.rank[p3] = i3;
            }
            ++i3;
        }
        this.fronts = fronts;
        return fronts;
    }

    protected void calcDistance(List<Integer> list) {
        if (list.size() < 3) {
            return;
        }
        for (int e : list) {
            this.dist[e] = 0.0;
        }
        if (this.m == null) {
            this.m = this.ind[list.get(0)].getObjectives().array().length;
        }
        int i = 0;
        while (i < this.m) {
            Collections.sort(list, new DimensionSort(i));
            this.dist[list.get((int)0).intValue()] = Double.MAX_VALUE;
            this.dist[list.get((int)(list.size() - 1)).intValue()] = Double.MAX_VALUE;
            int j = 1;
            while (j < list.size() - 1) {
                double p = this.ind[list.get(j - 1)].getObjectives().array()[i];
                double n = this.ind[list.get(j + 1)].getObjectives().array()[i];
                int n2 = list.get(j);
                this.dist[n2] = this.dist[n2] + (n - p);
                ++j;
            }
            ++i;
        }
        Collections.sort(list, new Comparator<Integer>(){

            @Override
            public int compare(Integer p, Integer q) {
                double qv;
                double pv = AlternativeNsga2.this.dist[p];
                if (pv - (qv = AlternativeNsga2.this.dist[q]) > 0.0) {
                    return -1;
                }
                if (qv - pv > 0.0) {
                    return 1;
                }
                return 0;
            }
        });
    }

    protected boolean synchronize(Collection<Individual> population) {
        if (population.size() > this.ind.length) {
            this.init((int)Math.ceil((double)population.size() * 1.33));
        }
        HashSet<Individual> remove = new HashSet<Individual>();
        remove.addAll(this.map.keySet());
        remove.removeAll(population);
        HashSet<Individual> add = new HashSet<Individual>();
        add.addAll(population);
        add.removeAll(this.map.keySet());
        for (Individual e : remove) {
            int i = this.map.remove(e);
            this.ind[i] = null;
        }
        int i = 0;
        for (Individual e : add) {
            while (this.ind[i++] != null) {
            }
            this.ind[--i] = e;
            this.map.put(e, i);
        }
        return !remove.isEmpty() || !add.isEmpty();
    }

    class DimensionSort
    implements Comparator<Integer> {
        final int d;

        public DimensionSort(int d) {
            this.d = d;
        }

        @Override
        public int compare(Integer p, Integer q) {
            double qv;
            double pv = AlternativeNsga2.this.ind[p].getObjectives().array()[this.d];
            if (pv - (qv = AlternativeNsga2.this.ind[q].getObjectives().array()[this.d]) > 0.0) {
                return 1;
            }
            if (qv - pv > 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

