/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.sa;

import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Order;
import org.opt4j.config.annotations.Parent;
import org.opt4j.config.annotations.Required;
import org.opt4j.optimizer.sa.CoolingSchedule;
import org.opt4j.optimizer.sa.CoolingScheduleExponential;
import org.opt4j.optimizer.sa.CoolingScheduleHyperbolic;
import org.opt4j.optimizer.sa.CoolingScheduleLinear;
import org.opt4j.optimizer.sa.CoolingScheduleModule;
import org.opt4j.optimizer.sa.SimulatedAnnealingModule;
import org.opt4j.start.Constant;

@Info(value="Common Cooling Schedules")
@Parent(value=SimulatedAnnealingModule.class)
public class CoolingSchedulesModule
extends CoolingScheduleModule {
    @Constant(value="t0", namespace=CoolingSchedule.class)
    protected double initialTemperature = 10.0;
    @Constant(value="tn", namespace=CoolingSchedule.class)
    protected double finalTemperature = 1.0;
    @Required(property="type", elements={"EXPONENTIAL"})
    @Constant(value="alpha", namespace=CoolingScheduleExponential.class)
    protected double alpha = 0.995;
    @Order(value=0)
    protected Type type = Type.LINEAR;

    @Info(value="The temperature at the end of the optimization")
    public double getFinalTemperature() {
        return this.finalTemperature;
    }

    public void setFinalTemperature(double finalTemperature) {
        this.finalTemperature = finalTemperature;
    }

    @Info(value="The temperature at the beginning of the optimization")
    public double getInitialTemperature() {
        return this.initialTemperature;
    }

    public void setInitialTemperature(double initialTemperature) {
        this.initialTemperature = initialTemperature;
    }

    @Info(value="The type of the cooling schedule")
    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    @Override
    public void config() {
        switch (this.type) {
            case LINEAR: {
                this.bindCoolingSchedule(CoolingScheduleLinear.class);
                break;
            }
            case HYPERBOLIC: {
                this.bindCoolingSchedule(CoolingScheduleHyperbolic.class);
                break;
            }
            default: {
                this.bindCoolingSchedule(CoolingScheduleExponential.class);
            }
        }
    }

    public static enum Type {
        LINEAR,
        HYPERBOLIC,
        EXPONENTIAL;

    }
}

