/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.MatteBorder;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.optimizer.Population;
import org.opt4j.viewer.AutoZoomButton;
import org.opt4j.viewer.ConvergencePlotWidget;
import org.opt4j.viewer.DelayTask;
import org.opt4j.viewer.ObjectivesMonitor;
import org.opt4j.viewer.SynchronizedIndividualSet;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.Widget;
import org.opt4j.viewer.WidgetParameters;

@WidgetParameters(title="Pareto Plot", icon="icons/stat.png")
public class ParetoPlotWidget
implements OptimizerIterationListener,
Widget,
ObjectivesMonitor.ObjectivesListener {
    protected final SynchronizedIndividualSet population;
    protected final SynchronizedIndividualSet archive;
    protected final DelayTask task = new DelayTask(40L);
    protected final Selection selection;
    protected final JPanel panel = new JPanel();

    @Inject
    public ParetoPlotWidget(Population population, Archive archive, Optimizer optimizer, ObjectivesMonitor objectivesMonitor, AutoZoomButton autoZoomButton) {
        this.population = new SynchronizedIndividualSet(population);
        this.archive = new SynchronizedIndividualSet(archive);
        this.selection = new Selection();
        this.selection.addSeparator();
        this.selection.add(autoZoomButton);
        objectivesMonitor.addListener(this);
        optimizer.addOptimizerIterationListener(this);
    }

    @Override
    public void init(Viewport viewport) {
    }

    @Override
    public void iterationComplete(Optimizer optimizer, int iteration) {
        this.doPaint();
    }

    protected Set<Point2D.Double> getPoints(Collection<Individual> indivualCollection, Objective one, Objective two) {
        HashSet<Point2D.Double> points = new HashSet<Point2D.Double>();
        for (Individual individual : indivualCollection) {
            if (individual == null || !individual.isEvaluated()) continue;
            Objectives objectives = individual.getObjectives();
            if (one == null || two == null) continue;
            Value<?> onev = objectives.get(one);
            Value<?> twov = objectives.get(two);
            if (onev == null || twov == null || onev.getValue() == Objective.INFEASIBLE || twov.getValue() == Objective.INFEASIBLE) continue;
            double x = objectives.get(one).getDouble();
            double y = objectives.get(two).getDouble();
            Point2D.Double point = new Point2D.Double(x, y);
            points.add(point);
        }
        return points;
    }

    protected void doPaint() {
        this.task.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet<Individual> a = new HashSet<Individual>();
                SynchronizedIndividualSet synchronizedIndividualSet = ParetoPlotWidget.this.archive;
                synchronized (synchronizedIndividualSet) {
                    a.addAll(ParetoPlotWidget.this.archive);
                }
                HashSet<Individual> p = new HashSet<Individual>();
                SynchronizedIndividualSet synchronizedIndividualSet2 = ParetoPlotWidget.this.population;
                synchronized (synchronizedIndividualSet2) {
                    p.addAll(ParetoPlotWidget.this.population);
                }
                ParetoPlotWidget.this.paint(a, p);
            }
        });
    }

    protected void paint(Collection<Individual> archive, Collection<Individual> population) {
        Objective one = this.selection.getFirst();
        Objective two = this.selection.getSecond();
        population.removeAll(archive);
        Set<Point2D.Double> archivePoints = this.getPoints(archive, one, two);
        Set<Point2D.Double> populationPoints = this.getPoints(population, one, two);
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void objectives(Collection<Objective> objectives) {
        this.selection.init(objectives);
    }

    protected class Selection
    extends JToolBar
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        protected ConvergencePlotWidget.ObjectiveDropDown firstComboBox = new ConvergencePlotWidget.ObjectiveDropDown();
        protected ConvergencePlotWidget.ObjectiveDropDown secondComboBox = new ConvergencePlotWidget.ObjectiveDropDown();

        public Selection() {
            this.firstComboBox.addActionListener(this);
            this.secondComboBox.addActionListener(this);
            this.add(new JLabel("x-Axis: "));
            this.add(this.firstComboBox);
            this.addSeparator();
            this.add(new JLabel("y-Axis: "));
            this.add(this.secondComboBox);
            this.setFloatable(false);
            MatteBorder border = BorderFactory.createMatteBorder(0, 0, 1, 0, this.getBackground().darker());
            this.setBorder(border);
        }

        public void init(Collection<Objective> objectives) {
            for (Objective objective : objectives) {
                this.firstComboBox.addItem(objective);
                this.secondComboBox.addItem(objective);
            }
            this.initSelection(new ArrayList<Objective>(objectives));
        }

        private void initSelection(List<Objective> objectives) {
            if (objectives.size() <= 0) {
                return;
            }
            Objective objective1 = objectives.get(0);
            Objective objective2 = objectives.size() > 1 ? objectives.get(1) : objectives.get(0);
            this.firstComboBox.setSelected(objective1);
            this.secondComboBox.setSelected(objective2);
        }

        public Objective getFirst() {
            return this.firstComboBox.getSelected();
        }

        public Objective getSecond() {
            return this.secondComboBox.getSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ParetoPlotWidget.this.doPaint();
        }
    }
}

