/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.IndividualSet;
import org.opt4j.core.IndividualSetListener;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Population;
import org.opt4j.viewer.DelayTask;
import org.opt4j.viewer.ObjectivesMonitor;
import org.opt4j.viewer.QTable;
import org.opt4j.viewer.SynchronizedIndividualList;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.Widget;
import org.opt4j.viewer.WidgetParameters;

@WidgetParameters(title="Population Monitor", icon="icons/user-blue.png")
public class PopulationWidget
implements IndividualStateListener,
IndividualSetListener,
Widget,
ObjectivesMonitor.ObjectivesListener {
    protected static final int OFFSET = 3;
    protected final Archive archive;
    protected final SynchronizedIndividualList population;
    protected List<Individual> swtIndividuals = Collections.emptyList();
    protected final List<Objective> objectives = new ArrayList<Objective>();
    protected final JPanel panel = new JPanel();
    protected final JTable table;
    protected int size = 0;
    protected final DelayTask task = new DelayTask(40L);

    @Inject
    public PopulationWidget(Population population, Archive archive, IndividualFactory individualFactory, ObjectivesMonitor objectivesMonitor) {
        this.archive = archive;
        this.population = new SynchronizedIndividualList(population);
        this.population.addListener(this);
        this.table = this.getTable();
        JScrollPane scroll = new JScrollPane(this.table);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)scroll, "Center");
        individualFactory.addIndividualStateListener(this);
        objectivesMonitor.addListener(this);
        this.paint();
    }

    protected final JTable getTable() {
        Model model = new Model();
        Table table = new Table(model);
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(25);
        columnModel.getColumn(1).setPreferredWidth(140);
        return table;
    }

    @Override
    public synchronized void init(Viewport viewport) {
    }

    @Override
    public void inidividualStateChanged(Individual individual) {
        this.paint();
    }

    @Override
    public synchronized void individualAdded(IndividualSet collection, Individual individual) {
        this.paint();
    }

    @Override
    public synchronized void individualRemoved(IndividualSet collection, Individual individual) {
        this.paint();
    }

    protected void paint() {
        this.task.execute(new Runnable(){

            @Override
            public void run() {
                final ArrayList<Individual> temp = new ArrayList<Individual>();
                temp.addAll(PopulationWidget.this.population);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        (this).PopulationWidget.this.swtIndividuals = temp;
                        if ((this).PopulationWidget.this.table != null) {
                            if ((this).PopulationWidget.this.table.getColumnCount() != (this).PopulationWidget.this.table.getModel().getColumnCount()) {
                                (this).PopulationWidget.this.table.createDefaultColumnsFromModel();
                            }
                            (this).PopulationWidget.this.table.revalidate();
                            (this).PopulationWidget.this.table.repaint();
                        }
                    }
                });
            }
        });
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void objectives(final Collection<Objective> obj) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PopulationWidget.this.objectives.addAll(obj);
            }
        });
        this.paint();
    }

    protected class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        protected Model() {
        }

        @Override
        public int getColumnCount() {
            return 3 + PopulationWidget.this.objectives.size();
        }

        @Override
        public int getRowCount() {
            PopulationWidget.this.size = Math.max(PopulationWidget.this.size, PopulationWidget.this.swtIndividuals.size());
            return PopulationWidget.this.size;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "#";
            }
            if (col == 1) {
                return "Individual";
            }
            if (col == 2) {
                return "State";
            }
            int index = col - 3;
            Objective objective = PopulationWidget.this.objectives.get(index);
            return String.valueOf(objective.getName()) + " (" + (Object)((Object)objective.getSign()) + ")";
        }

        @Override
        public Object getValueAt(int row, int col) {
            try {
                Individual individual = PopulationWidget.this.swtIndividuals.get(row);
                Individual.State state = individual.getState();
                if (individual != null) {
                    if (col == 0) {
                        return row + 1;
                    }
                    if (col == 1) {
                        return individual.getPhenotype();
                    }
                    if (col == 2) {
                        return state;
                    }
                    if (state == Individual.State.EVALUATED) {
                        int index = col - 3;
                        Objectives o = individual.getObjectives();
                        Objective objective = PopulationWidget.this.objectives.get(index);
                        return o.get(objective).getValue();
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return null;
        }
    }

    protected class Table
    extends QTable {
        private static final long serialVersionUID = 1L;

        public Table(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            String family = c.getFont().getFamily();
            int size = c.getFont().getSize();
            try {
                int model = row;
                Individual individual = PopulationWidget.this.swtIndividuals.get(model);
                if (individual != null) {
                    if (PopulationWidget.this.archive.contains(individual)) {
                        c.setFont(new Font(family, 1, size));
                    }
                    if (individual.getState().isProcessing()) {
                        c.setForeground(Color.RED);
                    } else {
                        c.setForeground(Color.BLACK);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return c;
        }
    }
}

