/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.opt4j.config.Icons;
import org.opt4j.viewer.Widget;
import org.opt4j.viewer.WidgetParameters;

public class Viewport {
    protected final JDesktopPane desktop = new JDesktopPane();
    protected final JPanel panel = new JPanel();
    protected static final int OFFSET = 30;
    protected final Map<Widget, JInternalFrame> widgets = new HashMap<Widget, JInternalFrame>();

    public void init() {
        this.desktop.setDragMode(1);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.desktop, "Center");
        this.desktop.setBackground(Color.WHITE);
    }

    public void addWidget(Widget widget) {
        JInternalFrame frame;
        if (!this.widgets.keySet().contains(widget)) {
            frame = this.createInternalFrame(widget);
            this.addToDesktop(frame);
        } else {
            frame = this.widgets.get(widget);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (frame.isIcon()) {
                    try {
                        frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
                frame.setVisible(true);
                frame.moveToFront();
            }
        });
    }

    protected JInternalFrame createInternalFrame(final Widget widget) {
        ImageIcon frameIcon;
        String frameTitle;
        final JPanel panel = widget.getPanel();
        boolean resizable = true;
        boolean closable = true;
        boolean maximizable = true;
        boolean iconifiable = true;
        WidgetParameters parameters = widget.getClass().getAnnotation(WidgetParameters.class);
        if (parameters != null) {
            frameTitle = parameters.title();
            frameIcon = !parameters.icon().equals("") ? Icons.getIcon(parameters.icon()) : null;
            resizable = parameters.resizable();
            closable = parameters.closable();
            maximizable = parameters.maximizable();
            iconifiable = parameters.iconifiable();
        } else {
            frameTitle = null;
            frameIcon = null;
        }
        final JInternalFrame inFrame = new JInternalFrame(frameTitle, resizable, closable, maximizable, iconifiable);
        widget.init(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                inFrame.addInternalFrameListener(new InternalFrameAdapter(){

                    @Override
                    public void internalFrameClosed(InternalFrameEvent arg0) {
                        (this).Viewport.this.widgets.remove(widget);
                    }
                });
                inFrame.setFrameIcon(frameIcon);
                inFrame.getContentPane().setLayout(new BorderLayout());
                inFrame.getContentPane().add((Component)panel, "Center");
                int windows = Viewport.this.desktop.getAllFrames().length;
                inFrame.setLocation(30 * (windows %= 6), 30 * windows);
            }
        });
        this.widgets.put(widget, inFrame);
        return inFrame;
    }

    public void addToDesktop(final JInternalFrame inFrame) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                inFrame.pack();
                Viewport.this.desktop.add(inFrame);
            }
        });
    }

    public JInternalFrame getInternalFrame(Widget widget) {
        return this.widgets.get(widget);
    }

    public JComponent get() {
        return this.panel;
    }
}

