/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofile.registry.IProfileRegistry;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.architecturaltemplates.AT;
import org.palladiosimulator.architecturaltemplates.Role;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.mdsdprofiles.api.ProfileAPI;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.system.System;

public final class ArchitecturalTemplateAPI {
    private static final String ROLE_URI = "roleURI";
    private static final String SYSTEM_ROLE_NAME_SUFFIX = "System";

    private ArchitecturalTemplateAPI() {
    }

    public static Role getRole(Stereotype stereotype) {
        if (!ArchitecturalTemplateAPI.isRole(stereotype)) {
            throw new RuntimeException("Stereotype \"" + stereotype + "\" is no role");
        }
        EObject roleURIEObject = EMFLoadHelper.loadAndResolveEObject((String)stereotype.getTaggedValue(ROLE_URI).getDefaultValueLiteral());
        if (!(roleURIEObject instanceof Role)) {
            throw new RuntimeException("RoleURI Stereotype \"" + stereotype + "\" does not refer to a role");
        }
        return (Role)roleURIEObject;
    }

    public static AT getArchitecturalTemplate(Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        return ArchitecturalTemplateAPI.getRole((Stereotype)profile.getStereotypes().get(0)).getAT();
    }

    public static boolean isRole(Stereotype stereotype) {
        return stereotype.getTaggedValue(ROLE_URI) != null;
    }

    public static boolean isSystemRole(Stereotype stereotype) {
        return ArchitecturalTemplateAPI.isRole(stereotype) && stereotype.getName().endsWith(SYSTEM_ROLE_NAME_SUFFIX);
    }

    public static boolean isArchitecturalTemplate(Profile profile) {
        int count = 0;
        for (Stereotype s : profile.getStereotypes()) {
            if (!ArchitecturalTemplateAPI.isRole(s)) {
                return false;
            }
            if (!ArchitecturalTemplateAPI.isSystemRole(s)) continue;
            ++count;
        }
        return count == 1;
    }

    public static Stereotype getSystemRoleStereotype(Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        for (Stereotype s : profile.getStereotypes()) {
            if (!ArchitecturalTemplateAPI.isSystemRole(s)) continue;
            return s;
        }
        return null;
    }

    public static void applyArchitecturalTemplate(System system, AT architecturalTemplate) {
        if (architecturalTemplate.getRoles().size() == 0) {
            throw new RuntimeException("Architectural Template \"" + architecturalTemplate + "\" does not contain any roles");
        }
        ArchitecturalTemplateAPI.applyArchitecturalTemplate(system, ((Role)architecturalTemplate.getRoles().get(0)).getStereotype().getProfile());
    }

    public static void applyArchitecturalTemplate(System system, Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        Stereotype systemRoleStereotype = ArchitecturalTemplateAPI.getSystemRoleStereotype(profile);
        ProfileAPI.applyProfile((Resource)system.eResource(), (Profile)profile);
        StereotypeAPI.applyStereotype((EObject)system, (Stereotype)systemRoleStereotype);
        EPackage.Registry.INSTANCE.put((Object)profile.getNsURI(), (Object)profile);
    }

    public static void applyArchitecturalTemplate(ResourceEnvironment resourceenvironment, AT architecturalTemplate) {
        if (architecturalTemplate.getRoles().size() == 0) {
            throw new RuntimeException("Architectural Template \"" + architecturalTemplate + "\" does not contain any roles");
        }
        ArchitecturalTemplateAPI.applyArchitecturalTemplate(resourceenvironment, ((Role)architecturalTemplate.getRoles().get(0)).getStereotype().getProfile());
    }

    public static void applyArchitecturalTemplate(ResourceEnvironment resourceenvironment, Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        ProfileAPI.applyProfile((Resource)resourceenvironment.eResource(), (Profile)profile);
        EPackage.Registry.INSTANCE.put((Object)profile.getNsURI(), (Object)profile);
    }

    public static void unapplyArchitecturalTemplate(System system, AT architecturalTemplate) {
        if (architecturalTemplate.getRoles().size() == 0) {
            throw new RuntimeException("Architectural Template \"" + architecturalTemplate + "\" does not contain any roles");
        }
        ArchitecturalTemplateAPI.unapplyArchitecturalTemplate(system, ((Role)architecturalTemplate.getRoles().get(0)).getStereotype().getProfile());
    }

    public static void unapplyArchitecturalTemplate(System system, Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        ProfileAPI.unapplyProfile((Resource)system.eResource(), (Profile)profile);
    }

    public static void unapplyArchitecturalTemplate(ResourceEnvironment resourceenvironment, AT architecturalTemplate) {
        if (architecturalTemplate.getRoles().size() == 0) {
            throw new RuntimeException("Architectural Template \"" + architecturalTemplate + "\" does not contain any roles");
        }
        ArchitecturalTemplateAPI.unapplyArchitecturalTemplate(resourceenvironment, ((Role)architecturalTemplate.getRoles().get(0)).getStereotype().getProfile());
    }

    public static void unapplyArchitecturalTemplate(ResourceEnvironment resourceenvironment, Profile profile) {
        if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) {
            throw new RuntimeException("Profile \"" + profile + "\" is no Architectural Template");
        }
        ProfileAPI.unapplyProfile((Resource)resourceenvironment.eResource(), (Profile)profile);
    }

    public static void applyRole(EObject eObject, Role role) {
        StereotypeAPI.applyStereotype((EObject)eObject, (Stereotype)role.getStereotype());
    }

    public static void applyRole(EObject eObject, Stereotype stereotype) {
        if (!ArchitecturalTemplateAPI.isRole(stereotype)) {
            throw new RuntimeException("Stereotype \"" + stereotype + "\" is no role");
        }
        StereotypeAPI.applyStereotype((EObject)eObject, (Stereotype)stereotype);
    }

    public static void unapplyRole(EObject eObject, Role role) {
        StereotypeAPI.unapplyStereotype((EObject)eObject, (Stereotype)role.getStereotype());
    }

    public static void unapplyRole(EObject eObject, Stereotype stereotype) {
        if (!ArchitecturalTemplateAPI.isRole(stereotype)) {
            throw new RuntimeException("Stereotype \"" + stereotype + "\" is no role");
        }
        StereotypeAPI.unapplyStereotype((EObject)eObject, (Stereotype)stereotype);
    }

    public static Collection<AT> getAppliedArchitecturalTemplates(System system) {
        LinkedList<AT> appliedATs = new LinkedList<AT>();
        for (Profile appliedProfile : ProfileAPI.getAppliedProfiles((Resource)system.eResource())) {
            if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(appliedProfile)) continue;
            appliedATs.add(ArchitecturalTemplateAPI.getArchitecturalTemplate(appliedProfile));
        }
        return appliedATs;
    }

    public static Collection<StereotypeApplication> getArchitecturalTemplateApplications(System system) {
        LinkedList<StereotypeApplication> systemRoleStereotypeApplications = new LinkedList<StereotypeApplication>();
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications((EObject)system)) {
            if (!ArchitecturalTemplateAPI.isSystemRole(stereotypeApplication.getStereotype())) continue;
            systemRoleStereotypeApplications.add(stereotypeApplication);
        }
        return Collections.unmodifiableCollection(systemRoleStereotypeApplications);
    }

    public static Collection<AT> getATsFromSystem(System system) {
        LinkedList<AT> ATs = new LinkedList<AT>();
        if (system != null) {
            for (Stereotype stereotype : StereotypeAPI.getAppliedStereotypes((EObject)system)) {
                if (!ArchitecturalTemplateAPI.isSystemRole(stereotype)) continue;
                ATs.add(ArchitecturalTemplateAPI.getRole(stereotype).getAT());
            }
        }
        return Collections.unmodifiableCollection(ATs);
    }

    public static Collection<Role> getAppliedRoles(EObject eObject) {
        ArrayList<Role> appliedRoles = new ArrayList<Role>();
        for (Stereotype stereotype : StereotypeAPI.getAppliedStereotypes((EObject)eObject)) {
            if (!ArchitecturalTemplateAPI.isRole(stereotype)) continue;
            appliedRoles.add(ArchitecturalTemplateAPI.getRole(stereotype));
        }
        return appliedRoles;
    }

    public static Collection<StereotypeApplication> getRoleApplications(EObject eObject) {
        ArrayList<StereotypeApplication> roleStereotypeApplications = new ArrayList<StereotypeApplication>();
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications((EObject)eObject)) {
            if (!ArchitecturalTemplateAPI.isRole(stereotypeApplication.getStereotype())) continue;
            roleStereotypeApplications.add(stereotypeApplication);
        }
        return roleStereotypeApplications;
    }

    public static Collection<StereotypeApplication> getStereotypeApplicationsWithoutRoles(EObject eObject) {
        ArrayList<StereotypeApplication> roleStereotypeApplications = new ArrayList<StereotypeApplication>();
        for (StereotypeApplication stereotypeApplication : StereotypeAPI.getStereotypeApplications((EObject)eObject)) {
            if (ArchitecturalTemplateAPI.isRole(stereotypeApplication.getStereotype())) continue;
            roleStereotypeApplications.add(stereotypeApplication);
        }
        return roleStereotypeApplications;
    }

    public static final Collection<ProfileImport> getProfileImports(EObject eObject) {
        if (ProfileAPI.hasProfileApplication((Resource)eObject.eResource())) {
            return Collections.unmodifiableCollection(ProfileAPI.getProfileApplication((Resource)eObject.eResource()).getImportedProfiles());
        }
        return Collections.emptyList();
    }

    public static Collection<AT> getRegisteredArchitecturalTemplates() {
        ArrayList<AT> registeredATs = new ArrayList<AT>();
        for (Profile profile : IProfileRegistry.eINSTANCE.getRegisteredProfiles()) {
            if (!ArchitecturalTemplateAPI.isArchitecturalTemplate(profile)) continue;
            registeredATs.add(ArchitecturalTemplateAPI.getArchitecturalTemplate(profile));
        }
        return registeredATs;
    }

    public static Collection<Role> getApplicableRoles(EObject eObject) {
        ArrayList<Role> applicableRoles = new ArrayList<Role>();
        for (Stereotype applicableStereotype : StereotypeAPI.getApplicableStereotypes((EObject)eObject)) {
            if (!ArchitecturalTemplateAPI.isRole(applicableStereotype) || StereotypeAPI.isStereotypeApplied((EObject)eObject, (Stereotype)applicableStereotype)) continue;
            applicableRoles.add(ArchitecturalTemplateAPI.getRole(applicableStereotype));
        }
        return applicableRoles;
    }

    public static boolean hasRoles(EObject eObject) {
        return !ArchitecturalTemplateAPI.getAppliedRoles(eObject).isEmpty();
    }
}

