/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.jobs;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.analyzer.workflow.configurations.AbstractPCMWorkflowRunConfiguration;
import org.palladiosimulator.architecturaltemplates.jobs.config.ATExtensionJobConfiguration;
import org.palladiosimulator.architecturaltemplates.jobs.constants.ATPartitionConstants;

public class PrepareIsolatedBlackboardPartitionJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private static final Logger LOGGER = Logger.getLogger(PrepareIsolatedBlackboardPartitionJob.class);

    public PrepareIsolatedBlackboardPartitionJob(ATExtensionJobConfiguration configuration) {
        super(false);
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        super.execute(monitor);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Creating Template Model Partition");
        }
        PCMResourceSetPartition templatePartition = new PCMResourceSetPartition();
        ((MDSDBlackboard)this.getBlackboard()).addPartition(ATPartitionConstants.Partition.ISOLATED_TEMPLATE.getPartitionId(), (Object)templatePartition);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Initializing PCM EPackages");
        }
        templatePartition.initialiseResourceSetEPackages(AbstractPCMWorkflowRunConfiguration.PCM_EPACKAGES);
    }

    public String getName() {
        return "Prepare Template Blackboard Partitions";
    }
}

