/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.jobs;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJobConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.analyzer.workflow.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.architecturaltemplates.AT;
import org.palladiosimulator.architecturaltemplates.CompletionParameter;
import org.palladiosimulator.architecturaltemplates.IsolatedPCMTemplateCompletionParameter;
import org.palladiosimulator.architecturaltemplates.PCMBlackboardCompletionParameter;
import org.palladiosimulator.architecturaltemplates.PCMOutputCompletionParameter;
import org.palladiosimulator.architecturaltemplates.PCMTemplateCompletionParameter;
import org.palladiosimulator.architecturaltemplates.QVTOCompletion;
import org.palladiosimulator.architecturaltemplates.Role;
import org.palladiosimulator.architecturaltemplates.api.ArchitecturalTemplateAPI;
import org.palladiosimulator.architecturaltemplates.jobs.config.ATExtensionJobConfiguration;
import org.palladiosimulator.architecturaltemplates.jobs.constants.ATPartitionConstants;
import org.palladiosimulator.architecturaltemplates.util.ArchitecturaltemplatesSwitch;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.impl.MonitorRepositoryFactoryImpl;
import org.palladiosimulator.monitorrepository.util.MonitorRepositoryResourceImpl;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationFactory;
import org.palladiosimulator.pcm.allocation.util.AllocationResourceImpl;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;
import org.palladiosimulator.pcm.resourceenvironment.util.ResourceenvironmentResourceImpl;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcmmeasuringpoint.UsageScenarioMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.impl.PcmmeasuringpointFactoryImpl;
import org.palladiosimulator.pcmmeasuringpoint.util.PcmmeasuringpointResourceImpl;
import org.palladiosimulator.servicelevelobjective.ServiceLevelObjectiveRepository;
import org.palladiosimulator.servicelevelobjective.ServicelevelObjectiveFactory;
import org.palladiosimulator.servicelevelobjective.util.ServicelevelObjectiveResourceImpl;

public class RunATCompletionJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private static final String TEMPLATES_FOLDER = "templates";
    private static final String COMPLETIONS_FOLDER = "completions";
    private static final HashMap<String, Object> QVTO_OPTIONS = new HashMap();
    private static final String TRACESFOLDER = "traces";

    public RunATCompletionJob(ATExtensionJobConfiguration configuration) {
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        super.execute(monitor);
        for (AT architecturalTemplate : this.getATsFromSystem()) {
            for (QVTOCompletion completion : this.getCompletions(architecturalTemplate)) {
                this.executeCompletion(completion);
            }
        }
    }

    private void executeCompletion(QVTOCompletion completion) throws UserCanceledException {
        block3: {
            QVTOTransformationJob job = this.createQvtoTransformationJob(completion);
            try {
                job.execute((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JobFailedException e) {
                if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
                    this.logger.error((Object)("Failed to perform Architectural Template completion: " + e.getMessage()));
                }
                if (!this.logger.isEnabledFor((Priority)Level.INFO)) break block3;
                this.logger.info((Object)"Trying to continue Architectural Template completion even though an internal failure occured");
            }
        }
    }

    private QVTOTransformationJob createQvtoTransformationJob(QVTOCompletion completion) {
        QVTOTransformationJob job = new QVTOTransformationJob(this.createQvtoConfiguration(completion));
        job.setBlackboard((MDSDBlackboard)this.getBlackboard());
        return job;
    }

    private QVTOTransformationJobConfiguration createQvtoConfiguration(QVTOCompletion completion) {
        QVTOTransformationJobConfiguration qvtoConfig = new QVTOTransformationJobConfiguration();
        qvtoConfig.setInoutModels(this.getModelLocations(completion));
        qvtoConfig.setTraceFileURI(URI.createURI((String)TRACESFOLDER));
        qvtoConfig.setScriptFileURI(this.getRootURI((EObject)completion).appendSegment(COMPLETIONS_FOLDER).appendSegment(completion.getQvtoFileURI()));
        qvtoConfig.setOptions(QVTO_OPTIONS);
        return qvtoConfig;
    }

    private ModelLocation[] getModelLocations(QVTOCompletion completion) {
        ArrayList<ModelLocation> modelLocations = new ArrayList<ModelLocation>(completion.getParameters().size());
        for (CompletionParameter parameter : completion.getParameters()) {
            modelLocations.add(this.getModelLocation(parameter));
        }
        return modelLocations.toArray(new ModelLocation[modelLocations.size()]);
    }

    private URI getRootURI(EObject eObject) {
        return eObject.eResource().getURI().trimFragment().trimSegments(1);
    }

    private List<QVTOCompletion> getCompletions(AT architecturalTemplate) {
        LinkedList<QVTOCompletion> completions = new LinkedList<QVTOCompletion>();
        for (Role role : architecturalTemplate.getRoles()) {
            if (role.getCompletion() == null) continue;
            if (!(role.getCompletion() instanceof QVTOCompletion)) {
                throw new RuntimeException("This jobs assumes a QVTOCompletion");
            }
            completions.add((QVTOCompletion)role.getCompletion());
        }
        return Collections.unmodifiableList(completions);
    }

    private ModelLocation getModelLocation(CompletionParameter parameter) {
        final ResourceSetPartition pcmPartition = (ResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition(ATPartitionConstants.Partition.PCM.getPartitionId());
        final URI templateFolderURI = this.getRootURI((EObject)parameter).appendSegment(TEMPLATES_FOLDER);
        final URI systemModelFolderURI = this.getSystemModelFolderURI();
        return (ModelLocation)new ArchitecturaltemplatesSwitch<ModelLocation>(){

            public ModelLocation casePCMTemplateCompletionParameter(PCMTemplateCompletionParameter object) {
                String[] segments = URI.createURI((String)object.getTemplateFileURI()).segments();
                URI templateURI = templateFolderURI.appendSegments(segments);
                String lastSegment = templateURI.lastSegment();
                for (String fileName : ATPartitionConstants.PCM_FILES) {
                    if (!lastSegment.endsWith(fileName)) continue;
                    ResourceSetPartition resourceSetPartition = (ResourceSetPartition)((MDSDBlackboard)RunATCompletionJob.this.getBlackboard()).getPartition(ATPartitionConstants.Partition.PCM.getPartitionId());
                    resourceSetPartition.loadModel(templateURI);
                    resourceSetPartition.resolveAllProxies();
                    return new ModelLocation(ATPartitionConstants.Partition.PCM.getPartitionId(), templateURI);
                }
                throw new IllegalArgumentException("PCM Template Completion Parameter \"" + templateURI + "\" not found");
            }

            public ModelLocation caseIsolatedPCMTemplateCompletionParameter(IsolatedPCMTemplateCompletionParameter object) {
                String[] segments = URI.createURI((String)object.getTemplateFileURI()).segments();
                URI templateURI = templateFolderURI.appendSegments(segments);
                String lastSegment = templateURI.lastSegment();
                for (String fileName : ATPartitionConstants.PCM_FILES) {
                    if (!lastSegment.endsWith(fileName)) continue;
                    ResourceSetPartition resourceSetPartition = (ResourceSetPartition)((MDSDBlackboard)RunATCompletionJob.this.getBlackboard()).getPartition(ATPartitionConstants.Partition.ISOLATED_TEMPLATE.getPartitionId());
                    resourceSetPartition.loadModel(templateURI);
                    resourceSetPartition.resolveAllProxies();
                    return new ModelLocation(ATPartitionConstants.Partition.ISOLATED_TEMPLATE.getPartitionId(), templateURI);
                }
                throw new IllegalArgumentException("PCM Template Completion Parameter \"" + templateURI + "\" not found");
            }

            public ModelLocation casePCMBlackboardCompletionParameter(PCMBlackboardCompletionParameter object) {
                String parameterFileExtension = object.getFileExtension().getLiteral();
                ResourceSetPartition resourceSetPartition = (ResourceSetPartition)((MDSDBlackboard)RunATCompletionJob.this.getBlackboard()).getPartition(ATPartitionConstants.Partition.PCM.getPartitionId());
                for (Resource r : resourceSetPartition.getResourceSet().getResources()) {
                    URI modelURI = r.getURI();
                    String fileExtension = modelURI.fileExtension();
                    if (!fileExtension.equals(parameterFileExtension) || modelURI.toString().startsWith("pathmap://") || modelURI.toString().contains("PrimitiveTypes.repository")) continue;
                    return new ModelLocation(ATPartitionConstants.Partition.PCM.getPartitionId(), modelURI);
                }
                return null;
            }

            public ModelLocation casePCMOutputCompletionParameter(PCMOutputCompletionParameter object) {
                String parameterFileExtension = object.getFileExtension().getLiteral();
                PCMResourceSetPartition pcmRepositoryPartition = (PCMResourceSetPartition)pcmPartition;
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource outResource = resourceSet.createResource(URI.createURI((String)(systemModelFolderURI + "/GeneratedOut" + parameterFileExtension + "." + parameterFileExtension)));
                URI uri = outResource.getURI();
                if (outResource instanceof AllocationResourceImpl) {
                    try {
                        Allocation allocation = AllocationFactory.eINSTANCE.createAllocation();
                        outResource.getContents().add((Object)allocation);
                    }
                    catch (IndexOutOfBoundsException allocation) {}
                } else if (outResource instanceof ResourceenvironmentResourceImpl) {
                    try {
                        ResourceEnvironment resourceEnvironment = ResourceenvironmentFactory.eINSTANCE.createResourceEnvironment();
                        outResource.getContents().add((Object)resourceEnvironment);
                    }
                    catch (IndexOutOfBoundsException resourceEnvironment) {}
                } else if (outResource instanceof PcmmeasuringpointResourceImpl) {
                    UsageModel usageModel = null;
                    try {
                        usageModel = pcmRepositoryPartition.getUsageModel();
                        EList usageScenarios = usageModel.getUsageScenario_UsageModel();
                        UsageScenarioMeasuringPoint usageScenarioMeasuringPoint = PcmmeasuringpointFactoryImpl.eINSTANCE.createUsageScenarioMeasuringPoint();
                        usageScenarioMeasuringPoint.setUsageScenario((UsageScenario)usageScenarios.get(0));
                        outResource.getContents().add((Object)usageScenarioMeasuringPoint);
                    }
                    catch (IndexOutOfBoundsException usageScenarios) {}
                } else if (outResource instanceof ServicelevelObjectiveResourceImpl) {
                    ServicelevelObjectiveFactory sloFactory = ServicelevelObjectiveFactory.eINSTANCE;
                    ServiceLevelObjectiveRepository sloRepo = sloFactory.createServiceLevelObjectiveRepository();
                    outResource.getContents().add((Object)sloRepo);
                } else if (outResource instanceof MonitorRepositoryResourceImpl) {
                    MonitorRepositoryFactoryImpl monitorRepositoryFactory = (MonitorRepositoryFactoryImpl)MonitorRepositoryFactoryImpl.init();
                    MonitorRepository monitorRepository = monitorRepositoryFactory.createMonitorRepository();
                    outResource.getContents().add((Object)monitorRepository);
                }
                pcmPartition.setContents(uri, (List)outResource.getContents());
                pcmPartition.resolveAllProxies();
                return new ModelLocation(ATPartitionConstants.Partition.PCM.getPartitionId(), uri);
            }
        }.doSwitch((EObject)parameter);
    }

    private Collection<AT> getATsFromSystem() {
        PCMResourceSetPartition pcmRepositoryPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition(ATPartitionConstants.Partition.PCM.getPartitionId());
        System system = null;
        try {
            system = pcmRepositoryPartition.getSystem();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return ArchitecturalTemplateAPI.getATsFromSystem((System)system);
    }

    private URI getSystemModelFolderURI() {
        PCMResourceSetPartition pcmRepositoryPartition = (PCMResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition(ATPartitionConstants.Partition.PCM.getPartitionId());
        System system = null;
        try {
            system = pcmRepositoryPartition.getSystem();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return system.eResource().getURI().trimFragment().trimSegments(1);
    }
}

