/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.architecturaltemplates.jobs;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.OCL;
import org.modelversioning.emfprofile.Stereotype;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.architecturaltemplates.Constraint;
import org.palladiosimulator.architecturaltemplates.OCLConstraint;
import org.palladiosimulator.architecturaltemplates.Role;
import org.palladiosimulator.architecturaltemplates.jobs.config.ATExtensionJobConfiguration;
import org.palladiosimulator.architecturaltemplates.jobs.constants.ATPartitionConstants;
import org.palladiosimulator.architecturaltemplates.ocl.StereotypeEnvironmentFactory;
import org.palladiosimulator.commons.emfutils.EMFLoadHelper;
import org.palladiosimulator.mdsdprofiles.api.ProfileAPI;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentPackage;
import org.palladiosimulator.pcm.system.SystemPackage;

public class ValidateModelsJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    public ValidateModelsJob(ATExtensionJobConfiguration configuration) {
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        super.execute(monitor);
        this.logger.info((Object)"Validating AT Constraints.");
        List<ProfileApplication> profileApplications = this.getProfileApplications();
        for (ProfileApplication profileApplication : profileApplications) {
            EList stereotypeApplications = profileApplication.getStereotypeApplications();
            OCL ocl = OCL.newInstance((EnvironmentFactory)new StereotypeEnvironmentFactory((MDSDBlackboard)this.myBlackboard));
            OCL.Helper helper = ocl.createOCLHelper();
            for (StereotypeApplication stereotypeApplication : stereotypeApplications) {
                helper.setInstanceContext((Object)stereotypeApplication);
                EList<Constraint> constraints = this.getConstraintsFromStereotypeApplication(stereotypeApplication);
                org.eclipse.ocl.ecore.Constraint invariant = null;
                for (Constraint constraint : constraints) {
                    if (!(constraint instanceof OCLConstraint)) continue;
                    OCLConstraint oclConstraint = (OCLConstraint)constraint;
                    try {
                        invariant = (org.eclipse.ocl.ecore.Constraint)helper.createInvariant(oclConstraint.getConstraint());
                        OCL.Query constraintEvaluation = ocl.createQuery(invariant);
                        if (!constraintEvaluation.check((Object)stereotypeApplication)) {
                            this.logger.error((Object)("Constraint: " + oclConstraint.getEntityName() + " failed."));
                            continue;
                        }
                        this.logger.info((Object)("Constraint: " + oclConstraint.getEntityName() + " succeeded."));
                    }
                    catch (ParserException e) {
                        this.logger.error((Object)("Unable to parse expression " + oclConstraint.getEntityName() + ": " + e.getMessage()));
                    }
                }
            }
        }
    }

    private List<ProfileApplication> getProfileApplications() {
        LinkedList<ProfileApplication> profileApplications = new LinkedList<ProfileApplication>();
        this.addProfileApplicationIfPresent(profileApplications, SystemPackage.eINSTANCE.getSystem());
        this.addProfileApplicationIfPresent(profileApplications, ResourceenvironmentPackage.eINSTANCE.getResourceEnvironment());
        return Collections.unmodifiableList(profileApplications);
    }

    private void addProfileApplicationIfPresent(List<ProfileApplication> profileApplications, EClass eClass) {
        Resource resource;
        ResourceSetPartition partition = (ResourceSetPartition)((MDSDBlackboard)this.myBlackboard).getPartition(ATPartitionConstants.Partition.PCM.getPartitionId());
        if (partition.hasElement(eClass) && ProfileAPI.hasProfileApplication((Resource)(resource = ((EObject)partition.getElement(eClass).get(0)).eResource()))) {
            profileApplications.add(ProfileAPI.getProfileApplication((Resource)resource));
        }
    }

    private EList<Constraint> getConstraintsFromStereotypeApplication(StereotypeApplication stereotypeApplication) {
        Stereotype stereotype = stereotypeApplication.getStereotype();
        BasicEList constraints = new BasicEList();
        EStructuralFeature roleURI = stereotype.getTaggedValue("roleURI");
        if (roleURI != null) {
            EObject eObject = EMFLoadHelper.loadAndResolveEObject((String)roleURI.getDefaultValueLiteral());
            Role stereotypeRole = (Role)eObject;
            constraints = stereotypeRole.getConstraints();
            return stereotypeRole.getConstraints();
        }
        return constraints;
    }
}

