/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.commons.eclipseutils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public final class FileHelper {
    private FileHelper() {
    }

    public static File getFile(String path) {
        try {
            URL resolveURL = FileLocator.toFileURL((URL)new URL(path));
            java.net.URI resolvedURI = URIUtil.toURI((URL)resolveURL);
            return new File(resolvedURI);
        }
        catch (MalformedURLException e1) {
            throw new IllegalArgumentException("The path \"" + path + "\" is not a valid URL!");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load \"" + path + "\"!");
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The path \"" + path + "\" is not a valid URI!");
        }
    }

    public static File[] getFiles(File folder, final String fileExtension) {
        if (folder == null || !folder.exists() || !folder.isDirectory()) {
            throw new IllegalArgumentException("The folder \"" + folder + "\" is not accessible!");
        }
        return folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File directory, String fileName) {
                return fileName.endsWith(fileExtension);
            }
        });
    }

    public static File[] getFiles(String path, String fileExtension) {
        return FileHelper.getFiles(FileHelper.getFile(path), fileExtension);
    }

    public static URI[] getURIs(String path, String fileExtension) {
        File[] files = FileHelper.getFiles(path, fileExtension);
        URI[] uris = new URI[files.length];
        int i = 0;
        while (i < files.length) {
            uris[i] = URI.createURI((String)path).appendSegment(files[i].getName());
            ++i;
        }
        return uris;
    }

    public static File getPluginJarFile(String pluginID) {
        Bundle plugin = Platform.getBundle((String)pluginID);
        if (plugin == null) {
            throw new RuntimeException("Plug-In with ID \"" + pluginID + "\" cannot be resolved");
        }
        try {
            return FileLocator.getBundleFile((Bundle)plugin);
        }
        catch (IOException e) {
            throw new RuntimeException("No access for reading \"" + plugin + "\"");
        }
    }

    public static String getPluginJarFileName(String pluginID) {
        File file;
        Bundle plugin = Platform.getBundle((String)pluginID);
        if (plugin == null) {
            throw new RuntimeException("Plug-In with ID \"" + pluginID + "\" cannot be resolved");
        }
        try {
            file = FileLocator.getBundleFile((Bundle)plugin);
        }
        catch (IOException e) {
            throw new RuntimeException("No access for reading \"" + plugin + "\"");
        }
        if (!file.isDirectory()) {
            return file.getName();
        }
        StringBuffer fileName = new StringBuffer(200);
        fileName.append(plugin.getSymbolicName());
        fileName.append("_");
        fileName.append(plugin.getVersion().getMajor());
        fileName.append(".");
        fileName.append(plugin.getVersion().getMinor());
        fileName.append(".");
        fileName.append(plugin.getVersion().getMicro());
        fileName.append(".jar");
        return fileName.toString();
    }

    public static File packageToPluginJar(File directory, File targetJarFile) {
        if (!directory.isDirectory()) {
            throw new RuntimeException("Can only package directories to JARs!");
        }
        return null;
    }
}

