/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.commons.tabs.operations;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.swt.widgets.TableItem;
import org.palladiosimulator.editors.commons.tabs.generic.ObservableCellModifier;
import org.palladiosimulator.editors.commons.tabs.operations.OperationsEditorSection;
import org.palladiosimulator.editors.commons.tabs.operations.OperationsTabItemProvider;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.OperationSignature;

public class OperationsCellModifier
extends ObservableCellModifier {
    private List<String> columnNames = Arrays.asList(OperationsEditorSection.columnNames);
    private OperationSignature signature;
    protected TransactionalEditingDomain editingDomain = null;

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        return new OperationsTabItemProvider(null).getColumnText(element, this.columnNames.indexOf(property));
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.columnNames.indexOf(property);
        Assert.isNotNull((Object)element);
        TableItem item = (TableItem)element;
        this.signature = (OperationSignature)item.getData();
        this.editingDomain = TransactionUtil.getEditingDomain((EObject)this.signature);
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                if (!(value instanceof DataType)) break;
                this.setReturnType((DataType)value);
                break;
            }
            case 2: {
                String valueString = ((String)value).trim();
                this.setServiceName(valueString);
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private void setServiceName(String valueString) {
        final String value = valueString;
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                OperationsCellModifier.this.signature.setEntityName(value);
            }
        };
        if (!value.equals(this.signature.getEntityName())) {
            recCommand.setDescription("Edit Signature Property");
            recCommand.setLabel("Set name");
            this.editingDomain.getCommandStack().execute((Command)recCommand);
        }
    }

    private void setReturnType(DataType type) {
        final DataType dataType = type;
        RecordingCommand recCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                OperationsCellModifier.this.signature.setReturnType__OperationSignature(dataType);
            }
        };
        if (!dataType.equals(this.signature.getReturnType__OperationSignature())) {
            recCommand.setDescription("Edit Signature Property");
            recCommand.setLabel("Set return type");
            this.editingDomain.getCommandStack().execute((Command)recCommand);
            this.notifyObservers();
        }
    }
}

