/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.composedprovidingrequiringentity.commands;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.system.SystemFactory;

public class CreateSystemModelCommand
extends RecordingCommand {
    private final URI systemURI;
    private final ResourceSet resourceSet;
    private System createdSystem;

    public CreateSystemModelCommand(TransactionalEditingDomain domain, URI systemURI) {
        super(domain);
        this.systemURI = systemURI;
        this.resourceSet = domain.getResourceSet();
    }

    protected void doExecute() {
        System system = SystemFactory.eINSTANCE.createSystem();
        system.setEntityName(this.systemURI.segment(this.systemURI.segmentCount() - 1).split("\\.")[0]);
        Resource resource = this.resourceSet.createResource(this.systemURI);
        resource.getContents().add((Object)system);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.createdSystem = system;
    }

    public System getCreatedSystem() {
        return this.createdSystem;
    }
}

