/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.composedprovidingrequiringentity.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.dialect.command.CreateRepresentationCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.tools.api.command.semantic.AddSemanticResourceCommand;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelection;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.ui.business.internal.commands.ChangeViewpointSelectionCommand;
import org.eclipse.sirius.ui.tools.api.project.ModelingProjectManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.palladiosimulator.editors.sirius.composedprovidingrequiringentity.Activator;
import org.palladiosimulator.editors.sirius.composedprovidingrequiringentity.commands.CreateSystemModelCommand;
import org.palladiosimulator.pcm.system.System;

public class SystemCreationWizard
extends Wizard
implements INewWizard {
    private static final String CONFIRMATION_TITLE = "Conversion confirmation";
    private static final String CONFIRMATION_QUESTION = "The project needs to be a Modeling Project in order to continue. Do you want to convert it now?";
    private static final String WINDOW_TITLE = "Create System";
    private SystemModelCreationPage fileCreationPage;
    private RepresentationCreationPage representationCreationPage;

    public boolean performFinish() {
        final URI systemURI = this.fileCreationPage.getPlatformURI();
        final boolean createRepresentation = this.representationCreationPage.isRepresentationCreationEnabled();
        final String representationName = this.representationCreationPage.getRepresentationName();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                if (!systemURI.isPlatform()) {
                    return;
                }
                monitor.beginTask("Create System and representation:", 100);
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(systemURI.segment(1));
                if (!project.hasNature("org.eclipse.sirius.nature.modelingproject")) {
                    monitor.subTask("Converting to Modeling Project");
                    MessageDialog confirmationDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), SystemCreationWizard.CONFIRMATION_TITLE, null, SystemCreationWizard.CONFIRMATION_QUESTION, 5, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    if (confirmationDialog.open() != 0) {
                        return;
                    }
                    ModelingProjectManager.INSTANCE.convertToModelingProject(project, monitor);
                }
                monitor.subTask("Requesting Session");
                Session session = SessionManager.INSTANCE.getSession(URI.createPlatformResourceURI((String)("/" + systemURI.segment(1) + "/representations.aird"), (boolean)true), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                TransactionalEditingDomain domain = session.getTransactionalEditingDomain();
                monitor.worked(16);
                monitor.subTask("Creating System");
                CreateSystemModelCommand createSystemModelCommand = new CreateSystemModelCommand(domain, systemURI);
                domain.getCommandStack().execute((Command)createSystemModelCommand);
                monitor.worked(16);
                monitor.subTask("Adding as semantic resource");
                System createdSystem = createSystemModelCommand.getCreatedSystem();
                domain.getCommandStack().execute((Command)new AddSemanticResourceCommand(session, createdSystem.eResource().getURI(), (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                monitor.worked(16);
                if (createRepresentation) {
                    monitor.subTask("Selecting viewpoint");
                    Collection selectedViewpoints = session.getSelectedViewpoints(true);
                    if (!selectedViewpoints.contains(Activator.getDefault().SYSTEM_DESIGN)) {
                        domain.getCommandStack().execute((Command)new ChangeViewpointSelectionCommand(session, (ViewpointSelection.Callback)new ViewpointSelectionCallback(), Collections.singleton(Activator.getDefault().SYSTEM_DESIGN), Collections.emptySet(), (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                    }
                    monitor.worked(16);
                    monitor.subTask("Creating representation");
                    CreateRepresentationCommand createRepresentationCommand = new CreateRepresentationCommand(session, Activator.getDefault().COMPOSED_PROVIDING_REQUIRING_ENTITY_DIAGRAM, (EObject)createdSystem, representationName, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    domain.getCommandStack().execute((Command)createRepresentationCommand);
                    DRepresentation createdRepresentation = createRepresentationCommand.getCreatedRepresentation();
                    monitor.worked(16);
                    monitor.subTask("Opening representation");
                    DialectUIManager.INSTANCE.openEditor(session, createdRepresentation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    monitor.worked(16);
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (InterruptedException | InvocationTargetException e) {
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fileCreationPage = new SystemModelCreationPage(selection);
        this.representationCreationPage = new RepresentationCreationPage();
        this.setWindowTitle(WINDOW_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.fileCreationPage);
        this.addPage((IWizardPage)this.representationCreationPage);
    }

    private class RepresentationCreationPage
    extends WizardPage
    implements SelectionListener,
    ModifyListener {
        private static final String PAGE_NAME = "Model creation";
        private static final String ENABLE = "Create representation";
        private static final String REPRESENTATION_NAME = "Representation name:";
        private static final String TITLE = "Create representation";
        private static final String MESSAGE = "Select whether you want to create a representation";
        private static final String DEFAULT_REPRESENTATION_NAME = "new System Diagram";
        private Button enabledCheckbox;
        private Text representationNameInput;
        private Composite representationComposite;

        protected RepresentationCreationPage() {
            super(PAGE_NAME);
            this.setTitle("Create representation");
            this.setMessage(MESSAGE);
        }

        public boolean isPageComplete() {
            return !this.enabledCheckbox.getSelection() || this.representationNameInput.getText() != null && !this.representationNameInput.getText().equals("");
        }

        private void setEnabled(boolean enabled) {
            this.enabledCheckbox.setSelection(enabled);
            this.representationComposite.setEnabled(enabled);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            this.enabledCheckbox = new Button(composite, 32);
            this.enabledCheckbox.setLayoutData((Object)new GridData(32));
            this.enabledCheckbox.setText("Create representation");
            this.enabledCheckbox.addSelectionListener((SelectionListener)this);
            this.representationComposite = new Composite(composite, 2048);
            this.representationComposite.setEnabled(false);
            this.representationComposite.setLayoutData((Object)new GridData(768));
            GridLayout representationLayout = new GridLayout();
            representationLayout.marginHeight = 10;
            representationLayout.marginWidth = 10;
            this.representationComposite.setLayout((Layout)representationLayout);
            Label label = new Label(this.representationComposite, 0);
            label.setText(REPRESENTATION_NAME);
            label.setLayoutData((Object)new GridData(256));
            this.representationNameInput = new Text(this.representationComposite, 2052);
            this.representationNameInput.setLayoutData((Object)new GridData(768));
            this.representationNameInput.addModifyListener((ModifyListener)this);
            this.representationNameInput.setText(DEFAULT_REPRESENTATION_NAME);
            this.setEnabled(true);
            this.setControl((Control)composite);
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.enabledCheckbox.equals(e.getSource())) {
                this.setEnabled(((Button)e.getSource()).getSelection());
            }
            this.getWizard().getContainer().updateButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public String getRepresentationName() {
            return this.representationNameInput.getText();
        }

        public boolean isRepresentationCreationEnabled() {
            return this.enabledCheckbox.getSelection();
        }

        public void modifyText(ModifyEvent e) {
            this.getWizard().getContainer().updateButtons();
        }
    }

    private class SystemModelCreationPage
    extends WizardNewFileCreationPage {
        private static final String PAGE_NAME = "Create System";
        private static final String INITIAL_FILE_NAME = "newSystem";
        private static final String FILE_EXTENSION = "system";
        private static final String MESSAGE = "Choose a file name and location";

        public SystemModelCreationPage(IStructuredSelection selection) {
            super("Create System", selection);
            this.setFileName(INITIAL_FILE_NAME);
            this.setMessage(MESSAGE);
            this.setFileExtension(FILE_EXTENSION);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            this.setMessage(MESSAGE);
            this.setTitle("Create System");
        }

        protected boolean validatePage() {
            boolean valid = super.validatePage();
            if (valid) {
                this.setMessage(MESSAGE);
            }
            return valid;
        }

        public URI getPlatformURI() {
            return URI.createPlatformResourceURI((String)this.getContainerFullPath().append(this.getFileName()).toOSString(), (boolean)true);
        }
    }
}

