/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.editors.sirius.resourceenvironment.commands;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourceenvironment.ResourceenvironmentFactory;

public class CreateResourceenvironmentCommand
extends RecordingCommand {
    private final URI resourceURI;
    private final ResourceSet resourceSet;
    private ResourceEnvironment createdResourceEnvironment;

    public CreateResourceenvironmentCommand(TransactionalEditingDomain domain, URI resourceURI) {
        super(domain);
        this.resourceURI = resourceURI;
        this.resourceSet = domain.getResourceSet();
    }

    protected void doExecute() {
        ResourceEnvironment resourceEnvironment = ResourceenvironmentFactory.eINSTANCE.createResourceEnvironment();
        resourceEnvironment.setEntityName(this.resourceURI.segment(this.resourceURI.segmentCount() - 1).split("\\.")[0]);
        Resource resource = this.resourceSet.createResource(this.resourceURI);
        resource.getContents().add((Object)resourceEnvironment);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.createdResourceEnvironment = resourceEnvironment;
    }

    public ResourceEnvironment getcreatedResourceEnvironment() {
        return this.createdResourceEnvironment;
    }
}

