/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.palladiosimulator.edp2.models.ExperimentData.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ChildCreationExtenderManager;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.palladiosimulator.edp2.models.ExperimentData.ExperimentDataPackage;
import org.palladiosimulator.edp2.models.ExperimentData.util.ExperimentDataAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 *
 * @generated
 */
public class ExperimentDataItemProviderAdapterFactory extends ExperimentDataAdapterFactory implements
        ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This helps manage the child creation extenders. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(
            EDP2EditPlugin.INSTANCE, ExperimentDataPackage.eNS_URI);

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public ExperimentDataItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected MeasurementRangeItemProvider measurementRangeItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.MeasurementRange}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMeasurementRangeAdapter() {
        if (this.measurementRangeItemProvider == null)
        {
            this.measurementRangeItemProvider = new MeasurementRangeItemProvider(this);
        }

        return this.measurementRangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link java.util.Map.Entry} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected EStringtoEObjectMapEntryItemProvider eStringtoEObjectMapEntryItemProvider;

    /**
     * This creates an adapter for a {@link java.util.Map.Entry}. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createEStringtoEObjectMapEntryAdapter() {
        if (this.eStringtoEObjectMapEntryItemProvider == null)
        {
            this.eStringtoEObjectMapEntryItemProvider = new EStringtoEObjectMapEntryItemProvider(this);
        }

        return this.eStringtoEObjectMapEntryItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected RawMeasurementsItemProvider rawMeasurementsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.RawMeasurements}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createRawMeasurementsAdapter() {
        if (this.rawMeasurementsItemProvider == null)
        {
            this.rawMeasurementsItemProvider = new RawMeasurementsItemProvider(this);
        }

        return this.rawMeasurementsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalNominalStatistics}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NumericalNominalStatisticsItemProvider numericalNominalStatisticsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalNominalStatistics}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNumericalNominalStatisticsAdapter() {
        if (this.numericalNominalStatisticsItemProvider == null)
        {
            this.numericalNominalStatisticsItemProvider = new NumericalNominalStatisticsItemProvider(this);
        }

        return this.numericalNominalStatisticsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalMassDistribution} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NumericalMassDistributionItemProvider numericalMassDistributionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalMassDistribution}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNumericalMassDistributionAdapter() {
        if (this.numericalMassDistributionItemProvider == null)
        {
            this.numericalMassDistributionItemProvider = new NumericalMassDistributionItemProvider(this);
        }

        return this.numericalMassDistributionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.FixedWidthAggregatedMeasurements}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FixedWidthAggregatedMeasurementsItemProvider fixedWidthAggregatedMeasurementsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.FixedWidthAggregatedMeasurements}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFixedWidthAggregatedMeasurementsAdapter() {
        if (this.fixedWidthAggregatedMeasurementsItemProvider == null)
        {
            this.fixedWidthAggregatedMeasurementsItemProvider = new FixedWidthAggregatedMeasurementsItemProvider(this);
        }

        return this.fixedWidthAggregatedMeasurementsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.FixedIntervals} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FixedIntervalsItemProvider fixedIntervalsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.FixedIntervals}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createFixedIntervalsAdapter() {
        if (this.fixedIntervalsItemProvider == null)
        {
            this.fixedIntervalsItemProvider = new FixedIntervalsItemProvider(this);
        }

        return this.fixedIntervalsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.TextualNominalStatistics} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected TextualNominalStatisticsItemProvider textualNominalStatisticsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.TextualNominalStatistics}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createTextualNominalStatisticsAdapter() {
        if (this.textualNominalStatisticsItemProvider == null)
        {
            this.textualNominalStatisticsItemProvider = new TextualNominalStatisticsItemProvider(this);
        }

        return this.textualNominalStatisticsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.TextualMassDistribution} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected TextualMassDistributionItemProvider textualMassDistributionItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.TextualMassDistribution}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createTextualMassDistributionAdapter() {
        if (this.textualMassDistributionItemProvider == null)
        {
            this.textualMassDistributionItemProvider = new TextualMassDistributionItemProvider(this);
        }

        return this.textualMassDistributionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExperimentGroupItemProvider experimentGroupItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroup}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExperimentGroupAdapter() {
        if (this.experimentGroupItemProvider == null)
        {
            this.experimentGroupItemProvider = new ExperimentGroupItemProvider(this);
        }

        return this.experimentGroupItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExperimentSettingItemProvider experimentSettingItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.ExperimentSetting}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExperimentSettingAdapter() {
        if (this.experimentSettingItemProvider == null)
        {
            this.experimentSettingItemProvider = new ExperimentSettingItemProvider(this);
        }

        return this.experimentSettingItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExperimentRunItemProvider experimentRunItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.ExperimentRun}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExperimentRunAdapter() {
        if (this.experimentRunItemProvider == null)
        {
            this.experimentRunItemProvider = new ExperimentRunItemProvider(this);
        }

        return this.experimentRunItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.Measurement} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected MeasurementItemProvider measurementItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.Measurement}. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMeasurementAdapter() {
        if (this.measurementItemProvider == null)
        {
            this.measurementItemProvider = new MeasurementItemProvider(this);
        }

        return this.measurementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.MeasuringType} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected MeasuringTypeItemProvider measuringTypeItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.MeasuringType}. <!-- begin-user-doc
     * --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createMeasuringTypeAdapter() {
        if (this.measuringTypeItemProvider == null)
        {
            this.measuringTypeItemProvider = new MeasuringTypeItemProvider(this);
        }

        return this.measuringTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.AggregationStatistics} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected AggregationStatisticsItemProvider aggregationStatisticsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.AggregationStatistics}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createAggregationStatisticsAdapter() {
        if (this.aggregationStatisticsItemProvider == null)
        {
            this.aggregationStatisticsItemProvider = new AggregationStatisticsItemProvider(this);
        }

        return this.aggregationStatisticsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.DoubleBinaryMeasurements} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DoubleBinaryMeasurementsItemProvider doubleBinaryMeasurementsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.DoubleBinaryMeasurements}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDoubleBinaryMeasurementsAdapter() {
        if (this.doubleBinaryMeasurementsItemProvider == null)
        {
            this.doubleBinaryMeasurementsItemProvider = new DoubleBinaryMeasurementsItemProvider(this);
        }

        return this.doubleBinaryMeasurementsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalIntervalStatistics}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NumericalIntervalStatisticsItemProvider numericalIntervalStatisticsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalIntervalStatistics}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNumericalIntervalStatisticsAdapter() {
        if (this.numericalIntervalStatisticsItemProvider == null)
        {
            this.numericalIntervalStatisticsItemProvider = new NumericalIntervalStatisticsItemProvider(this);
        }

        return this.numericalIntervalStatisticsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalOrdinalStatistics}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NumericalOrdinalStatisticsItemProvider numericalOrdinalStatisticsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalOrdinalStatistics}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNumericalOrdinalStatisticsAdapter() {
        if (this.numericalOrdinalStatisticsItemProvider == null)
        {
            this.numericalOrdinalStatisticsItemProvider = new NumericalOrdinalStatisticsItemProvider(this);
        }

        return this.numericalOrdinalStatisticsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalPercentile} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NumericalPercentileItemProvider numericalPercentileItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalPercentile}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNumericalPercentileAdapter() {
        if (this.numericalPercentileItemProvider == null)
        {
            this.numericalPercentileItemProvider = new NumericalPercentileItemProvider(this);
        }

        return this.numericalPercentileItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.JSXmlMeasurements} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected JSXmlMeasurementsItemProvider jsXmlMeasurementsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.JSXmlMeasurements}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createJSXmlMeasurementsAdapter() {
        if (this.jsXmlMeasurementsItemProvider == null)
        {
            this.jsXmlMeasurementsItemProvider = new JSXmlMeasurementsItemProvider(this);
        }

        return this.jsXmlMeasurementsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.LongBinaryMeasurements} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected LongBinaryMeasurementsItemProvider longBinaryMeasurementsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.LongBinaryMeasurements}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createLongBinaryMeasurementsAdapter() {
        if (this.longBinaryMeasurementsItemProvider == null)
        {
            this.longBinaryMeasurementsItemProvider = new LongBinaryMeasurementsItemProvider(this);
        }

        return this.longBinaryMeasurementsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.IdentifierBasedMeasurements}
     * instances. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IdentifierBasedMeasurementsItemProvider identifierBasedMeasurementsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.IdentifierBasedMeasurements}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createIdentifierBasedMeasurementsAdapter() {
        if (this.identifierBasedMeasurementsItemProvider == null)
        {
            this.identifierBasedMeasurementsItemProvider = new IdentifierBasedMeasurementsItemProvider(this);
        }

        return this.identifierBasedMeasurementsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalRatioStatistics} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected NumericalRatioStatisticsItemProvider numericalRatioStatisticsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.NumericalRatioStatistics}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createNumericalRatioStatisticsAdapter() {
        if (this.numericalRatioStatisticsItemProvider == null)
        {
            this.numericalRatioStatisticsItemProvider = new NumericalRatioStatisticsItemProvider(this);
        }

        return this.numericalRatioStatisticsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.TextualOrdinalStatistics} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected TextualOrdinalStatisticsItemProvider textualOrdinalStatisticsItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.TextualOrdinalStatistics}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createTextualOrdinalStatisticsAdapter() {
        if (this.textualOrdinalStatisticsItemProvider == null)
        {
            this.textualOrdinalStatisticsItemProvider = new TextualOrdinalStatisticsItemProvider(this);
        }

        return this.textualOrdinalStatisticsItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroupRun} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ExperimentGroupRunItemProvider experimentGroupRunItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.edp2.models.ExperimentData.ExperimentGroupRun}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createExperimentGroupRunAdapter() {
        if (this.experimentGroupRunItemProvider == null)
        {
            this.experimentGroupRunItemProvider = new ExperimentGroupRunItemProvider(this);
        }

        return this.experimentGroupRunItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type))
        {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter)))
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public List<IChildCreationExtender> getChildCreationExtenders() {
        return this.childCreationExtenderManager.getChildCreationExtenders();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Collection<?> getNewChildDescriptors(final Object object, final EditingDomain editingDomain) {
        return this.childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public ResourceLocator getResourceLocator() {
        return this.childCreationExtenderManager;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null)
        {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     *
     * @generated
     */
    @Override
    public void dispose() {
        if (this.measurementRangeItemProvider != null) {
            this.measurementRangeItemProvider.dispose();
        }
        if (this.eStringtoEObjectMapEntryItemProvider != null) {
            this.eStringtoEObjectMapEntryItemProvider.dispose();
        }
        if (this.rawMeasurementsItemProvider != null) {
            this.rawMeasurementsItemProvider.dispose();
        }
        if (this.numericalNominalStatisticsItemProvider != null) {
            this.numericalNominalStatisticsItemProvider.dispose();
        }
        if (this.numericalMassDistributionItemProvider != null) {
            this.numericalMassDistributionItemProvider.dispose();
        }
        if (this.fixedWidthAggregatedMeasurementsItemProvider != null) {
            this.fixedWidthAggregatedMeasurementsItemProvider.dispose();
        }
        if (this.fixedIntervalsItemProvider != null) {
            this.fixedIntervalsItemProvider.dispose();
        }
        if (this.textualNominalStatisticsItemProvider != null) {
            this.textualNominalStatisticsItemProvider.dispose();
        }
        if (this.textualMassDistributionItemProvider != null) {
            this.textualMassDistributionItemProvider.dispose();
        }
        if (this.experimentGroupItemProvider != null) {
            this.experimentGroupItemProvider.dispose();
        }
        if (this.experimentSettingItemProvider != null) {
            this.experimentSettingItemProvider.dispose();
        }
        if (this.experimentRunItemProvider != null) {
            this.experimentRunItemProvider.dispose();
        }
        if (this.measurementItemProvider != null) {
            this.measurementItemProvider.dispose();
        }
        if (this.measuringTypeItemProvider != null) {
            this.measuringTypeItemProvider.dispose();
        }
        if (this.aggregationStatisticsItemProvider != null) {
            this.aggregationStatisticsItemProvider.dispose();
        }
        if (this.doubleBinaryMeasurementsItemProvider != null) {
            this.doubleBinaryMeasurementsItemProvider.dispose();
        }
        if (this.numericalIntervalStatisticsItemProvider != null) {
            this.numericalIntervalStatisticsItemProvider.dispose();
        }
        if (this.numericalOrdinalStatisticsItemProvider != null) {
            this.numericalOrdinalStatisticsItemProvider.dispose();
        }
        if (this.numericalPercentileItemProvider != null) {
            this.numericalPercentileItemProvider.dispose();
        }
        if (this.jsXmlMeasurementsItemProvider != null) {
            this.jsXmlMeasurementsItemProvider.dispose();
        }
        if (this.longBinaryMeasurementsItemProvider != null) {
            this.longBinaryMeasurementsItemProvider.dispose();
        }
        if (this.identifierBasedMeasurementsItemProvider != null) {
            this.identifierBasedMeasurementsItemProvider.dispose();
        }
        if (this.numericalRatioStatisticsItemProvider != null) {
            this.numericalRatioStatisticsItemProvider.dispose();
        }
        if (this.textualOrdinalStatisticsItemProvider != null) {
            this.textualOrdinalStatisticsItemProvider.dispose();
        }
        if (this.experimentGroupRunItemProvider != null) {
            this.experimentGroupRunItemProvider.dispose();
        }
    }

}
