/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.repository.local.dao;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.quantity.Dimensionless;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.edp2.dao.BinaryMeasurementsDao;
import org.palladiosimulator.edp2.dao.MeasurementsDaoFactory;
import org.palladiosimulator.edp2.dao.MeasurementsDaoRegistry;
import org.palladiosimulator.edp2.dao.exception.DataNotAccessibleException;
import org.palladiosimulator.edp2.dao.impl.MeasurementsDaoFactoryImpl;
import org.palladiosimulator.edp2.dao.impl.MeasurementsDaoRegistryImpl;
import org.palladiosimulator.edp2.dao.jscience.JScienceXmlMeasurementsDao;
import org.palladiosimulator.edp2.repository.local.dao.FileBinaryMeasurementsDaoImpl;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.BackgroundMemoryListImpl;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer.DoubleSerializer;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer.IdentifierSerializer;
import org.palladiosimulator.edp2.repository.local.dao.internal.backgroundlist.serializer.LongSerializer;
import org.palladiosimulator.metricspec.Identifier;
import org.palladiosimulator.metricspec.TextualBaseMetricDescription;

public class LocalDirectoryMeasurementsDaoFactory
extends MeasurementsDaoFactoryImpl {
    private static final Logger LOGGER = Logger.getLogger(LocalDirectoryMeasurementsDaoFactory.class.getCanonicalName());
    private static final String FILE_SUFFIX = "edp2bin";
    private static final ResourceSet emfResourceSet = new ResourceSetImpl();
    private final MeasurementsDaoRegistry daoRegistry;
    private static ConcurrentMap<URI, MeasurementsDaoFactory> existingFileDaoFactories = new ConcurrentHashMap<URI, MeasurementsDaoFactory>();
    private URI storageDirectory = null;

    public LocalDirectoryMeasurementsDaoFactory(URI storageDirectory) {
        URI trimmedURI;
        URI uRI = trimmedURI = storageDirectory.hasTrailingPathSeparator() ? storageDirectory.trimSegments(1) : storageDirectory;
        if (existingFileDaoFactories.containsKey(trimmedURI)) {
            LOGGER.log(Level.SEVERE, "There is already an existing FileDaoFactory instance for " + trimmedURI + ".");
            throw new IllegalArgumentException();
        }
        existingFileDaoFactories.put(trimmedURI, (MeasurementsDaoFactory)this);
        this.storageDirectory = trimmedURI;
        this.daoRegistry = new MeasurementsDaoRegistryImpl();
    }

    private String getAbsolutePathToUuidFile(String uuid, String suffix) {
        URI resultURI = this.storageDirectory.appendSegment(String.valueOf(uuid) + "." + suffix);
        try {
            return FileLocator.toFileURL((URL)new URL(resultURI.toString())).getFile();
        }
        catch (IOException e) {
            throw new RuntimeException("URL not valid for EDP2 repository");
        }
    }

    public JScienceXmlMeasurementsDao<?, Quantity> createJScienceXmlMeasurementsDao(String uuid) {
        super.createJScienceXmlMeasurementsDao(uuid);
        LOGGER.log(Level.SEVERE, "Unsupported Operation: JScience Measurements.");
        throw new UnsupportedOperationException();
    }

    public <Q extends Quantity> BinaryMeasurementsDao<Double, Q> createDoubleMeasurementsDao(String uuid) {
        super.createDoubleMeasurementsDao(uuid);
        FileBinaryMeasurementsDaoImpl fbmDao = new FileBinaryMeasurementsDaoImpl();
        fbmDao.setBinaryRepresentation(BackgroundMemoryListImpl.BinaryRepresentation.DOUBLE);
        fbmDao.setResourceFile(new File(this.getAbsolutePathToUuidFile(uuid, FILE_SUFFIX)));
        fbmDao.setSerializer(new DoubleSerializer());
        this.daoRegistry.register(fbmDao, uuid);
        return fbmDao;
    }

    public <Q extends Quantity> BinaryMeasurementsDao<Long, Q> createLongMeasurementsDao(String uuid) {
        super.createLongMeasurementsDao(uuid);
        FileBinaryMeasurementsDaoImpl fbmDao = new FileBinaryMeasurementsDaoImpl();
        fbmDao.setBinaryRepresentation(BackgroundMemoryListImpl.BinaryRepresentation.LONG);
        fbmDao.setResourceFile(new File(this.getAbsolutePathToUuidFile(uuid, FILE_SUFFIX)));
        fbmDao.setSerializer(new LongSerializer());
        this.daoRegistry.register(fbmDao, uuid);
        return fbmDao;
    }

    public BinaryMeasurementsDao<Identifier, Dimensionless> createNominalMeasurementsDao(String uuid, TextualBaseMetricDescription metric) {
        super.createNominalMeasurementsDao(uuid, metric);
        FileBinaryMeasurementsDaoImpl<Identifier, Dimensionless> fbmDao = new FileBinaryMeasurementsDaoImpl<Identifier, Dimensionless>();
        fbmDao.setBinaryRepresentation(BackgroundMemoryListImpl.BinaryRepresentation.IDENTIFIER);
        fbmDao.setResourceFile(new File(this.getAbsolutePathToUuidFile(uuid, FILE_SUFFIX)));
        fbmDao.setSerializer(new IdentifierSerializer(metric));
        this.daoRegistry.register(fbmDao, uuid);
        return fbmDao;
    }

    public MeasurementsDaoRegistry getDaoRegistry() {
        return this.daoRegistry;
    }

    public void setActive(boolean newValue) {
        super.setActive(newValue);
        Set registeredUuids = this.daoRegistry.getRegisteredUuids();
        for (String uuid : registeredUuids) {
            try {
                if (!this.isActive()) {
                    if (!this.daoRegistry.getMeasurementsDao(uuid).isDeleted() && this.daoRegistry.getMeasurementsDao(uuid).isOpen()) {
                        this.daoRegistry.getMeasurementsDao(uuid).close();
                    }
                    this.daoRegistry.deregister(uuid);
                    continue;
                }
                this.daoRegistry.getMeasurementsDao(uuid).open();
            }
            catch (DataNotAccessibleException e) {
                LOGGER.log(Level.SEVERE, "Could not close DAO.", e);
                throw new RuntimeException(e);
            }
        }
    }

    public static MeasurementsDaoFactory getRegisteredFactory(URI directory) {
        return (MeasurementsDaoFactory)existingFileDaoFactories.get(directory);
    }

    public <Q extends Quantity> BinaryMeasurementsDao<Double, Q> createDoubleMeasurementsDao(String uuid, Unit<Q> storageUnit) {
        BinaryMeasurementsDao<Double, Q> bmd = this.createDoubleMeasurementsDao(uuid);
        bmd.setUnit(storageUnit);
        return bmd;
    }

    public <Q extends Quantity> BinaryMeasurementsDao<Long, Q> createLongMeasurementsDao(String uuid, Unit<Q> storageUnit) {
        BinaryMeasurementsDao<Long, Q> bmd = this.createLongMeasurementsDao(uuid);
        bmd.setUnit(storageUnit);
        return bmd;
    }

    public BinaryMeasurementsDao<Identifier, Dimensionless> createNominalMeasurementsDao(String uuid, TextualBaseMetricDescription metric, Unit<Dimensionless> storageUnit) {
        BinaryMeasurementsDao<Identifier, Dimensionless> bmd = this.createNominalMeasurementsDao(uuid, metric);
        bmd.setUnit(storageUnit);
        return bmd;
    }
}

