/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.jfreechart.editor;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.w3c.dom.Document;

public class CustomJFreeChartComposite
extends ChartComposite {
    private File selectFileDialog(String filter) {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 8192);
        dialog.setFilterExtensions(new String[]{filter});
        dialog.setText("Enter the file name");
        String result = dialog.open();
        if (result != null) {
            String filename = String.valueOf(dialog.getFilterPath()) + File.separator + dialog.getFileName();
            return new File(filename);
        }
        return null;
    }

    public CustomJFreeChartComposite(Composite parent, int style) {
        super(parent, style);
    }

    protected Menu createPopupMenu(boolean arg0, boolean arg1, boolean arg2, boolean arg3) {
        Menu parentMenu = super.createPopupMenu(arg0, arg1, arg2, arg3);
        MenuManager menu_manager = new MenuManager("Additional Functions");
        this.initializeContextMenu(menu_manager);
        menu_manager.fill(parentMenu, 0);
        return parentMenu;
    }

    protected void initializeContextMenu(MenuManager menu_manager) {
        menu_manager.add((IAction)new SaveImageAsAction());
        menu_manager.add((IAction)new SaveSVGAsAction());
        menu_manager.add((IAction)new ExportCsvAsAction());
    }

    private class ExportCsvAsAction
    extends Action {
        private static final String ONE_LINE_FORMAT = "%s,%s";

        public ExportCsvAsAction() {
            this.setText("Export Data as CSV...");
        }

        public void run() {
            File f = CustomJFreeChartComposite.this.selectFileDialog("*.csv");
            if (f != null) {
                XYPlot plot = CustomJFreeChartComposite.this.getChart().getXYPlot();
                XYDataset dataset = plot.getDataset();
                StringBuilder content = new StringBuilder(String.format(ONE_LINE_FORMAT, plot.getDomainAxis().getLabel(), plot.getRangeAxis().getLabel()));
                int seriesNumber = dataset.getSeriesCount() - 1;
                int i = 0;
                while (i < dataset.getItemCount(seriesNumber)) {
                    content.append(System.lineSeparator());
                    double x = dataset.getXValue(seriesNumber, i);
                    double y = dataset.getYValue(seriesNumber, i);
                    content.append(String.format(ONE_LINE_FORMAT, x, y));
                    ++i;
                }
                try {
                    Files.write(Paths.get(f.getPath(), new String[0]), content.toString().getBytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    StringBuilder errorMessage = new StringBuilder("An error occurred during CSV export: " + System.lineSeparator());
                    errorMessage.append(e.getMessage());
                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Error", (String)errorMessage.toString());
                }
            }
        }
    }

    private class SaveImageAsAction
    extends Action {
        public SaveImageAsAction() {
            this.setText("Save Chart as PNG...");
        }

        public void run() {
            File f = CustomJFreeChartComposite.this.selectFileDialog("*.png");
            if (f != null) {
                try {
                    ChartUtilities.saveChartAsPNG((File)f, (JFreeChart)CustomJFreeChartComposite.this.getChart(), (int)CustomJFreeChartComposite.this.getBounds().width, (int)CustomJFreeChartComposite.this.getBounds().height);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class SaveSVGAsAction
    extends Action {
        public SaveSVGAsAction() {
            this.setText("Save Chart as SVG...");
        }

        public void run() {
            File f = CustomJFreeChartComposite.this.selectFileDialog("*.svg");
            if (f != null) {
                try {
                    JFreeChart chart = CustomJFreeChartComposite.this.getChart();
                    GenericDOMImplementation domI = new GenericDOMImplementation();
                    Document doc = domI.createDocument(null, "svg", null);
                    SVGGraphics2D svgRenderer = new SVGGraphics2D(doc);
                    Paint p = chart.getBackgroundPaint();
                    chart.setBackgroundPaint((Paint)new Color(0, 0, 0, 0));
                    chart.draw((Graphics2D)svgRenderer, (Rectangle2D)new Rectangle(0, 0, 640, 480));
                    chart.setBackgroundPaint(p);
                    OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
                    svgRenderer.stream((Writer)out, true);
                    ((Writer)out).close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

