/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.jfreechart.input;

import java.awt.Color;
import java.awt.Paint;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.jfree.chart.ChartColor;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.data.general.AbstractDataset;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.edp2.visualization.AbstractVisualizationInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationConfiguration;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationInputFactory;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamConfiguration;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.util.DefaultUnitSwitch;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;

public abstract class JFreeChartVisualizationInput
extends AbstractVisualizationInput<JFreeChartVisualizationSingleDatastreamInput> {
    private AbstractDataset currentCachedDataset;

    public JFreeChartVisualizationSingleDatastreamInput createNewInput(IDataSource source) {
        return new JFreeChartVisualizationSingleDatastreamInput(source);
    }

    public JFreeChartVisualizationInput() {
    }

    public JFreeChartVisualizationInput(JFreeChartVisualizationSingleDatastreamInput firstInput) {
        this();
        this.addInput(firstInput);
    }

    public boolean exists() {
        return !this.inputs.isEmpty();
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        return "JFreeChart EDP2 Editor";
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public String getToolTipText() {
        return this.getName();
    }

    public boolean isEmpty() {
        return this.getInputs().size() == 0;
    }

    public void saveState(IMemento memento) {
        JFreeChartVisualizationInputFactory.saveState(memento, this);
    }

    public final JFreeChart createChart() {
        JFreeChartVisualizationConfiguration configuration;
        Plot plot;
        if (this.currentCachedDataset == null) {
            this.reloadData();
        }
        if ((plot = this.generatePlot((PropertyConfigurable)(configuration = (JFreeChartVisualizationConfiguration)this.getConfiguration()), this.currentCachedDataset)) != null) {
            return new JFreeChart(configuration.isShowTitle() ? configuration.getTitle() : null, JFreeChart.DEFAULT_TITLE_FONT, plot, configuration.isShowLegend());
        }
        return null;
    }

    public void reloadData() {
        this.currentCachedDataset = this.generateDataset();
    }

    protected String getAxisDefaultLabel(int pos) {
        BaseMetricDescription metric = MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)((JFreeChartVisualizationSingleDatastreamInput)((Object)this.getInputs().get(0))).getDataSource().getDataStream().getMetricDesciption())[pos];
        return String.valueOf(metric.getName()) + " [" + (String)new DefaultUnitSwitch((MetricDescription)metric).doSwitch((EObject)metric) + "]";
    }

    protected void configureSeriesColors(AbstractRenderer renderer) {
        int i = 0;
        while (i < this.getInputs().size()) {
            JFreeChartVisualizationSingleDatastreamConfiguration config = (JFreeChartVisualizationSingleDatastreamConfiguration)((JFreeChartVisualizationSingleDatastreamInput)((Object)this.getInputs().get(i))).getConfiguration();
            if (!config.isPropertyNotSet("color")) {
                Color col = config.getColor();
                renderer.setSeriesPaint(i, (Paint)col);
            } else {
                Color defaultColor = (Color)ChartColor.createDefaultPaintArray()[i];
                renderer.setSeriesPaint(i, (Paint)defaultColor);
            }
            ++i;
        }
    }

    protected PropertyConfigurable createConfiguration() {
        return new JFreeChartVisualizationConfiguration();
    }

    protected abstract Plot generatePlot(PropertyConfigurable var1, AbstractDataset var2);

    protected abstract AbstractDataset generateDataset();
}

