/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.visualization.jfreechart.input.pie;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.apache.commons.lang.mutable.MutableDouble;
import org.eclipse.ui.IMemento;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.palladiosimulator.edp2.datastream.AbstractDataSource;
import org.palladiosimulator.edp2.datastream.IDataSource;
import org.palladiosimulator.edp2.datastream.IDataStream;
import org.palladiosimulator.edp2.datastream.configurable.PropertyConfigurable;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.JFreeChartVisualizationSingleDatastreamInput;
import org.palladiosimulator.edp2.visualization.jfreechart.input.pie.PieChartVisualizationConfiguration;
import org.palladiosimulator.edp2.visualization.jfreechart.input.pie.PieChartVisualizationInputFactory;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.Scale;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;

public class PieChartVisualizationInput
extends JFreeChartVisualizationInput {
    public PieChartVisualizationInput() {
        this((AbstractDataSource)null);
    }

    public PieChartVisualizationInput(AbstractDataSource source) {
    }

    @Override
    public void saveState(IMemento memento) {
        PieChartVisualizationInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return PieChartVisualizationInputFactory.FACTORY_ID;
    }

    @Override
    protected Plot generatePlot(PropertyConfigurable config, AbstractDataset dataset) {
        PieChartVisualizationConfiguration configuration = (PieChartVisualizationConfiguration)config;
        PiePlot3D plot = new PiePlot3D((PieDataset)dataset);
        plot.setNoDataMessage("No data available.");
        plot.setIgnoreNullValues(true);
        plot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator(configuration.isShowRelativeAmount() ? "{0} ({2})" : "{0} ({1})"));
        return plot;
    }

    @Override
    protected AbstractDataset generateDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        HashMap<Comparable, MutableDouble> bins = new HashMap<Comparable, MutableDouble>();
        IDataSource datasource = ((JFreeChartVisualizationSingleDatastreamInput)((Object)this.getInputs().get(0))).getDataSource();
        IDataStream datastream = datasource.getDataStream();
        TupleMeasurement last = null;
        for (TupleMeasurement tuple : datastream) {
            if (last != null) {
                Measure currentTime = tuple.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
                Measure lastTime = last.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
                Comparable state = (Comparable)last.asArray()[1].getValue();
                if (!bins.containsKey(state)) {
                    bins.put(state, new MutableDouble(0.0));
                }
                ((MutableDouble)bins.get(state)).add(currentTime.doubleValue((Unit)SI.SECOND) - lastTime.doubleValue((Unit)SI.SECOND));
            }
            last = tuple;
        }
        for (Comparable o : bins.keySet()) {
            dataset.setValue(o, ((MutableDouble)bins.get(o)).doubleValue());
        }
        return dataset;
    }

    protected Set<String> getPropertyKeysTriggeringUpdate() {
        return Collections.emptySet();
    }

    @Override
    protected PropertyConfigurable createConfiguration() {
        return new PieChartVisualizationConfiguration();
    }

    public boolean canAccept(IDataSource dataSource) {
        BaseMetricDescription[] subMetricDescriptions = MetricDescriptionUtility.toBaseMetricDescriptions((MetricDescription)dataSource.getMetricDesciption());
        if (subMetricDescriptions.length != 2) {
            return false;
        }
        if (subMetricDescriptions[0] != MetricDescriptionConstants.POINT_IN_TIME_METRIC) {
            return false;
        }
        return subMetricDescriptions[1].getScale().compareTo((Enum)Scale.ORDINAL) <= 0;
    }
}

