/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.edp2.models.Repository;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RepositoryStatus implements Enumerator
{
    OPEN(0, "OPEN", "OPEN"),
    CLOSED(1, "CLOSED", "CLOSED"),
    DELETED(2, "DELETED", "DELETED");

    public static final int OPEN_VALUE = 0;
    public static final int CLOSED_VALUE = 1;
    public static final int DELETED_VALUE = 2;
    private static final RepositoryStatus[] VALUES_ARRAY;
    public static final List<RepositoryStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RepositoryStatus[]{OPEN, CLOSED, DELETED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RepositoryStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepositoryStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepositoryStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepositoryStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepositoryStatus get(int value) {
        switch (value) {
            case 0: {
                return OPEN;
            }
            case 1: {
                return CLOSED;
            }
            case 2: {
                return DELETED;
            }
        }
        return null;
    }

    private RepositoryStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

