/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.experimentautomation.application.jobs;

import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.SequentialBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ResourceSetPartition;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.palladiosimulator.experimentautomation.application.utils.EcoreHelper;
import org.palladiosimulator.experimentautomation.application.variation.IVariationStrategy;
import org.palladiosimulator.experimentautomation.application.variation.VariationStrategyFactory;
import org.palladiosimulator.experimentautomation.experiments.ObjectModification;

public class ObjectModificationJob
extends SequentialBlackboardInteractingJob<MDSDBlackboard> {
    private final ObjectModification objectModification;

    public ObjectModificationJob(ObjectModification objectModification) {
        super(false);
        this.objectModification = objectModification;
    }

    public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
        ResourceSetPartition pcmPartition = (ResourceSetPartition)((MDSDBlackboard)this.getBlackboard()).getPartition("org.palladiosimulator.pcmmodels.partition");
        EObject modifiedObject = EcoreHelper.findModelElementById(pcmPartition.getResourceSet(), this.objectModification.getVariedObjectId());
        if (modifiedObject == null) {
            throw new RuntimeException("Unable to find model element with ID " + this.objectModification.getVariedObjectId() + " in resource set");
        }
        if (this.objectModification.getType() == null) {
            EStructuralFeature eStructuralFeature = modifiedObject.eClass().getEStructuralFeature(this.objectModification.getName());
            modifiedObject.eSet(eStructuralFeature, (Object)this.objectModification.getValue());
        } else {
            IVariationStrategy variationStrategy = VariationStrategyFactory.createStrategy(this.objectModification.getType());
            variationStrategy.setVariedObject(modifiedObject);
            variationStrategy.vary(this.objectModification.getValue());
        }
    }
}

