/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.mdsdprofiles.api;

import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelversioning.emfprofile.Profile;
import org.modelversioning.emfprofile.registry.IProfileRegistry;
import org.modelversioning.emfprofileapplication.EMFProfileApplicationFactory;
import org.modelversioning.emfprofileapplication.EMFProfileApplicationPackage;
import org.modelversioning.emfprofileapplication.ProfileApplication;
import org.modelversioning.emfprofileapplication.ProfileImport;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.modelversioning.emfprofileapplication.util.ProfileImportResolver;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.mdsdprofiles.notifier.MDSDProfilesNotifier;

public final class ProfileAPI {
    private ProfileAPI() {
    }

    public static void applyProfile(Resource profileApplicationStore, Profile profile) {
        ProfileApplication profileApplication = ProfileAPI.ensureProfileApplicationExists(profileApplicationStore);
        for (ProfileImport profileImport : profileApplication.getImportedProfiles()) {
            if (!ProfileAPI.isImportedProfile(profile, profileImport)) continue;
            throw new RuntimeException("ApplyProfile failed: Profile \"" + profile.getName() + "\" [" + profile.getNsURI() + "] already applied");
        }
        ProfileImport newProfileImport = EMFProfileApplicationFactory.eINSTANCE.createProfileImport();
        newProfileImport.setProfile(profile);
        newProfileImport.setNsURI(profile.getNsURI());
        newProfileImport.setLocation(profile.eResource().getURI().toString());
        profileApplication.getImportedProfiles().add((Object)newProfileImport);
        profileApplicationStore.eNotify((Notification)new MDSDProfilesNotifier((Notifier)profileApplicationStore, 1000, profile));
    }

    public static void applyProfile(Resource profileApplicationStore, String profileName) {
        LinkedList<Profile> foundProfiles = new LinkedList<Profile>();
        for (Profile profile : ProfileAPI.getApplicableProfiles(profileApplicationStore)) {
            if (!profile.getName().equals(profileName)) continue;
            foundProfiles.add(profile);
        }
        if (foundProfiles.size() == 0) {
            throw new RuntimeException("ApplyProfile based on name failed: Name \"" + profileName + "\" not found in profile registry!");
        }
        if (foundProfiles.size() > 1) {
            throw new RuntimeException("ApplyProfile based on name failed: Name \"" + profileName + "\" is not unique in profile registry!");
        }
        ProfileAPI.applyProfile(profileApplicationStore, (Profile)foundProfiles.get(0));
    }

    public static boolean updateProfileApplications(Resource profileApplicationStore, EList<Profile> profilesToBeApplied) {
        EList<Profile> appliedProfiles = ProfileAPI.getAppliedProfiles(profileApplicationStore);
        LinkedList<Profile> unchanged = new LinkedList<Profile>();
        LinkedList<Profile> additions = new LinkedList<Profile>();
        for (Profile profile : profilesToBeApplied) {
            if (appliedProfiles.contains(profile)) {
                unchanged.add(profile);
                continue;
            }
            additions.add(profile);
        }
        boolean changed = false;
        for (Profile profile : appliedProfiles) {
            if (unchanged.contains(profile)) continue;
            ProfileAPI.unapplyProfile(profileApplicationStore, profile);
            changed = true;
        }
        for (Profile profile : additions) {
            ProfileAPI.applyProfile(profileApplicationStore, profile);
            changed = true;
        }
        return changed;
    }

    public static boolean isProfileApplied(Resource profileApplicationStore, Profile profile) {
        if (!ProfileAPI.hasProfileApplication(profileApplicationStore)) {
            return false;
        }
        for (Profile appliedProfile : ProfileAPI.getAppliedProfiles(profileApplicationStore)) {
            if (!profile.getName().equals(appliedProfile.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isProfileApplied(Resource profileApplicationStore, String profileName) {
        if (!ProfileAPI.hasProfileApplication(profileApplicationStore)) {
            return false;
        }
        LinkedList<Profile> foundProfiles = new LinkedList<Profile>();
        for (Profile profile : ProfileAPI.getAppliedProfiles(profileApplicationStore)) {
            if (!profile.getName().equals(profileName)) continue;
            foundProfiles.add(profile);
        }
        if (foundProfiles.size() == 0) {
            return false;
        }
        if (foundProfiles.size() == 1) {
            return true;
        }
        throw new RuntimeException("ApplyProfile based on name failed: Name \"" + profileName + "\" is not unique in profile registry!");
    }

    public static boolean hasProfileApplication(Resource profileApplicationStore) {
        return ProfileAPI.queryProfileApplication(profileApplicationStore) != null;
    }

    public static ProfileApplication getProfileApplication(Resource profileApplicationStore) {
        ProfileApplication profileApplication = ProfileAPI.queryProfileApplication(profileApplicationStore);
        if (profileApplication == null) {
            throw new RuntimeException("GetProfileApplication failed: Resource with URI \"" + profileApplicationStore.getURI() + "\" has no profile application!");
        }
        for (ProfileImport profileImport : profileApplication.getImportedProfiles()) {
            if (profileImport.getProfile() != null) continue;
            ProfileImportResolver.resolve((ProfileImport)profileImport);
        }
        return profileApplication;
    }

    public static EList<Profile> getApplicableProfiles(Resource profileApplicationStore) {
        BasicEList applicableProfiles = new BasicEList();
        applicableProfiles.addAll(IProfileRegistry.eINSTANCE.getRegisteredProfiles());
        return applicableProfiles;
    }

    public static EList<Profile> getAppliedProfiles(Resource profileApplicationStore) {
        BasicEList appliedProfiles = new BasicEList();
        if (ProfileAPI.hasProfileApplication(profileApplicationStore)) {
            for (ProfileImport profileImport : ProfileAPI.getProfileApplication(profileApplicationStore).getImportedProfiles()) {
                appliedProfiles.add((Object)profileImport.getProfile());
            }
        }
        return appliedProfiles;
    }

    public static void unapplyProfile(Resource profileApplicationStore, Profile profile) {
        EList profileImports = ProfileAPI.getProfileApplication(profileApplicationStore).getImportedProfiles();
        ProfileImport profileImport = null;
        for (ProfileImport profImp : profileImports) {
            if (!ProfileAPI.isImportedProfile(profile, profImp)) continue;
            ProfileAPI.unapplyAllStereotypeApplications(profileApplicationStore, profile);
            profileImport = profImp;
            break;
        }
        if (profileImport == null) {
            throw new RuntimeException("UnapplyProfile failed: Profile \"" + profile.getName() + "\" [" + profile.getNsURI() + "] not found");
        }
        profileImports.remove(profileImport);
        if (profileImports.size() == 0) {
            ProfileAPI.removeProfileApplication(profileApplicationStore);
        }
        profileApplicationStore.eNotify((Notification)new MDSDProfilesNotifier((Notifier)profileApplicationStore, 1001, profile));
    }

    private static ProfileApplication ensureProfileApplicationExists(Resource profileApplicationStore) {
        ProfileApplication profileApplication = ProfileAPI.queryProfileApplication(profileApplicationStore);
        if (profileApplication != null) {
            return profileApplication;
        }
        ProfileApplication newProfileApplication = EMFProfileApplicationFactory.eINSTANCE.createProfileApplication();
        profileApplicationStore.getContents().add((Object)newProfileApplication);
        return newProfileApplication;
    }

    private static ProfileApplication queryProfileApplication(Resource profileApplicationStore) {
        ProfileApplication profileApplication = null;
        for (EObject eObject : profileApplicationStore.getContents()) {
            if (eObject.eClass() != EMFProfileApplicationPackage.eINSTANCE.getProfileApplication()) continue;
            profileApplication = (ProfileApplication)eObject;
            break;
        }
        return profileApplication;
    }

    private static boolean isImportedProfile(Profile profile, ProfileImport profileImport) {
        return profileImport.getNsURI().equals(profile.getNsURI());
    }

    private static void unapplyAllStereotypeApplications(Resource profileApplicationStore, Profile profile) {
        LinkedList stereotypeApplications = new LinkedList();
        stereotypeApplications.addAll(ProfileAPI.getProfileApplication(profileApplicationStore).getStereotypeApplications());
        for (StereotypeApplication stereotypeApplication : stereotypeApplications) {
            if (!stereotypeApplication.getStereotype().getProfile().getNsURI().equals(profile.getNsURI())) continue;
            StereotypeAPI.unapplyStereotype(stereotypeApplication.getAppliedTo(), stereotypeApplication.getStereotype());
        }
    }

    private static void removeProfileApplication(Resource profileApplicationStore) {
        profileApplicationStore.getContents().remove((Object)ProfileAPI.getProfileApplication(profileApplicationStore));
    }
}

