/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.calculator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;

public class RegisterCalculatorFactoryDecorator
implements ICalculatorFactory {
    private final ICalculatorFactory decoratedFactory;
    private final Set<Calculator> calculatorRegister = new HashSet<Calculator>();

    public RegisterCalculatorFactoryDecorator(ICalculatorFactory decoratedFactory) {
        this.decoratedFactory = decoratedFactory;
    }

    public ICalculatorFactory getDecoratedFactory() {
        return this.decoratedFactory;
    }

    public Collection<Calculator> getRegisteredCalculators() {
        return Collections.unmodifiableCollection(this.calculatorRegister);
    }

    public Calculator getCalculatorByMeasuringPointAndMetricDescription(MeasuringPoint mp, MetricDescription metric) {
        Calculator result = null;
        String measuringPointString = mp.getStringRepresentation();
        for (Calculator calc : this.calculatorRegister) {
            if (!calc.isCompatibleWith(metric) || !measuringPointString.equals(calc.getMeasuringPoint().getStringRepresentation())) continue;
            result = calc;
            break;
        }
        return result;
    }

    public Collection<Calculator> getCalculatorsForMeasuringPoint(MeasuringPoint measuringPoint) {
        String measuringPointString = Objects.requireNonNull(measuringPoint, "Measuring point must not be null").getStringRepresentation();
        return this.calculatorRegister.stream().filter(calc -> calc.getMeasuringPoint().getStringRepresentation().equals(measuringPointString)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public void finish() {
        for (Calculator calculator : this.calculatorRegister) {
            calculator.preUnregister();
        }
        this.calculatorRegister.clear();
    }

    private Calculator register(Calculator calculator) {
        if (this.calculatorRegister.contains(calculator)) {
            Calculator found = null;
            for (Calculator calc : this.calculatorRegister) {
                if (!calc.equals(calculator)) continue;
                found = calc;
                break;
            }
            throw new IllegalArgumentException("Calculator \"" + calculator.getClass().getName() + " [" + calculator.getMeasuringPoint().getStringRepresentation() + "; " + calculator.getMetricDesciption().getName() + "]\" already in calculator registry as \"" + found.getClass().getName() + " [" + found.getMeasuringPoint().getStringRepresentation() + "; " + found.getMetricDesciption().getName() + "]\"");
        }
        this.calculatorRegister.add(calculator);
        return calculator;
    }

    @Override
    public Calculator buildResponseTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.register(this.decoratedFactory.buildResponseTimeCalculator(measuringPoint, probes));
    }

    @Override
    public Calculator buildDemandBasedWaitingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.register(this.decoratedFactory.buildDemandBasedWaitingTimeCalculator(measuringPoint, probes));
    }

    @Override
    public Calculator buildWaitingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.register(this.decoratedFactory.buildWaitingTimeCalculator(measuringPoint, probes));
    }

    @Override
    public Calculator buildHoldingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.register(this.decoratedFactory.buildHoldingTimeCalculator(measuringPoint, probes));
    }

    @Override
    public Calculator buildStateOfActiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildStateOfActiveResourceCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildOverallStateOfActiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildOverallStateOfActiveResourceCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildStateOfPassiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildStateOfPassiveResourceCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildOverallStateOfPassiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildOverallStateOfPassiveResourceCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildResourceDemandCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildResourceDemandCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildExecutionResultCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildExecutionResultCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildNumberOfResourceContainersCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildNumberOfResourceContainersCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildReconfigurationTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildReconfigurationTimeCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildCostOverTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildCostOverTimeCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildOptimisationTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildOptimisationTimeCalculator(measuringPoint, probe));
    }

    @Override
    public Calculator buildAggregatedCostOverTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.register(this.decoratedFactory.buildAggregatedCostOverTimeCalculator(measuringPoint, probe));
    }
}

